/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void range_open(void)
{

	/* Create the Window for Simple RangeEditor */
	
	range_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(range_window),10);
	gtk_window_set_title(GTK_WINDOW(range_window),"Simple RangeEditor");
	g_signal_connect(G_OBJECT(range_window),"destroy",G_CALLBACK(rhome_call),NULL);

	range_vbox=gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(range_window),range_vbox);

	range_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(range_vbox),range_hbox,FALSE,FALSE,0);

	/* Simple RangeEditor */
	
	range_label=gtk_label_new("Range Editor:  ");
	range_editor=hildon_range_editor_new();
	gtk_box_pack_start(GTK_BOX(range_hbox),range_label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(range_hbox),range_editor,FALSE,FALSE,0);

	range_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(range_vbox),range_hbox,FALSE,FALSE,0);

	range_prop=gtk_button_new_from_stock(GTK_STOCK_PROPERTIES);
	gtk_box_pack_start(GTK_BOX(range_hbox),range_prop,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(range_prop),"clicked",G_CALLBACK(prop_call),NULL);

	range_home=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_start(GTK_BOX(range_hbox),range_home,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(range_home),"clicked",G_CALLBACK(rhome_call),NULL);

	gtk_widget_show_all(range_window);

}

void rangesep_open(void)
{

	/* Create the Window for RangeEditor with Separator */

	srange_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(srange_window),10);
	gtk_window_set_title(GTK_WINDOW(srange_window),"RangeEditor with Separator");
	g_signal_connect(G_OBJECT(srange_window),"destroy",G_CALLBACK(srhome_call),NULL);

	srange_vbox=gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(srange_window),srange_vbox);

	srange_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(srange_vbox),srange_hbox,FALSE,FALSE,0);

	/* RangeEditor with Separator */

	srange_label=gtk_label_new("Range Editor with Sep:  ");
	srange_editor=hildon_range_editor_new_with_separator("to");
	gtk_box_pack_start(GTK_BOX(srange_hbox),srange_label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(srange_hbox),srange_editor,FALSE,FALSE,0);

	srange_home=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_end(GTK_BOX(srange_vbox),srange_home,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(srange_home),"clicked",G_CALLBACK(srhome_call),NULL);

	gtk_widget_show_all(srange_window);

}

	

