/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void prop_call(void)
{

	/* Create the Window for Properties Page */
	
	PangoFontDescription *font;
	
	prop_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(prop_window),"Properties Page");
	gtk_container_set_border_width(GTK_CONTAINER(prop_window),10);
	g_signal_connect(G_OBJECT(prop_window),"destroy",G_CALLBACK(back_call),NULL);

	prop_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(prop_window),prop_vbox);
	
	prop_frame=gtk_frame_new("Properties");
        gtk_box_pack_start(GTK_BOX(prop_vbox),prop_frame,FALSE,FALSE,0);

        fvbox=gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(prop_frame),fvbox);

	/* Create Entry Boxes */
	
        prop_hbox=gtk_hbox_new(FALSE,5);
        gtk_box_pack_start(GTK_BOX(fvbox),prop_hbox,FALSE,FALSE,0);

	prop_label=gtk_label_new("Text Entry:    ");
	gtk_box_pack_start(GTK_BOX(prop_hbox),prop_label,FALSE,FALSE,0);

	entry_start=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(prop_hbox),entry_start,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(entry_start),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

	entry_end=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(prop_hbox),entry_end,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(entry_end),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

	/* Align the Buttons */

	alignment=gtk_alignment_new(0.5,0.5,0,0);
	gtk_box_pack_start(GTK_BOX(fvbox),alignment,FALSE,FALSE,0);

	prop_hbox=gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(alignment),prop_hbox);

        set_button=gtk_button_new_with_label("Set Range");
        gtk_box_pack_start(GTK_BOX(prop_hbox),set_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_editor_range),NULL);

        get_button=gtk_button_new_with_label("Get Range");
        gtk_box_pack_start(GTK_BOX(prop_hbox),get_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_editor_range),NULL);

        limit_button=gtk_button_new_with_label("Set Limits");
        gtk_box_pack_start(GTK_BOX(prop_hbox),limit_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(limit_button),"clicked",G_CALLBACK(limit_editor_range),NULL);

	font=pango_font_description_from_string("swissa 12");
	
	/* Test Labels for the display of Limits */

        prop_hbox=gtk_hbox_new(FALSE,5);
        gtk_box_pack_start(GTK_BOX(fvbox),prop_hbox,FALSE,FALSE,0);

        label2=gtk_label_new("");
	gtk_widget_modify_font(label2,font);
        gtk_box_pack_start(GTK_BOX(prop_hbox),label2,FALSE,FALSE,0);
	
        prop_hbox=gtk_hbox_new(FALSE,5);
        gtk_box_pack_start(GTK_BOX(fvbox),prop_hbox,FALSE,FALSE,0);

        label3=gtk_label_new("");
	gtk_widget_modify_font(label3,font);
        gtk_box_pack_start(GTK_BOX(prop_hbox),label3,FALSE,FALSE,0);

	prop_back=gtk_button_new_from_stock(GTK_STOCK_GO_BACK);
	gtk_box_pack_end(GTK_BOX(prop_vbox),prop_back,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(prop_back),"clicked",G_CALLBACK(back_call),NULL);

	gtk_widget_show_all(prop_window);

	pango_font_description_free(font);

}
													
										

	
void rhome_call(void)
{

	/* Return to Home Page from the Simple RangeEditor Window */

	gtk_widget_hide(range_window);
	gtk_widget_show(main_window);

}

void srhome_call(void)
{

	/* Return to Home Page from the RangeEditor with Separator Window */

	gtk_widget_hide(srange_window);
	gtk_widget_show(main_window);

}

void back_call(void)
{

	/* Return to Simple RangeEditor Window from the Properties Page */

	gtk_widget_hide(prop_window);
	gtk_widget_show(range_window);

}

void set_editor_range(void)
{

	/* Set the Editor Range with the values from the entry boxes */
	
	gtk_widget_hide(prop_window);
	if(range_editor!=NULL && entry_start!=NULL && entry_end!=NULL)
	{
		gint start,end;
		start=atoi(gtk_entry_get_text(GTK_ENTRY(entry_start)));
		end=atoi(gtk_entry_get_text(GTK_ENTRY(entry_end)));
		hildon_range_editor_set_range(HILDON_RANGE_EDITOR(range_editor),start,end);
	}
	gtk_widget_show(range_window);
			
}

void get_editor_range(void)
{
	/* Get the Editor values */

	gint start,end;
	gchar s_range[30],e_range[30];
	
	hildon_range_editor_get_range(HILDON_RANGE_EDITOR(range_editor),&start,&end);

	sprintf(s_range,"%d",start);
	sprintf(e_range,"%d",end);

	gtk_entry_set_text(GTK_ENTRY(entry_start),s_range);
	gtk_entry_set_text(GTK_ENTRY(entry_end),e_range);
}

void limit_editor_range(void)
{
	
	/* Set the limits of the RangeEditor */
	
	gint start,end;
	gchar min[30],max[30];
	
	if(range_editor!=NULL && entry_start!=NULL && entry_end!=NULL)
	{
		start=atoi(gtk_entry_get_text(GTK_ENTRY(entry_start)));
		end=atoi(gtk_entry_get_text(GTK_ENTRY(entry_end)));
		hildon_range_editor_set_limits(HILDON_RANGE_EDITOR(range_editor),start,end);

		if( RANGE_MAX_INT < start )
			start = RANGE_MAX_INT;

		else if( RANGE_MIN_INT > start )
			start = RANGE_MIN_INT;

		else
	        {}

	        if( RANGE_MAX_INT < end )
		        end = RANGE_MAX_INT;

	        else if( RANGE_MIN_INT > end )
	                end = RANGE_MIN_INT;

	        else
	        {}

		sprintf(min,"\nLeft editor entry:  Min acceptable value = %d",start );
		gtk_label_set_text( GTK_LABEL( label2 ), min );
	        sprintf(max,"\nRight editor entry: Max acceptable value = %d",end);
	        gtk_label_set_text( GTK_LABEL( label3 ), max );
	}
}

gboolean entry_key_pressed( GtkWidget *widget, GdkEventKey *event,
		                                   gpointer data )
{

	/* Restrict the entry of special characters in the entry boxes */
	
	    if (( isdigit(( char ) event->keyval ))||
	            ( event->keyval == GDK_BackSpace )||
	            ( event->keyval == GDK_Left )||( event->keyval == GDK_Right )||
	            ( event->keyval == GDK_Up )||( event->keyval == GDK_Down )||
	            ( event->keyval == GDK_End )||( event->keyval == GDK_Home )||
		    ( event->keyval == GDK_Delete )||( event->keyval == GDK_KP_0 )||
		    ( event->keyval == GDK_KP_1 )||( event->keyval == GDK_KP_2 )||
		    ( event->keyval == GDK_KP_3 )||( event->keyval == GDK_KP_4 )||
		    ( event->keyval == GDK_KP_5 )||( event->keyval == GDK_KP_6 )||
		    ( event->keyval == GDK_KP_7 )||( event->keyval == GDK_KP_8 )||
		    ( event->keyval == GDK_KP_9 )||( event->keyval == GDK_minus )||
		    ( event->keyval == GDK_KP_Subtract ))
		    return FALSE;
	        
	    else
		    return TRUE;
}


