/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"
#include "hildon-widgets/hildon-set-password-dialog.h"
#include "hildon-widgets/hildon-get-password-dialog.h"

char *password;
gchar pd[40];
gchar pd2[40];
gchar dummy[40];

//Action on clicking "Back' button in the second button
void on_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(display_window);
	gtk_widget_show(window);
}

//Creates the second window
void display()
{
	 GtkWidget *d_hbox1;
	 GtkWidget *d_vbox1;
	 GtkWidget *Bback;
	 display_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
         gtk_container_set_border_width(GTK_CONTAINER(display_window), 10);
	 d_hbox1=gtk_hbox_new(FALSE, 0);
	 d_vbox1=gtk_vbox_new(FALSE, 0);
	 Bback=gtk_button_new_with_label("Back");
	 gtk_box_pack_end(GTK_BOX(d_hbox1), Bback, FALSE, 0, 0);
	 gtk_box_pack_end(GTK_BOX(d_vbox1), d_hbox1, FALSE, 0, 0);
	 gtk_container_add(GTK_CONTAINER(display_window), d_vbox1);
	 gtk_signal_connect(GTK_OBJECT(Bback), "clicked", GTK_SIGNAL_FUNC(on_back), NULL);
}
		 

//Action on clicking 'Launch Set Password Dialog' in the main window
void on_set(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_show_all(display_window);
	set_dialog=hildon_set_password_dialog_new(NULL, FALSE);
	gtk_widget_show(set_dialog);
	i=gtk_dialog_run(GTK_DIALOG(set_dialog));
	if (i == GTK_RESPONSE_OK)
	 {
		pwd=hildon_set_password_dialog_get_password(HILDON_SET_PASSWORD_DIALOG(set_dialog));
		sprintf(pd, "%s", pwd);
		strcpy(dummy, pd);
		gtk_label_set_text(GTK_LABEL(Lget_pwd), pwd);
		gtk_widget_hide(display_window);
                gtk_widget_show(window);
			  
	 }
	if (i == GTK_RESPONSE_CANCEL)
	{
                gtk_widget_hide(display_window);
                gtk_widget_show(window);
	}
	 gtk_widget_destroy (GTK_WIDGET(set_dialog));

}

//Action on clicking 'Launch Get Password Dialog' button in the main window
void on_get(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_show_all(display_window);
	get_dialog=hildon_get_password_dialog_new(NULL, FALSE);
	gtk_widget_show(get_dialog);
	i = gtk_dialog_run (GTK_DIALOG (get_dialog));
	password=hildon_get_password_dialog_get_password(HILDON_GET_PASSWORD_DIALOG(get_dialog));
	sprintf(pd2, "%s", password);
	if( i == GTK_RESPONSE_OK)	
	{
		if ( strcmp(pd2, pd)== 0)
		{
			g_print ("comparioson true inside 'get OK'\n");
			gtk_widget_destroy(GTK_WIDGET(get_dialog));
	                gtk_widget_hide(display_window);
	                gtk_widget_show(window);
		}
		else
		{
			gtk_infoprint(window, "Incorrect password ");
			gtk_widget_destroy(get_dialog);
			gtk_widget_hide(display_window);
                        gtk_widget_show(window);
						
		}
	}	
	if (i == GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(GTK_WIDGET(get_dialog));
	        gtk_widget_hide(display_window);
		gtk_widget_show(window);
	}
			 
}

//Action on clicking 'Launch Change Password Dialog' button in the main window
void on_set_change(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_show_all(display_window);
	gboolean protected;
	set_dialog=hildon_set_password_dialog_new(NULL, TRUE);
	gtk_widget_show(set_dialog);
	i = gtk_dialog_run (GTK_DIALOG (set_dialog));
/*       	pwd=hildon_set_password_dialog_get_password(HILDON_SET_PASSWORD_DIALOG(set_dialog));
	sprintf(pd, "%s", pwd);
	protected=hildon_set_password_dialog_get_protected(HILDON_SET_PASSWORD_DIALOG(set_dialog));*/

/*-----FALSE CONDITION OF THE PASSWORD PROTECTED CHECKBOX CANNOT BE REACHED-----*/
/*	        if(protected==TRUE)
		 {
			 gtk_label_set_text(GTK_LABEL(Lpro2), "TRUE");
		 }
		else if(protected==FALSE)
		{
			gtk_label_set_text(GTK_LABEL(Lpro2), "FALSE");
		}*/

	if (i==GTK_RESPONSE_OK)
	{
		g_print("inside OK of set change\n");
		pwd=hildon_set_password_dialog_get_password(HILDON_SET_PASSWORD_DIALOG(set_dialog));
	        sprintf(pd, "%s", pwd);
		protected=hildon_set_password_dialog_get_protected(HILDON_SET_PASSWORD_DIALOG(set_dialog));
				 
		g_print(pd);
		gtk_label_set_text(GTK_LABEL(Lget_pwd1), "New password:");
	        gtk_label_set_text(GTK_LABEL(Lget_pwd), pwd);
		gtk_widget_destroy (GTK_WIDGET(set_dialog));
                gtk_widget_hide(display_window);
		gtk_widget_show(window);
		 
	}
	 else if (i == GTK_RESPONSE_CANCEL)
	 {
		g_print("cancel of set change\n");
		strcpy(pd, dummy); 
		g_print(dummy);
	        gtk_widget_destroy (GTK_WIDGET(set_dialog));
                gtk_widget_hide(display_window);
		gtk_widget_show(window);
			 
	 }
}

//Action on clicking 'Launch Get Old Password Dialog' button in the main window
void on_get_old(GtkWidget *button, gpointer data)
{
	gint i;
	gboolean protected;
	gtk_widget_show_all(display_window);
	get_dialog=hildon_get_password_dialog_new(NULL, TRUE);
	gtk_widget_show(get_dialog);
	gtk_widget_show(display_window);
	i = gtk_dialog_run (GTK_DIALOG (get_dialog));
	password=hildon_get_password_dialog_get_password(HILDON_GET_PASSWORD_DIALOG(get_dialog));
	sprintf(pd2, "%s", password);
/*---------------On clicking OK button of the Get Old Password Dialog------------------*/
         if(i==GTK_RESPONSE_OK)
	 {
		 /*----------------------If Passwords match----------------------------*/
		 if(strcmp(pd2, pd) == 0)
		 {
			 g_print("comaprison true of get old\n");
			    gint i;
         		    gtk_widget_destroy (GTK_WIDGET(get_dialog));
			    /*----------------Launch Change password Dialog------------*/
			    set_dialog=hildon_set_password_dialog_new(NULL, TRUE);
			    gtk_widget_show(set_dialog);
		            i = gtk_dialog_run (GTK_DIALOG (set_dialog));
			    pwd=hildon_set_password_dialog_get_password(HILDON_SET_PASSWORD_DIALOG(set_dialog));
			    sprintf(pd, "%s", pwd);
			    strcpy(dummy, pd);
                                        
/*--------FALSE CONDITION OF THE PASSWORD PROTECTED CHECKBOX CANNOT BE REACHED---------*/			    
/*			    protected=hildon_set_password_dialog_get_protected(HILDON_SET_PASSWORD_DIALOG(set_dialog));
			    if(protected==TRUE)
			    {
				    gtk_label_set_text(GTK_LABEL(Lpro2), "TRUE");
															                  }
			    else if(protected==FALSE)
			    {
				    gtk_label_set_text(GTK_LABEL(Lpro2), "FALSE");
			    }*/
			    
			    /*---If OK button of Change Password Dialog is pressed---------*/
		            if (i==GTK_RESPONSE_OK)
		            {
				    g_print("set change in get old: \n");
				    g_print("new pwd:\n");
				    g_print(pwd);
			            gtk_label_set_text(GTK_LABEL(Lget_pwd1), "New password:");
			            gtk_label_set_text(GTK_LABEL(Lget_pwd), pwd);
			            gtk_widget_destroy (GTK_WIDGET(set_dialog));
			            gtk_widget_destroy(display_window);
                            }
			    
			    /*----If CANCEL button of Change Password Dialog is pressed----*/
		            else if (i == GTK_RESPONSE_CANCEL)
		            {
				    strcpy(pd, dummy);
		                    gtk_widget_destroy (GTK_WIDGET(set_dialog));
		                    gtk_widget_hide(display_window);
	                    }
		  }
		 /*--------------------If passwords do not match---------------------------*/
		 else
		 {
			 gtk_infoprint(window, "Incorrect Password!");
			 gtk_widget_destroy(get_dialog);
			 gtk_widget_hide(display_window);
			 gtk_widget_show(window);
		 }
	 }
/*----------On clicking CANCEL button of Get Old Password dialog---------------------------*/
	 else if(i==GTK_RESPONSE_CANCEL)
	 {
		 gtk_widget_destroy(get_dialog);
		 gtk_widget_hide(display_window);
		 gtk_widget_show(window);
	 }
}

//Action on clicking 'Exit' button in the main window
void on_Exit(GtkWidget *button, gpointer data)
{
	        gtk_main_quit();
}


