/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Creates the second window to display the properties 
void create_second_window(void)
{
	gchar str[]="";
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox1=gtk_hbox_new(FALSE,0);
	s_hbox2=gtk_hbox_new(FALSE,0);
	s_hbox3=gtk_hbox_new(FALSE,0);
	s_hbox4=gtk_hbox_new(FALSE,0);

	set_val=gtk_entry_new();
	set_button=gtk_button_new_with_label("Set Value");
	mod_range=gtk_button_new_with_label("Modify Range to (-20,20)");
	get_button=gtk_button_new_with_label("Get Value");
	lab1=gtk_label_new(" Value: ");
	lab2=gtk_label_new(str);
	back_button=gtk_button_new_with_label("Back");
	gtk_widget_set_usize(GTK_WIDGET(back_button), 250, 40);

	/*--------------------------Signal handlers-------------------------------*/
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_callback),NULL);
	g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_callback),NULL);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(back_callback),NULL);
	g_signal_connect(G_OBJECT(mod_range),"clicked",G_CALLBACK(mod_callback),NULL);
	
	/*--------------------------Packing---------------------------------------*/
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox1,FALSE,FALSE,5);
        gtk_box_pack_start(GTK_BOX(s_hbox1),set_val,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_button,FALSE,FALSE,5);
        gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox2,FALSE,FALSE,5);
        gtk_box_pack_start(GTK_BOX(s_hbox2),mod_range,FALSE,FALSE,0);
        gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox3,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(s_hbox3),get_button,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(s_hbox3),lab1,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(s_hbox3),lab2,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox4,FALSE,FALSE,5);
        gtk_box_pack_start(GTK_BOX(s_hbox4),back_button,FALSE,FALSE,0);
        gtk_container_add(GTK_CONTAINER(s_window),s_vbox);
}

//Creates the main window 	
void create_main_window (void)
{
	h_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(h_window),"destroy",gtk_main_quit,NULL);
	
	vbox=gtk_vbox_new(FALSE,40);
	hbox1=gtk_hbox_new(FALSE,0);
	hbox2=gtk_hbox_new(FALSE,0);
	hbox3=gtk_hbox_new(FALSE,10);

	/*------------Creating a number editor---------------*/
	h_numbereditor=hildon_number_editor_new(-10,10);
	gtk_widget_set_usize(h_numbereditor,160,50);

	property=gtk_button_new_with_label("Set/Get properties");
	quit_button=gtk_button_new_with_label("QUIT");

	/*-----------------------------------------------------*/
	create_second_window();

	g_signal_connect(G_OBJECT(property),"clicked",G_CALLBACK(property_callback),NULL);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);

	/*---------------------PACKING-------------------------*/
	gtk_box_pack_start(GTK_BOX(vbox),hbox1,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox1),h_numbereditor,TRUE,FALSE,30);

	gtk_box_pack_start(GTK_BOX(vbox),hbox2,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox2),property,TRUE,FALSE,20);

	gtk_box_pack_start(GTK_BOX(vbox),hbox3,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(hbox3),quit_button,TRUE,FALSE,20);

	gtk_container_add(GTK_CONTAINER(h_window),vbox);

        gtk_widget_show_all(h_window);
}
