/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Action on clicking 'Set Value' button 
void set_callback(GtkButton *b,gpointer user_data)
{
	gint num;
	num=atoi(gtk_entry_get_text(GTK_ENTRY(set_val)));
	hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(h_numbereditor),num);
	gtk_widget_hide(s_window);
	gtk_widget_show_all(h_window);
}

//Action on clicking 'Get Value' button
void get_callback(GtkButton *b,gpointer user_data)
{
	gchar str[10];
	gint val=hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(h_numbereditor));
	sprintf(str,"%d",val);
	gtk_label_set_text(GTK_LABEL(lab2),str);
}

//Action on clicking 'Set/get Porperties
void property_callback(GtkButton *b,gpointer data)
{
	gtk_widget_hide(h_window);
	gtk_widget_show_all(s_window);
}

//Action on clicking 'Back' button
void back_callback(GtkButton *b,gpointer data)
{
	gtk_widget_hide(s_window);
        gtk_widget_show_all(h_window);
}

//Action on clicking 'Modify Range to (-20,20)' button
void mod_callback(GtkButton *b,gpointer data)
{
	 hildon_number_editor_set_range(HILDON_NUMBER_EDITOR(h_numbereditor),-20,20);
	 gtk_widget_hide(s_window);
         gtk_widget_show_all(h_window);
}
