/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Creates the main window
void main_window()
{
        window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_WINDOW(window), 10);

	vbox1=gtk_vbox_new(FALSE, 10);
	hbox1=gtk_hbox_new(FALSE, 65);
	hbox2=gtk_hbox_new(FALSE, 65);
	hbox3=gtk_hbox_new(FALSE, 65);
	hbox4=gtk_hbox_new(FALSE, 20);
	hbox5=gtk_hbox_new(FALSE, 0);

	 frame=gtk_frame_new(" ");
         gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
         gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);
         gtk_container_add(GTK_CONTAINER(window), frame);

	 Bconfirm=gtk_button_new_with_label("Confirmation Note");
	 align=gtk_alignment_new(0.0, 0.5, 0, 0);
	 gtk_widget_set_usize(GTK_WIDGET(Bconfirm), 250, 40);
	 gtk_container_add(GTK_CONTAINER(align), Bconfirm);
	 gtk_box_pack_start(GTK_BOX(hbox1), align, FALSE, 0, 0);
	 gtk_widget_show(Bconfirm);

	 Bconfirm2=gtk_button_new_with_label("Confirmation note with stock icon");
	 gtk_widget_set_usize(GTK_WIDGET(Bconfirm2), 400, 30);
	 gtk_box_pack_end(GTK_BOX(hbox1), Bconfirm2, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, 0, 0);

	 Bcancel2=gtk_button_new_with_label("Cancel note");
	 gtk_widget_set_usize(GTK_WIDGET(Bcancel2), 250, 40);
	 gtk_box_pack_start(GTK_BOX(hbox2), Bcancel2, FALSE, 0, 0);
	
	 Bcancel=gtk_button_new_with_label("Cancel Note with progress bar");
         align=gtk_alignment_new(0.0, 0.5, 0, 0);
	 gtk_widget_set_usize(GTK_WIDGET(Bcancel), 400, 40);
         gtk_container_add(GTK_CONTAINER(align), Bcancel);
         gtk_box_pack_end(GTK_BOX(hbox2), align, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, 0, 0);
	 gtk_widget_show(Bcancel);

	 Binfo=gtk_button_new_with_label("Information Note");
	 gtk_widget_set_usize(GTK_WIDGET(Binfo), 250, 40);
	 gtk_box_pack_start(GTK_BOX(hbox3), Binfo, FALSE, 0, 0);

	 Binfo2=gtk_button_new_with_label("Information Note with stock icon");
	 gtk_widget_set_usize(GTK_WIDGET(Binfo2), 400, 30);
	 gtk_box_pack_end(GTK_BOX(hbox3), Binfo2, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, 0, 0);

	 Bsystem=gtk_button_new_with_label("System Notes");
         gtk_widget_set_usize(GTK_WIDGET(Bsystem), 250, 40);
         gtk_box_pack_start(GTK_BOX(hbox5), Bsystem, FALSE, 0, 0);

	 Badd=gtk_button_new_with_label("Note with 4 buttons");
	 gtk_widget_set_usize(GTK_WIDGET(Badd), 400, 30);
	 gtk_box_pack_end(GTK_BOX(hbox5), Badd, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox5, FALSE, 0, 0);
	 

	 
	 hsep=gtk_hseparator_new();
	 gtk_box_pack_start(GTK_BOX(vbox1), hsep, FALSE, 0, 0);
	 gtk_widget_show(hsep);

	 Lset=gtk_label_new("Enter the text to be set:");
	 gtk_box_pack_start(GTK_BOX(hbox4), Lset, FALSE, 0, 0);

	 Eset=gtk_entry_new();
	 gtk_widget_set_usize(GTK_WIDGET(Eset), 200, 40);
	 gtk_box_pack_start(GTK_BOX(hbox4), Eset, FALSE, 0, 0);

	 Bset=gtk_button_new_with_label("Set Text");
	 gtk_box_pack_start(GTK_BOX(hbox4), Bset, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox4, FALSE, 0, 0);

         hsep=gtk_hseparator_new();
         gtk_box_pack_start(GTK_BOX(vbox1), hsep, FALSE, 0, 0);
         gtk_widget_show(hsep);

	 align=gtk_alignment_new(0.5, 0.5, 0, 0);
	 Bexit=gtk_button_new_with_label("Exit");
	 gtk_widget_set_usize(GTK_WIDGET(Bexit), 250, 40);
	 gtk_container_add(GTK_CONTAINER(align), Bexit);
	 gtk_box_pack_start(GTK_BOX(vbox1), align, FALSE, 0, 0);
			 
		 
	 gtk_container_add(GTK_CONTAINER(frame), vbox1);

	 /*--------------------------Signal Handlers---------------------------*/
	 gtk_signal_connect(GTK_OBJECT(Bconfirm), "clicked", GTK_SIGNAL_FUNC(on_confirm), window);
	 gtk_signal_connect(GTK_OBJECT(Bcancel), "clicked", GTK_SIGNAL_FUNC(on_cancel), window);
	 gtk_signal_connect(GTK_OBJECT(Bcancel2), "clicked", GTK_SIGNAL_FUNC(on_cancel2), window);
	 gtk_signal_connect(GTK_OBJECT(Bconfirm2), "clicked", GTK_SIGNAL_FUNC(on_confirm2), window);
	 gtk_signal_connect(GTK_OBJECT(Binfo), "clicked", GTK_SIGNAL_FUNC(on_info), window);
	 gtk_signal_connect(GTK_OBJECT(Binfo2), "clicked", GTK_SIGNAL_FUNC(on_info2), window);
	 gtk_signal_connect(GTK_OBJECT(Bset), "clicked", GTK_SIGNAL_FUNC(on_set), window);
	 gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", gtk_main_quit, window);
	 gtk_signal_connect(GTK_OBJECT(Bsystem), "clicked", GTK_SIGNAL_FUNC(on_system), window);
	 gtk_signal_connect(GTK_OBJECT(Badd), "clicked", GTK_SIGNAL_FUNC(on_add), window);
	 gtk_widget_show_all(window);
}


