/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Callback function on clicking back button on the second window
void on_back_button(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(display_window);
	if(flag == 1)
		gtk_widget_show(system_window);
	else
		gtk_widget_show(window);
}

//Creates a widnow to display teh hildon notes
void display()
{
	GtkWidget *back_button, *dvbox, *dhbox;
	dvbox=gtk_hbox_new(FALSE, 0);
	dhbox=gtk_vbox_new(FALSE, 0);
	display_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(display_window), 10);
	back_button=gtk_button_new_with_label("Back");
	gtk_box_pack_end(GTK_BOX(dhbox), back_button, FALSE, 0, 0);
	gtk_box_pack_end(GTK_BOX(dvbox), dhbox, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(display_window), dvbox);
	gtk_signal_connect(GTK_OBJECT(back_button), "clicked", GTK_SIGNAL_FUNC(on_back_button), NULL);
	
	
}
	
//Creates sytsem infomation note
void on_sysinfo(GtkWidget *button, gpointer data)
{
	gint i;
	display();
	gtk_widget_hide(system_window);
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
	note=hildon_note_new_information_with_icon_stock(GTK_WINDOW(display_window), "This device will tell you\n now system information!",   GTK_STOCK_DIALOG_INFO);
        gtk_widget_show(note);
        i=gtk_dialog_run(GTK_DIALOG(note));
        if(i==GTK_RESPONSE_CANCEL)
	{
                gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
		gtk_widget_show(system_window);
		gtk_infoprint(window, "OK pressed");
	}
		
}

//Creates system warning note
void on_syswar(GtkWidget *button, gpointer data)
{
        gint i;
	display();
	gtk_widget_hide(system_window);
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
        note=hildon_note_new_information_with_icon_stock(GTK_WINDOW(display_window), "This is an example of\n a system warning note!",  GTK_STOCK_DIALOG_WARNING);
        gtk_widget_show(note);
        i=gtk_dialog_run(GTK_DIALOG(note));
        if(i==GTK_RESPONSE_CANCEL)
	{
                gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
                gtk_widget_show(system_window);
		gtk_infoprint(window, "OK pressed");
        }
	
}

//Creates system error note				
void on_syserr(GtkWidget *button, gpointer data)
{
        gint i;
	display();
	gtk_widget_hide(system_window);
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
        note=hildon_note_new_information_with_icon_stock(GTK_WINDOW(display_window), "This is an example of\n a system error note!", GTK_STOCK_DIALOG_ERROR );
        gtk_widget_show(note);
        i=gtk_dialog_run(GTK_DIALOG(note));
        if(i==GTK_RESPONSE_CANCEL)
	{
               gtk_widget_destroy(GTK_WIDGET(note));
	       gtk_widget_destroy(display_window);
	       gtk_widget_show(system_window);
	       gtk_infoprint(window, "OK pressed");
	}
}


//Not implemeted since 'WAIT ICON' not present
void on_syswait(GtkWidget *button, gpointer data)
{
	
}

//Action on clicking 'Return' button
void on_sysret(GtkWidget *button, gpointer data)
{
	flag=0;
	gtk_widget_hide(system_window);
	gtk_widget_show(window);
}

//Action on clicking 'System Notes' button
void on_system(GtkWidget *button, gpointer data)
{
	flag=1;
	system_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(system_window), 10);
	
	hbox11=gtk_hbox_new(FALSE, 0);
	hbox12=gtk_hbox_new(FALSE, 0);
	hbox13=gtk_hbox_new(FALSE, 0);
	vbox11=gtk_vbox_new(FALSE, 40);
	
        frame1=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);
        gtk_container_add(GTK_CONTAINER(system_window), frame1);
	
	Bsys_info=gtk_button_new_with_label("System Information Note");
        align=gtk_alignment_new(0.0, 0.5, 0, 0);
        gtk_widget_set_usize(GTK_WIDGET(Bsys_info), 350, 40);
        gtk_container_add(GTK_CONTAINER(align), Bsys_info);
        gtk_box_pack_start(GTK_BOX(hbox11), align, FALSE, 0, 0);

	Bsys_war=gtk_button_new_with_label("System Warning Note");
        gtk_widget_set_usize(GTK_WIDGET(Bsys_war), 300, 40);
        gtk_box_pack_end(GTK_BOX(hbox11), Bsys_war, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox11), hbox11, FALSE, 0, 0);

	Bsys_wait=gtk_button_new_with_label("System Wait Note");
        align=gtk_alignment_new(0.0, 0.5, 0, 0);
	gtk_widget_set_sensitive(Bsys_wait, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(Bsys_wait), 350, 40);
        gtk_container_add(GTK_CONTAINER(align), Bsys_wait);
        gtk_box_pack_start(GTK_BOX(hbox12), align, FALSE, 0, 0);

	Bsys_err=gtk_button_new_with_label("System Error Note");
        gtk_widget_set_usize(GTK_WIDGET(Bsys_err), 300, 40);
        gtk_box_pack_end(GTK_BOX(hbox12), Bsys_err, FALSE, 0, 0);
        gtk_box_pack_start(GTK_BOX(vbox11), hbox12, FALSE, 0, 0);

	Bsys_ret=gtk_button_new_with_label("Return");
	align=gtk_alignment_new(0.5, 0.5, 0, 0);
	gtk_widget_set_usize(GTK_WIDGET(Bsys_ret), 250, 40);
	gtk_container_add(GTK_CONTAINER(align), Bsys_ret);
        gtk_box_pack_start(GTK_BOX(hbox13), align, TRUE, 0, 0);
        gtk_box_pack_start(GTK_BOX(vbox11), hbox13, FALSE, 0, 0);
					
	gtk_container_add(GTK_CONTAINER(frame1), vbox11);
	gtk_widget_show_all(system_window);
	/*--------------------------------Signal Handlers----------------------------------*/
	gtk_signal_connect(GTK_OBJECT(Bsys_ret), "clicked" ,GTK_SIGNAL_FUNC(on_sysret), NULL);
	gtk_signal_connect(GTK_OBJECT(Bsys_info), "clicked" ,GTK_SIGNAL_FUNC(on_sysinfo), NULL);
	gtk_signal_connect(GTK_OBJECT(Bsys_war), "clicked" ,GTK_SIGNAL_FUNC(on_syswar), NULL);
	gtk_signal_connect(GTK_OBJECT(Bsys_err), "clicked" ,GTK_SIGNAL_FUNC(on_syserr), NULL);	
	gtk_signal_connect(GTK_OBJECT(Bsys_wait), "clicked" ,GTK_SIGNAL_FUNC(on_syswait), NULL);


							      
}

//Creates Confirmation Note
void on_confirm(GtkWidget *button, gpointer window)
{
	gint i;
	display();
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
	note=hildon_note_new_confirmation(window, "Are you sure you want to delete? ");
	gtk_widget_show(note);
	 i = gtk_dialog_run (GTK_DIALOG(note));
	if(i == GTK_RESPONSE_OK)
	{
		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
		gtk_widget_show(window);
		gtk_infoprint(window, "YES pressed");
	}
	else if(i == GTK_RESPONSE_CANCEL)
	{

		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
		gtk_widget_show(window);
		gtk_infoprint(window, "NO pressed");
	}

				
}

//Timer function
gint timer_function(gpointer data)
{
	gfloat new_val;
	GtkAdjustment *adj;
        new_val = gtk_progress_get_value( GTK_PROGRESS(data) ) + 1;
	adj = GTK_PROGRESS (data)->adjustment;
	if (new_val > adj->upper)
	      new_val = adj->lower;
        gtk_progress_set_value (GTK_PROGRESS (data), new_val);
        return(TRUE);
} 

//Creates Cancel Note with progress bar
void on_cancel(GtkWidget *button, gpointer window)
{
	gint i;
	display();
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
	progressbar=gtk_progress_bar_new();

	/*--------------------------Animated Progress Bar-------------------------*/
	//gtk_progress_configure(GTK_PROGRESS(progressbar), 0.0, 0.0, 100.0 );
	//timer=gtk_timeout_add (100, timer_function, progressbar);
	/*------------------------------------------------------------------------*/
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar), 0.5);

	note=hildon_note_new_cancel_with_progress_bar(GTK_WINDOW(window), "Deleting files ", GTK_PROGRESS_BAR(progressbar));
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
	if(i==GTK_RESPONSE_CANCEL)
	{
	//	gtk_timeout_remove(timer);
//                gtk_widget_destroy(GTK_WIDGET(progressbar));
//		gtk_widget_destroy(note);
		gtk_widget_destroy(display_window);
		gtk_widget_show(window);
		gtk_infoprint(window, "CANCEL pressed");
		
	}
	gtk_widget_destroy(GTK_WIDGET(progressbar));
	gtk_widget_destroy(note);
}

//Creates Cancel note with a trash icon
void on_cancel2(GtkWidget *button, gpointer window)
{
	gint i;
	display();
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
	note=hildon_note_new_cancel(window, "Emptying trash");
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
	if(i==GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
		gtk_widget_show(window);
		gtk_infoprint(window, "CANCEL pressed");
	}
}

//Creates Confirmation note with an icon from stock
void on_confirm2(GtkWidget *button, gpointer window)
{
	gint i;
	display();
        gtk_widget_hide(window);
        gtk_widget_show_all(display_window);
	note=hildon_note_new_confirmation_with_icon_stock(window, "Lock the file?", GTK_STOCK_DIALOG_AUTHENTICATION);
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
	if(i==GTK_RESPONSE_OK)
	{
		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
                gtk_widget_show(window);
		gtk_infoprint(window, "YES pressed!");
	}
	else if(i==GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
                gtk_widget_show(window);
		gtk_infoprint(window, "NO pressed!");
	}
				 
}

//Creates Information note 
void on_info(GtkWidget *button, gpointer window)
{
	gint i;
	display();
        gtk_widget_hide(window);
        gtk_widget_show_all(display_window);
			
	note=hildon_note_new_information (window, "This is an information note!");
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
	if(i==GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
                gtk_widget_show(window);
		gtk_infoprint(window, "OK pressed");

	}
}

//Creates Information note with a stock icon
void on_info2(GtkWidget *button, gpointer window)
{
	gint i;
	display();
        gtk_widget_hide(window);
        gtk_widget_show_all(display_window);
			
	note=hildon_note_new_information_with_icon_stock(window, "This is an iconed infomation note!",  GTK_STOCK_DIALOG_ERROR);
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
        if(i==GTK_RESPONSE_CANCEL)
	{
                gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
                gtk_widget_show(window);
		gtk_infoprint(window, "OK pressed");

	}
				
		
}

//Action on clicking 'Note with 4 buttons'
void on_add(GtkWidget *button, gpointer data)
{
	gint i;
        display();
        gtk_widget_hide(window);
        gtk_widget_show_all(display_window);
	note=hildon_note_new_confirmation_add_buttons(window,"This is a note with 4 buttons!", "Save",1, "Modify", 2, "Add", 3, "Quit", 4, NULL);
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
	if( i == 1 )
		gtk_infoprint(window, " Save button pressed!");
	else if ( i == 2 )
		gtk_infoprint(window, " Modify button pressed!");
	else if ( i == 3 )
		gtk_infoprint(window, " Add button pressed");
	else if ( i == 4 )
		gtk_infoprint(window, "Quit button pressed");
	//else if(i==-7)
	//	gtk_infoprint(window,"Deleted");
	gtk_widget_destroy(GTK_WIDGET(note));
        gtk_widget_destroy(display_window);
        gtk_widget_show(window);

}

//Action on clicking 'Set Text' button
void on_set(GtkWidget *button, gpointer window)
{
	gint i;
	display();
	gtk_widget_hide(window);
	gtk_widget_show_all(display_window);
	note=hildon_note_new_information (window,"Button text set here! ");
	hildon_note_set_button_text (HILDON_NOTE(note), gtk_entry_get_text(GTK_ENTRY(Eset)) );
	gtk_widget_show(note);
	i=gtk_dialog_run(GTK_DIALOG(note));
	if(i==GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(GTK_WIDGET(note));
		gtk_widget_destroy(display_window);
		gtk_widget_show(window);
		gtk_entry_set_text(GTK_ENTRY(Eset), " ");
	}
}	

