/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

void on_launch(GtkWidget *button, gpointer parent)
{
	dialog = hildon_name_password_dialog_new(parent);
	gint i = gtk_dialog_run(GTK_DIALOG(dialog));
	if( i != GTK_RESPONSE_CANCEL)
	{
		const gchar *str=hildon_name_password_dialog_get_name(HILDON_NAME_PASSWORD_DIALOG(dialog));
		if((*str)=='\0')
		{
			gtk_infoprint(GTK_WINDOW(dialog), "Enter a user name!");
			return; //return if str points to an empty string
		}
		else
		{
			str=hildon_name_password_dialog_get_password(HILDON_NAME_PASSWORD_DIALOG(dialog));
			if((*str)=='\0')
			{
				gtk_infoprint(GTK_WINDOW(dialog), "Enter a password!");
				return;//return if str points to an empty string
			}
		
		if(strcmp("guest", hildon_name_password_dialog_get_name(HILDON_NAME_PASSWORD_DIALOG(dialog)))) 
			gtk_infoprint(GTK_WINDOW(dialog), "Incorrect user name!");
		else if(strcmp("abc123", hildon_name_password_dialog_get_password(HILDON_NAME_PASSWORD_DIALOG(dialog))))
			gtk_infoprint(GTK_WINDOW(dialog), "Incorrect password!");
		}
		
		
	}
	

}

void on_exit(GtkWidget *button, gpointer data)
{
	gtk_main_quit();
}
