/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*---------The window where widget is displayed--------*/
void create_second_window()
{
 s_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 b_box=gtk_vbox_new(FALSE,0);
 back=gtk_button_new_with_label("Back");

 g_signal_connect(G_OBJECT(back),"clicked",G_CALLBACK(b_call),NULL);
 gtk_container_add(GTK_CONTAINER(s_window),b_box);
 gtk_box_pack_end(GTK_BOX(b_box),back,FALSE,FALSE,0);
} 

/*----------Main window---------------*/
void create_main_window (void)
{
	m_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	m_vbox=gtk_vbox_new(FALSE,0);
	m_hbox1=gtk_hbox_new(FALSE,0);
	m_hbox2=gtk_hbox_new(FALSE,0);
	m_hbox3=gtk_hbox_new(FALSE,0);
	m_hbox4=gtk_hbox_new(FALSE,0);
	m_hbox5=gtk_hbox_new(FALSE,0);
	
	launch_button=gtk_button_new_with_label("Launch Insert Object dialog");
	quit_button=gtk_button_new_with_label(" Quit ");
	result=gtk_label_new("");
	name_caption=gtk_label_new("FILE NAME: ");
	name=gtk_label_new("");
	mime_caption=gtk_label_new("MIME type: ");
	mime=gtk_label_new("");

	create_second_window();

	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(m_window),"destroy",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(launch_button),"clicked",G_CALLBACK(launch_callback),NULL);
	
	/*---------------------PACKING-------------------------*/
	gtk_box_pack_start(GTK_BOX(m_vbox),m_hbox1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox2,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox5,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox4,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox3,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox1),launch_button,TRUE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_hbox2),quit_button,TRUE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_hbox3),result,TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox4),name_caption,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox4),name,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox5),mime_caption,FALSE,FALSE,0);
        gtk_box_pack_start(GTK_BOX(m_hbox4),mime,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(m_window),m_vbox);

	gtk_widget_show_all(m_window);
}
