/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*---------	Launches the insert object dialog
 * 		Waits for the user response of click of one of the dialog buttons
 * 		And performs corresponding action	---------*/
void launch_callback(GtkButton *b,gpointer data)
{
	gint response;
	gtk_widget_hide(m_window);
	gtk_widget_show_all(s_window);
	insert_object=hildon_insert_object_dialog_new(GTK_WINDOW(s_window));
	response=gtk_dialog_run(GTK_DIALOG(insert_object));
	if(response==GTK_RESPONSE_OK)
	{
		 gtk_label_set_text(GTK_LABEL(result),"User clicked Insert new");
		 gtk_label_set_text(GTK_LABEL(name),hildon_insert_object_dialog_get_name(HILDON_INSERT_OBJECT_DIALOG(insert_object)));
		 
                 gtk_label_set_text(GTK_LABEL(mime),hildon_insert_object_dialog_get_mime_type(HILDON_INSERT_OBJECT_DIALOG(insert_object)));
		 gtk_widget_hide(insert_object);
		 gtk_widget_hide(s_window);
		 gtk_widget_show_all(m_window);
	}
	else if(response==GTK_RESPONSE_CANCEL)
	{
		gtk_label_set_text(GTK_LABEL(result),"User clicked Cancel");
		gtk_label_set_text(GTK_LABEL(name),"");
                gtk_widget_hide(insert_object);
		gtk_widget_hide(s_window);
		gtk_widget_show_all(m_window);
	}
}

/*-------Displays the main window-------*/
void b_call(GtkButton *b, gpointer data)
{
	gtk_widget_hide(s_window);
	gtk_widget_show(m_window);
}

