/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*-------Creates the properties window-------*/
void create_second_window()
{
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(s_window),"Properties");
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox1=gtk_hbox_new(FALSE,0);
	s_hbox2=gtk_hbox_new(FALSE,0);
	s_hbox3=gtk_hbox_new(FALSE,0);
	
	property_combo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Set Style to smallicons");
	gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Set Style to bigicons");
	gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Get Style ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Activate Add Icons");
        gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Set Scrollbar Position");
        gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Get Scrollbar Position");
        gtk_combo_box_append_text(GTK_COMBO_BOX(property_combo),"Get Emblem Type");
		
			
	gtk_combo_box_set_active(GTK_COMBO_BOX(property_combo),0);

	get_set_button=gtk_button_new_with_label("SET/GET");
	style=gtk_label_new("STYLE : ");	
	label_result=gtk_label_new("");
	back=gtk_button_new_with_label(" Back ");

	g_signal_connect(G_OBJECT(get_set_button),"clicked",G_CALLBACK(set_get_call),NULL);
	g_signal_connect(G_OBJECT(back),"clicked",G_CALLBACK(back_call),NULL);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox1,FALSE,FALSE,30);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox2,FALSE,FALSE,30);
	gtk_box_pack_end(GTK_BOX(s_vbox),s_hbox3,FALSE,FALSE,30);
	gtk_box_pack_start(GTK_BOX(s_hbox1),property_combo,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox1),get_set_button,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox2),style,FALSE,FALSE,20);
	gtk_box_pack_start(GTK_BOX(s_hbox2),label_result,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(s_hbox3),back,TRUE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(s_window),s_vbox);
}

/*-----Creation of the main window containing the widget-------*/
void create_main_window (void)
{
	GList *group=NULL;
	m_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(m_window),"Grid");	
	m_hbox1=gtk_hbox_new(FALSE,0);
	m_hbox2=gtk_hbox_new(FALSE,0);
	m_vbox=gtk_vbox_new(FALSE,0);

	h_grid=hildon_grid_new();
	gtk_widget_set_usize(h_grid,800,350);
	
	/*-----------Grid items---------------*/
	h_g_item1=hildon_grid_item_new_with_label(ICONNAME,"ITEM1");	
	h_g_item2=hildon_grid_item_new_with_label(ICONNAME,"ITEM2");
	h_g_item3=hildon_grid_item_new_with_label(ICONNAME,"ITEM3");
	h_g_item5=hildon_grid_item_new_with_label(ICONNAME,"Testing the ellipsis on long names");
	h_g_item6=hildon_grid_item_new(ICONNAME);
	h_g_item4=hildon_grid_item_new_with_label(ICONNAME,"Add Icons");
	h_g_item7=hildon_grid_item_new_with_label ("Paint", "Set emblem");
	

	/*----------CONTEXTUAL MENU creation--------------*/
	popup = gtk_menu_new ();
	menu_small_icons = gtk_radio_menu_item_new_with_label (group,"Small icons");
        menu_big_icons = gtk_radio_menu_item_new_with_label (
		             gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (menu_small_icons)),"Big icons");
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu_big_icons),
				                                         TRUE);
		                                                                                                                                  
        gtk_widget_show (menu_small_icons);
        gtk_widget_show (menu_big_icons);
        gtk_menu_shell_append (GTK_MENU_SHELL (popup), menu_small_icons);
        gtk_menu_shell_append (GTK_MENU_SHELL (popup), menu_big_icons);
        gtk_widget_tap_and_hold_setup(h_grid, popup,NULL,TRUE);

	g_signal_connect (G_OBJECT (menu_small_icons), "activate",
			                       G_CALLBACK (set_icon_size_call), HILDON_GRID (h_grid));
	g_signal_connect (G_OBJECT (menu_big_icons), "activate",
			                           G_CALLBACK (set_icon_size_call), HILDON_GRID (h_grid));
	     
	/*------------------------------------------------------*/
	
	property=gtk_button_new_with_label("Set/Get Property");
	quit_button=gtk_button_new_with_label("Quit");

	create_second_window();
		
	g_signal_connect(G_OBJECT(m_window),"destroy",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(property),"clicked",G_CALLBACK(property_call),NULL);
	g_signal_connect(h_grid,"activate-child",G_CALLBACK(activate_call),HILDON_GRID_ITEM(h_g_item4));

	/*--------------PACKING--------------------*/
	gtk_container_add(GTK_CONTAINER(m_window),m_vbox);
	gtk_box_pack_start(GTK_BOX(m_vbox),m_hbox1,TRUE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox2,TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox1),h_grid,TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox2),property,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(m_hbox2),quit_button,TRUE,TRUE,0);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item1);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item2);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item3);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item4);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item5);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item6);
	gtk_container_add(GTK_CONTAINER(h_grid),h_g_item7);
	hildon_grid_set_style(HILDON_GRID (h_grid),"bigicons");	
	gtk_widget_show_all(m_window);
}
