/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*--------Activated on the click of property button-------*/
void property_call(GtkButton *b,gpointer data)
{
	gtk_widget_show_all(s_window);
	gtk_label_set_text(GTK_LABEL(label_result),"");
	gtk_widget_hide(m_window);
}

/*--------Activated on set/get button-----------*/
void set_get_call(GtkButton *b,gpointer data)
{
	gint val,pos;
	gchar str[10];
	val=gtk_combo_box_get_active(GTK_COMBO_BOX(property_combo));

	switch(val)
	{
		case 0: hildon_grid_set_style(HILDON_GRID(h_grid),"smallicons");
			gtk_widget_show_all(m_window);
			gtk_widget_hide(s_window);
			break;
		case 1: hildon_grid_set_style(HILDON_GRID(h_grid),"bigicons");
			gtk_widget_show_all(m_window);
			gtk_widget_hide(s_window);
			break;
		case 2: gtk_label_set_text(GTK_LABEL(label_result),hildon_grid_get_style(HILDON_GRID(h_grid)));
			break;
		case 3: hildon_grid_activate_child(HILDON_GRID(h_grid),HILDON_GRID_ITEM(h_g_item4));
			gtk_widget_show_all(m_window);
			gtk_widget_hide(s_window);
			break;
		case 4: hildon_grid_set_scrollbar_pos(HILDON_GRID(h_grid),150);
			gtk_widget_show_all(m_window);
                        gtk_widget_hide(s_window);
			break;
		case 5: pos=hildon_grid_get_scrollbar_pos(HILDON_GRID(h_grid));
			sprintf(str,"%d",pos);
			gtk_label_set_text(GTK_LABEL(label_result),str);
			break;
		case 6: gtk_label_set_text(GTK_LABEL(label_result),hildon_grid_item_get_emblem_type(HILDON_GRID_ITEM(h_g_item7)));
                        break;
			 
	}
}

/*-----------displays the main window------------*/
void back_call(GtkButton *b,gpointer data)
{
	 gtk_widget_show_all(m_window);
         gtk_widget_hide(s_window);
}

void emblem_this (GtkWidget *widget)
{
        const char *emblem;
        emblem = hildon_grid_item_get_emblem_type (HILDON_GRID_ITEM (widget));
        hildon_grid_item_set_emblem_type (HILDON_GRID_ITEM (widget),
                                          emblem == NULL ? "gnome-mime-image-png" : NULL);
	g_print("Here");
}

/*------------To activate the item 'Add icons'---------*/
void activate_call(GtkWidget *grid, GtkWidget *item, gpointer data)
{
	GtkWidget *which_item;
	which_item=GTK_WIDGET(item);
	if(which_item == h_g_item4)
		{
			h_g_item_new=hildon_grid_item_new(ICONNAME);
			gtk_container_add(GTK_CONTAINER(h_grid),h_g_item_new);
		}
	if(which_item == h_g_item7)
		{
			 emblem_this (which_item);
		}
		
}

/*-------------Activated on selection from the contextual menu-------------*/
void set_icon_size_call (GtkMenuItem *item, gpointer data)
{
	HildonGrid *grid;
	grid = HILDON_GRID (data);
	                                                                                                                        
	if (GTK_WIDGET (item) == menu_small_icons)
		hildon_grid_set_style (grid, "smallicons");
	else if (GTK_WIDGET (item) == menu_big_icons)
	        hildon_grid_set_style (grid, "bigicons");
}
		
	
