/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Creates second window
void display()
{
        d_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(d_window), 10);
        back=gtk_button_new_with_label("Back");
        vbox5=gtk_vbox_new(FALSE, 0);
        gtk_box_pack_end(GTK_BOX(vbox5), back, FALSE, 0, 0);
        gtk_container_add(GTK_CONTAINER(d_window), vbox5);
        gtk_signal_connect(GTK_OBJECT(back), "clicked", on_click_back, NULL);
}


//Creates main window
void main_window()
{
         window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
         gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	 /*----creates the second window to display the font selection dialog widget----*/
	 display();	
	 
	 hbox=gtk_hbox_new(FALSE, 0);
	 hbox1=gtk_hbox_new(FALSE, 0);
	 hbox2=gtk_hbox_new(FALSE, 0);
	 hbox3=gtk_hbox_new(FALSE, 0);
	 
	 vbox=gtk_vbox_new(FALSE, 0);

	 frame=gtk_frame_new(" ");
         gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
         gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);
         gtk_container_add(GTK_CONTAINER(window), frame);

	 Blaunch= gtk_button_new_with_label("Launch Hildon Font Selection Dialog");
	 gtk_widget_set_usize(GTK_WIDGET(Blaunch), 500, 40);
	 gtk_box_pack_start(GTK_BOX(hbox), Blaunch, TRUE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, 0, 0);
	 gtk_container_add(GTK_CONTAINER(frame), vbox);

	 Bs_font=gtk_button_new_with_label("Set Font");
	 gtk_widget_set_usize(GTK_WIDGET(Bs_font), 250, 40);
	 gtk_widget_set_sensitive(GTK_WIDGET(Bs_font), FALSE);
	 gtk_box_pack_start(GTK_BOX(hbox3), Bs_font, FALSE, 0, 0);

	 Bs_pre=gtk_button_new_with_label("Set Preview Text");
         gtk_widget_set_usize(GTK_WIDGET(Bs_pre), 250, 40);
	 gtk_widget_set_sensitive(GTK_WIDGET(Bs_pre), FALSE);
         gtk_box_pack_end(GTK_BOX(hbox3), Bs_pre, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox), hbox3, FALSE, 0, 20);
	 

	 Label=gtk_label_new("Preview Text:");
	 gtk_box_pack_start(GTK_BOX(hbox2), Label, FALSE, 0, 20);
	 gtk_widget_show(Label);
	 
	 Lpreview=gtk_label_new(" ");
	 gtk_box_pack_start(GTK_BOX(hbox2), Lpreview,FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, 0, 20);
	 

	 Bexit=gtk_button_new_with_label("Exit");
         gtk_widget_set_usize(GTK_WIDGET(Bexit), 150, 40);
         gtk_box_pack_end(GTK_BOX(hbox1), Bexit, FALSE, 0, 0);
         gtk_box_pack_end(GTK_BOX(vbox), hbox1, FALSE, 0, 0);

	 /*----------------------------Signal handlers------------------------------------*/
	 gtk_signal_connect(GTK_OBJECT(Blaunch), "clicked",GTK_SIGNAL_FUNC(on_launch), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bs_pre), "clicked",GTK_SIGNAL_FUNC(on_set_pre), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bs_font), "clicked",GTK_SIGNAL_FUNC(on_set_font), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bexit), "clicked",GTK_SIGNAL_FUNC(on_exit), NULL);

	 gtk_widget_show_all(window);
}
				    
