/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Action on clicking 'Back' button in the second window
void on_click_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(d_window);
	gtk_widget_show(window);
}

//Action on clicking 'Exit' button
void on_exit(GtkWidget *button, gpointer data)
{
	if(list)
		pango_attr_list_unref( list );
	if(GTK_IS_WIDGET(d_window))
		gtk_widget_destroy(d_window);
	gtk_widget_destroy(window);
	gtk_main_quit();
}

//Action on clicking 'Launch Font Selection Dialog' button
void on_launch(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_hide(window);
	gtk_widget_show_all(d_window);
	gtk_widget_set_sensitive(GTK_WIDGET(Bs_font), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(Bs_pre), TRUE);
        font_dialog=hildon_font_selection_dialog_new(NULL, NULL);
	gtk_widget_show(font_dialog);
	i=gtk_dialog_run(GTK_DIALOG(font_dialog));
	if(i==GTK_RESPONSE_OK)
	{
		gtk_widget_hide(font_dialog);
		gtk_widget_hide(d_window);
		gtk_widget_show(window);
		text=hildon_font_selection_dialog_get_preview_text(HILDON_FONT_SELECTION_DIALOG(font_dialog) );
		gtk_label_set_text(GTK_LABEL(Lpreview), text);
		if(list)
		         pango_attr_list_unref( list );
		         list = hildon_font_selection_dialog_get_font( HILDON_FONT_SELECTION_DIALOG(font_dialog) );

			
		gtk_label_set_attributes( GTK_LABEL(Lpreview), list );
				
	}
	else if(i==GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(font_dialog);
		gtk_widget_hide(d_window);
		gtk_widget_show(window);
		gtk_widget_set_sensitive(GTK_WIDGET(Bs_font), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(Bs_pre), FALSE);
		gtk_label_set_text(GTK_LABEL(Lpreview), " ");
	}
}


//Action on clicking 'Set Preview' button
void on_set_pre(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_hide(window);
	display();
	gtk_widget_show_all(d_window);
	gtk_widget_show(font_dialog);
	hildon_font_selection_dialog_set_preview_text(HILDON_FONT_SELECTION_DIALOG(font_dialog), "Sample");

	i=gtk_dialog_run(GTK_DIALOG(font_dialog));
	if(i==GTK_RESPONSE_OK)
	{
	         gtk_widget_hide(font_dialog);
	         gtk_widget_hide(d_window);
	         gtk_widget_show(window);
	         text=hildon_font_selection_dialog_get_preview_text(HILDON_FONT_SELECTION_DIALOG(font_dialog) );
	         gtk_label_set_text(GTK_LABEL(Lpreview), text);
	         if(list)
	                  pango_attr_list_unref( list );
	        list = hildon_font_selection_dialog_get_font( HILDON_FONT_SELECTION_DIALOG(font_dialog) );
                gtk_label_set_attributes( GTK_LABEL(Lpreview), list );
	}
	else if(i==GTK_RESPONSE_CANCEL)
	{
	        gtk_widget_destroy(font_dialog);
	        gtk_widget_hide(d_window);
	        gtk_widget_show(window);
		gtk_widget_set_sensitive(GTK_WIDGET(Bs_font), FALSE);
                gtk_widget_set_sensitive(GTK_WIDGET(Bs_pre), FALSE);
                gtk_label_set_text(GTK_LABEL(Lpreview), " ");
						
	}
			
}

/*Action on clicking 'Set Font' button
  It relaunches the dialog with the pango attributes retrieved from the preview text previously set*/
void on_set_font(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_hide(window);
        gtk_widget_show_all(d_window);
	gtk_widget_destroy(font_dialog);
	font_dialog=hildon_font_selection_dialog_new(NULL, NULL);
	gtk_widget_show(font_dialog);

	list=gtk_label_get_attributes(GTK_LABEL(Lpreview));
	if (list)
	        hildon_font_selection_dialog_set_font(HILDON_FONT_SELECTION_DIALOG(font_dialog), list);

	i=gtk_dialog_run(GTK_DIALOG(font_dialog));
        if(i==GTK_RESPONSE_OK)
        {
                gtk_widget_hide(font_dialog);
                gtk_widget_hide(d_window);
                gtk_widget_show(window);
	
                text=hildon_font_selection_dialog_get_preview_text(HILDON_FONT_SELECTION_DIALOG(font_dialog) );
                gtk_label_set_text(GTK_LABEL(Lpreview), text);
                if(list)
                        pango_attr_list_unref( list );
                list = hildon_font_selection_dialog_get_font( HILDON_FONT_SELECTION_DIALOG(font_dialog) );
                gtk_label_set_attributes( GTK_LABEL(Lpreview), list );
        }
        else if(i==GTK_RESPONSE_CANCEL)
        {
                gtk_widget_destroy(font_dialog);
                gtk_widget_hide(d_window);
                gtk_widget_show(window);
		gtk_widget_set_sensitive(GTK_WIDGET(Bs_font), FALSE);
                gtk_widget_set_sensitive(GTK_WIDGET(Bs_pre), FALSE);
                gtk_label_set_text(GTK_LABEL(Lpreview), " ");
						
        }
			
	
}
