/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"
#include<string.h>
#include<stdio.h>


void on_find(GtkWidget *button, gpointer data)
{
	g_print("hi");
}

//Function to search the entered text in a file named "input_file.txt"
void search(GtkWidget *dialog)
{
	const gchar *str=NULL;
	gchar s[40];
	gchar buff[80];
	gchar contents[200];
	
	FILE *in;
	int x, flag;
	gchar *return_code;
	gchar line[80];
	contents[0]='\0';
	str=hildon_find_object_dialog_get_text(HILDON_FIND_OBJECT_DIALOG(dialog));

        if(str == NULL || strcmp(str, "")==0)
          {
		  in=fopen ("input_file.txt", "r");
		  if(NULL == in)
                   {
                          puts("Unable to open input file!");
                          return 0;
                   }
		  else
		  {
			  while (!feof(in))
                           {
				   fgets(buff, 80, in);
				   strcat(contents, buff);				  
				   buff[0] = '\0';
				   gtk_label_set_markup(GTK_LABEL(Blabel), contents);
			   }
		  }	
          }
	else
          {
                  in=fopen ("input_file.txt", "r");
                  if(NULL == in)
                   {
                               puts("Unable to open input file!");
                               return 0;
                   }
		  else
                   {
                               while (!feof(in))
                                {
                                         flag=0;
                                         fgets(buff, 80, in);
                                         return_code=strstr(buff, str);
                                         if(return_code != NULL)
                                          {
                                                  flag=1;
                                                  gtk_label_set_markup(GTK_LABEL(Blabel), "Status:<b>Search string Found</b>");
                                                  break;
                                          }
                                         else
	                                          flag=0;
	                         }
	                         if( flag == 0)
		                        gtk_label_set_markup(GTK_LABEL(Blabel), "Status:<b>Search string NOT Found</b>");
		   }
		  fclose(in);
         }
	
											
	
}

//Action on clicking "Launch Hildon FindDialog" / "Show Hildon FileDialog"
void on_launch(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(window);
        gtk_widget_show_all(sec_win);
	
	gchar str[30];
	gchar *s=gtk_button_get_label(GTK_BUTTON(Blaunch));
	sprintf(str,"%s", s);
     if(strcmp(str, "Launch Hildon FindDialog") == 0)
     {		
	gtk_button_set_label(GTK_BUTTON(Blaunch), "Show Hildon FileDialog");
	find_dialog=hildon_find_object_dialog_new(GTK_WINDOW(window));
	hildon_find_object_dialog_set_label(HILDON_FIND_OBJECT_DIALOG(find_dialog), "Enter search key!");
	gtk_widget_show(find_dialog);
	
     }
     else
	     gtk_widget_show(find_dialog);

	i=gtk_dialog_run(GTK_DIALOG(find_dialog));
	if(i == GTK_RESPONSE_OK)
	{
		search(find_dialog);
		gtk_widget_hide(find_dialog);
                gtk_widget_hide(sec_win);
                gtk_widget_show_all(window);
	}
	else
	{
		gtk_label_set_markup(GTK_LABEL(Blabel), "Status:<b> Close button clicked</b>");
		gtk_widget_hide(find_dialog);
                gtk_widget_hide(sec_win);
                gtk_widget_show_all(window);
	}
	
}


//Action on clicking "Launch Hildon FindDialog with Options" / "Show Hildon FindDialog with Options"
void on_launch_options(GtkWidget *button, gpointer data)
{
	gchar str[30];
	gtk_widget_hide(window);
        gtk_widget_show_all(sec_win);
	gchar *s=gtk_button_get_label(GTK_BUTTON(Blaunch_options));
        sprintf(str,"%s", s);
	if(strcmp(str, "Launch Hildon FindDialog with Options") == 0)
	     {
	             gtk_button_set_label(GTK_BUTTON(Blaunch_options), "Show Hildon FindDialog with Options");
		     option_dialog=gtk_dialog_new_with_buttons ("Dialog", window, GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL);
		     find_dialog_op=hildon_find_object_dialog_new_with_options(GTK_WINDOW(window), GTK_DIALOG(option_dialog));
		     
	             hildon_find_object_dialog_set_label(HILDON_FIND_OBJECT_DIALOG(find_dialog_op), "Enter search key!");
	             gtk_widget_show(find_dialog_op);
            }
        else
		gtk_widget_show(find_dialog_op);
        	
		i=gtk_dialog_run(GTK_DIALOG(find_dialog_op));
		if(i == GTK_RESPONSE_OK)
		 {
			 search(find_dialog_op);
			 gtk_widget_hide(find_dialog_op);
			 gtk_widget_hide(sec_win);
        	         gtk_widget_show_all(window);
				 
		 }
		else
		{
			gtk_label_set_markup(GTK_LABEL(Blabel), "Status:<b> Close button clicked</b>");
			gtk_widget_hide(find_dialog_op);
	                gtk_widget_hide(sec_win);
        	        gtk_widget_show_all(window);
		}
										
}

//Action on clicking 'exit' button
void on_exit(GtkWidget *button, gpointer date)
{
	gtk_main_quit();
}

//Action on clicking "Launch Hildon Find & Replace Dialog"
void on_launch_replace(GtkWidget *button, gpointer data)
{
	gint i;
	gtk_widget_hide(window);
        gtk_widget_show_all(sec_win);
	replace_dialog=hildon_find_replace_dialog_new(window, HILDON_REPLACE_NORMAL);
	gtk_widget_show(replace_dialog);
	i=gtk_dialog_run(GTK_DIALOG(replace_dialog));
	g_print("%d", i);
	if( i == GTK_RESPONSE_OK)
	{
		gtk_label_set_markup(GTK_LABEL(Blabel),"User clicked <b>'Find'</b> ");
		gtk_widget_hide(replace_dialog);
                gtk_widget_hide(sec_win);
                gtk_widget_show_all(window);
		
	}

}

//Action on clicking "Launch Hildon Find & Replace Dialog with Options"
void on_launch_replace_options(GtkWidget *button, gpointer data)
{
	gint i;
        gtk_widget_hide(window);
        gtk_widget_show_all(sec_win);
	option_dialog=gtk_dialog_new_with_buttons ("Dialog", window, GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL);
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Rread)))
		replace_dialog_op=hildon_find_replace_dialog_new_with_options(window,GTK_DIALOG(option_dialog) ,HILDON_REPLACE_READ_ONLY);
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Rnormal)))
		replace_dialog_op=hildon_find_replace_dialog_new_with_options(window,GTK_DIALOG(option_dialog) ,HILDON_REPLACE_NORMAL);
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Rimmut)))
		replace_dialog_op=hildon_find_replace_dialog_new_with_options(window,GTK_DIALOG(option_dialog) ,HILDON_REPLACE_IMMUTABLE);
	i=gtk_dialog_run(GTK_DIALOG(replace_dialog_op));
	if(i == GTK_RESPONSE_OK)
		g_print("ok ");
}

//Action on clicking "Back" button
void on_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(sec_win);
        gtk_widget_show_all(window);
}

