/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

/*---------Function to create the second window displaying the properties of Hildon File Selection Widget---------*/
void display_prop_window()
{
	sec_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(sec_window), "Properties");
        gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	s_hbox=gtk_hbox_new(FALSE, 0);
	s_hbox1=gtk_hbox_new(FALSE, 0);
	s_hbox2=gtk_hbox_new(FALSE, 0);
	s_hbox3=gtk_hbox_new(FALSE, 0);
	s_hbox4=gtk_hbox_new(FALSE, 0);
	s_vbox=gtk_vbox_new(FALSE, 0);

	combo_box=gtk_combo_box_new_text();
	gtk_widget_set_usize(GTK_WIDGET(combo_box), 280, 40);
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), "List");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), "Thumbnail");
//	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), 0);
	gtk_signal_connect(GTK_OBJECT(combo_box), "changed", GTK_SIGNAL_FUNC(on_mode_change), NULL);

	gtk_box_pack_end(GTK_BOX(s_hbox),combo_box, FALSE, 0, 10);

	Lmode=gtk_label_new("Set Mode");
        gtk_box_pack_end(GTK_BOX(s_hbox), Lmode, FALSE, 0, 10);

	Lsort=gtk_label_new("Sort by");
	gtk_box_pack_start(GTK_BOX(s_hbox), Lsort, FALSE, 0, 10);

	combo_sortkey=gtk_combo_box_new_text();
	gtk_widget_set_usize(GTK_WIDGET(combo_sortkey), 280, 40);
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Name- Ascending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Name- Descending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Type- Ascending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Type- Descending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Modified- Ascending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Modified- Descending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Size- Ascending");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_sortkey), "Size- Descending");
	gtk_signal_connect(GTK_OBJECT(combo_sortkey), "changed", GTK_SIGNAL_FUNC(on_sortkey_change), NULL);

	gtk_box_pack_start(GTK_BOX(s_hbox),combo_sortkey, FALSE, 0, 10);

	gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox, FALSE, 0, 0);

	hsep=gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(s_vbox), hsep,FALSE, 0, 20);

	Lset=gtk_label_new("Set");
	gtk_box_pack_start(GTK_BOX(s_hbox1), Lset, FALSE, 0, 10);

	combo_set=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Current Folder to Video clips");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Enable-Multiple Selection");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Select all ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Unselect all ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Disable-Multiple Selection");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Filter .xls files ");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Remove filter");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Hide content pane");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Show content pane");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Select file-sheet1.xls");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_set), "Unselect file-sheet1.xls");
	
	gtk_signal_connect(GTK_OBJECT(combo_set), "changed", GTK_SIGNAL_FUNC(on_set_change), NULL);

	gtk_box_pack_start(GTK_BOX(s_hbox1), combo_set, FALSE, 0, 15);
	gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox1, FALSE, 0, 0);

	hsep=gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(s_vbox), hsep,FALSE, 0, 20);

	Lget=gtk_label_new("Get");
	gtk_box_pack_start(GTK_BOX(s_hbox2), Lget,FALSE, 0, 10);

	combo_get=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Current Mode");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Current SortKey");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Current Folder");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Filter used");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Multiple Selection Enabled?");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Selected Paths");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Current Content iter");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo_get), "Current Folder iter");
	gtk_signal_connect(GTK_OBJECT(combo_get), "changed", GTK_SIGNAL_FUNC(on_get_change), NULL);

	gtk_box_pack_start(GTK_BOX(s_hbox2), combo_get, FALSE, 0, 15);
	gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox2, FALSE, 0, 0);

	Lget_value=gtk_label_new("");
	gtk_widget_set_usize(GTK_WIDGET(Lget_value), 600, 100);
	gtk_box_pack_start(GTK_BOX(s_hbox3), Lget_value, FALSE, 0, 10);
        gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox3, FALSE, 0, 15);

	Bback=gtk_button_new_with_label("Back");
	gtk_widget_set_usize(Bback, 120, 40);
	gtk_box_pack_end(GTK_BOX(s_hbox4), Bback, FALSE, 0, 0);
	gtk_box_pack_end(GTK_BOX(s_vbox), s_hbox4, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bback), "clicked", GTK_SIGNAL_FUNC(on_back), NULL);
	
	

	gtk_container_add(GTK_CONTAINER(sec_window), s_vbox);
}
	

/*--------- Function to create the main window displaying the Hildon File Selection widget---------*/
void main_window()
{
	//Creates the second window displaying the properties of the widget
	display_prop_window();
	
	//Creates the main window
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "HildonFileSelection");
        gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	vbox=gtk_vbox_new(FALSE, 0);
	hbox=gtk_hbox_new(FALSE, 0);
	hbox1=gtk_hbox_new(FALSE, 0);

	//Creates the file selection widget
	model = HILDON_FILE_SYSTEM_MODEL(g_object_new(
				  HILDON_TYPE_FILE_SYSTEM_MODEL, "ref-widget", window, NULL));

	
	file_selection = hildon_file_selection_new_with_model(model);
	gtk_widget_set_usize(GTK_WIDGET(file_selection), 770, 300);

	frame=gtk_frame_new("Hildon File Selection ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);
	gtk_container_add(GTK_CONTAINER(frame), file_selection);
			
	gtk_box_pack_start(GTK_BOX(hbox1), frame, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox1, FALSE, 0, 0);

	Bproperties=gtk_button_new_with_label("Properties");
	gtk_widget_set_usize(Bproperties, 120, 40);
	gtk_box_pack_start(GTK_BOX(hbox), Bproperties, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bproperties), "clicked", GTK_SIGNAL_FUNC(on_properties), NULL);

	Bexit=gtk_button_new_with_label("Exit");
	gtk_widget_set_usize(Bexit, 120, 40);
	gtk_box_pack_end(GTK_BOX(hbox), Bexit, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", GTK_SIGNAL_FUNC(on_exit), NULL);

	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	gtk_widget_show_all(window);
}
