/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"


/*------Callback function on clicking 'Exit' button------*/
void on_exit(GtkWidget *button, gpointer data)
{
	gtk_main_quit();
}

/*------Callback function on clicking 'Back' button on the second window------*/
void on_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(sec_window);
	gtk_widget_show_all(window);
}



/*------Callback function on clicking 'Properties' button on the main window------*/
void on_properties(GtkWidget *button, gpointer data)
{
	gtk_widget_show_all(sec_window);	
	gtk_label_set_text(GTK_LABEL(Lget_value), " ");
}

/*------Callback function on selecting the 'Mode'------*/
void on_mode_change(GtkWidget *combo, gpointer data)
{
	gint i;
	i=gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box));
	if( i == 0 )
	{
		hildon_file_selection_set_mode(HILDON_FILE_SELECTION(file_selection), HILDON_FILE_SELECTION_MODE_LIST);
		gtk_widget_hide(sec_window);
		gtk_widget_show_all(window);
		
	}
	else if( i == 1 )
	{
		hildon_file_selection_set_mode(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_MODE_THUMBNAILS);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	
}

/*------Callback function on selecting the 'Sort Key'------*/
void on_sortkey_change(GtkWidget *combo, gpointer data)
{
	gint i;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(combo_sortkey));
	if( i == 0 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection), HILDON_FILE_SELECTION_SORT_NAME,GTK_SORT_ASCENDING); 
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 1 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection), HILDON_FILE_SELECTION_SORT_NAME,GTK_SORT_DESCENDING);
                gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 2 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_SORT_TYPE, GTK_SORT_ASCENDING);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 3 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_SORT_TYPE, GTK_SORT_DESCENDING);
                gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 4 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_SORT_MODIFIED, GTK_SORT_ASCENDING);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 5 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_SORT_MODIFIED, GTK_SORT_DESCENDING);
                gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 6 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_SORT_SIZE, GTK_SORT_ASCENDING);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 7 )
	{
		hildon_file_selection_set_sort_key(HILDON_FILE_SELECTION(file_selection),HILDON_FILE_SELECTION_SORT_SIZE, GTK_SORT_DESCENDING);
                gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
}
	
/*------Callback function on selecting an item from the 'Set' combo box------*/
void on_set_change(GtkWidget *combo, gpointer data)
{
	gint i;
//	file_filter=gtk_file_filter_new();
	i=gtk_combo_box_get_active(GTK_COMBO_BOX(combo_set));
	if( i == 0 )
	{
		hildon_file_selection_set_current_folder(HILDON_FILE_SELECTION(file_selection), "/home/bijjal/MyDocs/.videos", error);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 1 )
	{
		hildon_file_selection_set_select_multiple(HILDON_FILE_SELECTION(file_selection), TRUE);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if(i == 2 )
	{
		if (hildon_file_selection_get_select_multiple(HILDON_FILE_SELECTION(file_selection)) )
		{
			hildon_file_selection_select_all(HILDON_FILE_SELECTION(file_selection));
			gtk_widget_hide(sec_window);
			gtk_widget_show_all(window);
		}
		else
			gtk_label_set_markup(GTK_LABEL(Lget_value), "<b>Multiple Selection NOT set!</b>");
	}
	else if( i == 3 )
	{
		if (hildon_file_selection_get_select_multiple(HILDON_FILE_SELECTION(file_selection)) )
                {
			hildon_file_selection_unselect_all(HILDON_FILE_SELECTION(file_selection));
			gtk_widget_hide(sec_window);
                	gtk_widget_show_all(window);
		}
		else
			gtk_label_set_markup(GTK_LABEL(Lget_value), "<b>Multiple Selection NOT set!</b>");
	}
	else if( i == 4 )
	{
		hildon_file_selection_set_select_multiple(HILDON_FILE_SELECTION(file_selection), FALSE);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 5 )
	{
		file_filter=gtk_file_filter_new();
		gtk_file_filter_add_pattern(GTK_FILE_FILTER(file_filter), "*.xls");
		gtk_file_filter_set_name(GTK_FILE_FILTER(file_filter), ".xls file filter");
		hildon_file_selection_set_filter(HILDON_FILE_SELECTION(file_selection), file_filter);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if(i == 6 )
	{
		hildon_file_selection_set_filter(HILDON_FILE_SELECTION(file_selection),NULL);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 7 )
	{
		hildon_file_selection_hide_content_pane(HILDON_FILE_SELECTION(file_selection));
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 8 )
	{
		hildon_file_selection_show_content_pane(HILDON_FILE_SELECTION(file_selection));
                gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 9)
	{
		gint i;
		i=hildon_file_selection_select_path(HILDON_FILE_SELECTION(file_selection),"/home/bijjal/MyDocs/.documents/sheet1.xls" , error);
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
	else if( i == 10 )
	{
		hildon_file_selection_unselect_path(HILDON_FILE_SELECTION(file_selection), "/home/bijjal/MyDocs/.documents/sheet1.xls");
		gtk_widget_hide(sec_window);
                gtk_widget_show_all(window);
	}
}

/*------Callback function on selecting an item in 'Get' combobox------*/
void on_get_change(GtkWidget *combo, gpointer data)
{
	gint i;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(combo_get));
	if ( i == 0 )
	{
		HildonFileSelectionMode mode;
		mode=hildon_file_selection_get_mode(HILDON_FILE_SELECTION(file_selection));
		if ( mode == 0 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "List");
		else
	                gtk_label_set_text(GTK_LABEL(Lget_value), "Thumbnail");
	}
	else if ( i == 1 )
	{
		HildonFileSelectionSortKey *key;
		GtkSortType *order;
		hildon_file_selection_get_sort_key(HILDON_FILE_SELECTION(file_selection), &key, &order);
		if ( key == 0 )
		{
			if ( order == 0 )
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:Name::ORDER:Ascending");
			else if ( order == 1 )
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:Name::ORDER:Descending");
		}
		else if ( key == 1 )
		{
			if ( order == 0 )
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:MIME type::ORDER:Ascending");
			else if ( order == 1 )
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:MIME type::ORDER:Descending");
		}
		else if  ( key == 2 )
		{
			if ( order == 0 )
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:Modification Time::ORDER:Ascending");
			else
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:Modification Time::ORDER:Descending");
		}
		else if ( key == 3 )
		{
			if ( order == 0 )
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:File Size::ORDER Ascending");
			else
				gtk_label_set_text(GTK_LABEL(Lget_value), "KEY:File Size::ORDER Descending");
				
		}

	}
	else if ( i == 2 )
	{
		GtkFilePath *path;
		path=hildon_file_selection_get_current_folder(HILDON_FILE_SELECTION(file_selection));
		gtk_label_set_text(GTK_LABEL(Lget_value), path);
		gtk_file_path_free(path);
	}
	else if ( i == 3 )
	{
		GtkFileFilter *filter;
		gchar *name;
		gchar s_name[15];
		filter=hildon_file_selection_get_filter(HILDON_FILE_SELECTION(file_selection));
		if(filter == NULL )
			gtk_label_set_text(GTK_LABEL(Lget_value), "No Filter set!");
		else
		{
			name=gtk_file_filter_get_name(GTK_FILE_FILTER(filter));
			sprintf(s_name, "%s", name);
			gtk_label_set_text(GTK_LABEL(Lget_value), s_name);
		}
	}
	else if ( i == 4 )
	{
		gint flag;
		flag=hildon_file_selection_get_select_multiple(HILDON_FILE_SELECTION(file_selection));
		if ( flag == 0 )
			gtk_label_set_text(GTK_LABEL(Lget_value), " FALSE ");
		else if ( flag == 1 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "TRUE ");
	}
	else if ( i == 5 )
	{
		GSList *list;
		list=hildon_file_selection_get_selected_paths(HILDON_FILE_SELECTION(file_selection));
		if(list == NULL)
			gtk_label_set_markup(GTK_LABEL(Lget_value), "No Selection \n<small><b>NOTE:</b> Enable Multiple Selection before selecting files</small>");
		else
		{
			gint len;
			gchar s_len[10];
			gchar *s;
			len=g_slist_length(list);
			sprintf(s_len, "%i", len);
			//g_print(s_len);
			s=g_strjoin(" ",s_len," items selected",NULL);
			g_print(s);
			gtk_label_set_text(GTK_LABEL(Lget_value),s);
		}
	}
	else if ( i == 6 )
	{
		GtkTreeIter *iter;
		gint i;
		gchar s_i[10];
		gchar *s;
		hildon_file_selection_get_current_content_iter(HILDON_FILE_SELECTION(file_selection), &iter);
		sprintf(s_i, "%i", iter );
		s=g_strjoin(" ", "Current Content Iterator is", s_i, NULL);
		gtk_label_set_text(GTK_LABEL(Lget_value),s);
		
	}
	else if ( i == 7 )
	{
		GtkTreeIter *iter;
	        gint i;
	        gchar s_i[10];
	        gchar *s;
		hildon_file_selection_get_current_folder_iter(HILDON_FILE_SELECTION(file_selection), &iter);
		sprintf(s_i, "%i", iter );
		g_print(s_i);
		s=g_strjoin(" ", "Current Folder Iterator is", s_i, NULL);
		gtk_label_set_text(GTK_LABEL(Lget_value),s);
		
	}
	
	
	
}

		

