/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Creates the main window
void main_window()
{
        window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_WINDOW(window), 10);

	hbox1=gtk_hbox_new(FALSE, 0);
	hbox2=gtk_hbox_new(FALSE, 0);
	hbox3=gtk_hbox_new(FALSE, 0);
	vbox1=gtk_vbox_new(FALSE, 40);
	
	frame=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);

	Blaunch=gtk_button_new_with_label("Audio File");
	gtk_widget_set_usize(GTK_WIDGET(Blaunch), 150, 90);
	gtk_box_pack_start(GTK_BOX(hbox1), Blaunch, TRUE, 0, 0);

	Blaunch2=gtk_button_new_with_label("Video File");
	gtk_widget_set_usize(GTK_WIDGET(Blaunch2), 150, 90);
	gtk_box_pack_start(GTK_BOX(hbox1), Blaunch2, TRUE, 0, 0);

	
	Blaunch3=gtk_button_new_with_label("Image File");
	gtk_widget_set_usize(GTK_WIDGET(Blaunch3), 150, 90);
	gtk_box_pack_start(GTK_BOX(hbox1), Blaunch3, TRUE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, 0, 0);

	/*Lread=gtk_label_new("Read only:");
	gtk_widget_set_usize(GTK_WIDGET(Lread), 200, 40);
	gtk_box_pack_start(GTK_BOX(hbox2), Lread, FALSE, 0, 0);
	
	Lread2=gtk_label_new(" ");
	gtk_widget_set_usize(GTK_WIDGET(Lread2), 200, 40);
	gtk_box_pack_start(GTK_BOX(hbox2), Lread2, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, 0, 0);*/
	gtk_container_add(GTK_CONTAINER(frame), vbox1);
        gtk_container_add(GTK_CONTAINER(window), frame);

	align=gtk_alignment_new(0.5, 0.5, 0, 0);
	Bexit=gtk_button_new_with_label("Exit");
	gtk_widget_set_usize(Bexit, 250, 40);
	gtk_container_add(GTK_CONTAINER(align), Bexit);
	gtk_box_pack_start(GTK_BOX(hbox3), align, TRUE, 0, 0);
	gtk_box_pack_end(GTK_BOX(vbox1), hbox3, FALSE, 0, 0);

	g_signal_connect (G_OBJECT (Blaunch), "clicked", G_CALLBACK (rundialogforfile), "audio.mp3");
	g_signal_connect (G_OBJECT (Blaunch2), "clicked", G_CALLBACK (rundialogforfile), "video.avi");
	g_signal_connect (G_OBJECT (Blaunch3), "clicked", G_CALLBACK (rundialogforfile), "image.jpg");
	gtk_signal_connect(G_OBJECT(Bexit), "clicked", gtk_main_quit, NULL);
	gtk_widget_show_all(window);
}



