/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"
#define BYTES_TO_PROCESS 256


void on_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(d_window);
	gtk_widget_show(window);
}


//Creates the second window to display the File Chooser Dialog
void display()
{
	d_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(d_window), 10);
	d_hbox=gtk_hbox_new(FALSE, 0);
	d_vbox=gtk_vbox_new(FALSE,0);
	Bback=gtk_button_new_with_label("Back");
	gtk_box_pack_end(GTK_BOX(d_hbox), Bback, FALSE, 0, 0);
	gtk_box_pack_end(GTK_BOX(d_vbox),d_hbox, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(d_window), d_vbox);
	gtk_signal_connect(GTK_OBJECT(Bback), "clicked", GTK_SIGNAL_FUNC(on_back), NULL);
}

//Action on clicking 'Launch File-chooser-dialog' in the main window
void on_launch(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(window);
	display();
	gtk_widget_show_all(d_window);
	gint i, j;
	j=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
	/*------------------------Switching based on the selection of the options--------------------------*/
	if( j == 0 )
	{
		file_chooser=hildon_file_chooser_dialog_new(GTK_WINDOW(window), GTK_FILE_CHOOSER_ACTION_OPEN);
		i=gtk_dialog_run(GTK_DIALOG(file_chooser));
	        if(i == GTK_RESPONSE_OK )
		{
			gchar *file;
	                GnomeVFSFileSize bytes, w_bytes;
	                gpointer buffer[256];

			file=gtk_file_chooser_get_uri(GTK_FILE_CHOOSER(file_chooser));

                	GnomeVFSResult r=gnome_vfs_open(&handle, file, GNOME_VFS_OPEN_READ);
	                const char *s=gnome_vfs_result_to_string(r);
        	        g_print("OPen the file :%s\n", s);
                	r=gnome_vfs_read(handle, buffer, BYTES_TO_PROCESS, &bytes);
	                s=gnome_vfs_result_to_string(r);
        	        g_print("Buffer Read : %s\n", s);
                	if(r != GNOME_VFS_OK)
                        	return;
			r=gnome_vfs_create (&w_handle, "file:///home/bijjal/MyDocs/foo.txt" , GNOME_VFS_OPEN_WRITE, FALSE, 0777);
        	        s=gnome_vfs_result_to_string(r);
                	g_print("Create output uri : %s\n", s);
	                gnome_vfs_seek (w_handle, GNOME_VFS_SEEK_END, 0);
        	        r=gnome_vfs_write(w_handle, buffer, bytes, w_bytes);
               		s=gnome_vfs_result_to_string(r);
	                g_print("Write into file foo.txt? : %s\n", s);

			gtk_widget_destroy(file_chooser);
        	        gtk_widget_hide(d_window);
	                gtk_widget_show(window);
		}
		else 
		{
			gtk_widget_destroy(file_chooser);
                        gtk_widget_hide(d_window);
                        gtk_widget_show(window);
		}
									
	}
	else if (j == 1 )
		file_chooser=hildon_file_chooser_dialog_new(GTK_WINDOW(window), GTK_FILE_CHOOSER_ACTION_SAVE);
	else if (j == 2 )
		file_chooser=hildon_file_chooser_dialog_new(GTK_WINDOW(window), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	else if (j == 3 )
		file_chooser=hildon_file_chooser_dialog_new(GTK_WINDOW(window), GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER);
	gboolean state;
										
	gtk_widget_show(file_chooser);
	i=gtk_dialog_run(GTK_DIALOG(file_chooser));
	if(i == GTK_RESPONSE_OK )
	{
		gtk_widget_destroy(file_chooser);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
	}
	if(i == GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(file_chooser);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
	}
}

//Action on clicking 'Launch File-chooser-dialog with properties' in the main window
void on_launch1(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(window);
	display();
	gtk_widget_show_all(d_window);
	gint i;
	GtkWidget *w;
	w=gtk_widget_get_ancestor(button, GTK_TYPE_WINDOW);
	i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
	/*---------Creates a File Chooser Dialog with Multiple Selection -----------*/	
	file_chooser = hildon_file_chooser_dialog_new_with_properties(GTK_WINDOW(w), "action", i, "select-multiple", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check)));
	gtk_widget_set_usize(file_chooser, 800, 800);
	gtk_widget_show(file_chooser);

	gboolean state;
        state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	state = gtk_file_chooser_get_select_multiple(GTK_FILE_CHOOSER(file_chooser));
        gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(file_chooser), state);
        state = gtk_file_chooser_get_select_multiple(GTK_FILE_CHOOSER(file_chooser));

	gint k=gtk_dialog_run(GTK_DIALOG(file_chooser));
	if(k == GTK_RESPONSE_OK)
	{
		gtk_widget_destroy(file_chooser);
		gtk_widget_hide(d_window);
		gtk_widget_show(window);
	}
	if(k == GTK_RESPONSE_CANCEL)
	{    
		 gtk_widget_destroy(file_chooser);
		 gtk_widget_hide(d_window);
                 gtk_widget_show(window);
	}
}

