/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Creates main window
void create_main_window (void)
{
	h_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	vbox=gtk_vbox_new(FALSE,0);

	check=gtk_check_button_new_with_label("Display Help Icon");
	launch=gtk_button_new_with_label("Launch Dialog");
	quit_button=gtk_button_new_with_label("Quit..");
	
	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(launch),"clicked",G_CALLBACK(b_call),NULL);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(h_window),"destroy",gtk_main_quit,NULL);
	
	/*---------------------PACKING-------------------------*/
	gtk_box_pack_start(GTK_BOX(vbox),check,FALSE,FALSE,10);	
	gtk_box_pack_start(GTK_BOX(vbox),launch,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(vbox),quit_button,FALSE,FALSE,10);
	
	gtk_container_add(GTK_CONTAINER(h_window),vbox);

	create_sec_window();

	gtk_widget_show_all(h_window);
}

//Creates the second window
void create_sec_window(void)
{

	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(s_window),"Dialog Window");
	g_signal_connect(G_OBJECT(s_window),"destroy",G_CALLBACK(back_call),NULL);
	
	svbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(s_window),svbox);

	back_button=gtk_button_new_with_label("Back");
	gtk_box_pack_end(GTK_BOX(svbox),back_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(back_call),NULL);


}

	
