/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Action on pressing 'OK' button in the dialog
void d_call(GtkDialog *d,gint r,gpointer user_data)
{
	gtk_widget_destroy(dialog);
}

//Action on clicking the help icon on the dialog
void printinfo()
{
	gtk_infoprint(GTK_WINDOW(dialog),"Help Clicked");
}

//Action on clicking 'launch' button in the first window
void b_call(GtkButton *l,gpointer user_data)
{
	
	gtk_widget_hide(h_window);
	gtk_widget_show_all(s_window);
	dialog=gtk_dialog_new();
	
	gtk_window_set_title(GTK_WINDOW(dialog),"Help Tester");
        gtk_widget_set_size_request(GTK_WIDGET(dialog),500,100);
	gtk_dialog_add_buttons(GTK_DIALOG(dialog),GTK_STOCK_OK,GTK_RESPONSE_OK,NULL);
 
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check)))
	{
		gtk_dialog_help_enable(dialog);
		g_signal_connect_swapped(G_OBJECT(dialog), "help",
				      G_CALLBACK(printinfo),NULL);
	}
	
	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(dialog),"response",G_CALLBACK(d_call),NULL);

	gtk_widget_show(dialog);
}

//Action on clicking 'Back' button in the second window
void back_call(void)
{

	gtk_widget_hide(s_window);
	gtk_widget_show_all(h_window);

}

