/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void create_window(void)
{

	GtkWidget *label;
	
	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(main_window),10);
	gtk_window_set_title(GTK_WINDOW(main_window),"Hildon DateEditor");
	g_signal_connect(G_OBJECT(main_window),"destroy",gtk_main_quit,NULL);
	
	vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(main_window),vbox);
	
	date_editor=hildon_date_editor_new();
	gtk_box_pack_start(GTK_BOX(vbox),date_editor,FALSE,FALSE,0);

	hbox=gtk_hbox_new(TRUE,5);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	
	prop_button=gtk_button_new_from_stock(GTK_STOCK_PROPERTIES);
	gtk_box_pack_start(GTK_BOX(hbox),prop_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(prop_button),"clicked",G_CALLBACK(prop_call),NULL);
	
	quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_start(GTK_BOX(hbox),quit_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(quit_button),"clicked",G_CALLBACK(gtk_main_quit),NULL);

	gtk_widget_show_all(main_window);
}
  
