/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"


void prop_call(void)
{

	/* Create the Properties Page */
	
	prop_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(prop_window),10);
	gtk_window_set_title(GTK_WINDOW(prop_window),"Properties Page");
	g_signal_connect(G_OBJECT(prop_window),"destroy",G_CALLBACK(home_call),NULL);

	prop_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(prop_window),prop_vbox);
	
	/* Alignment for the Entry boxes */
	
	align1=gtk_alignment_new(0.5,0.5,0,0);
	gtk_box_pack_start(GTK_BOX(prop_vbox),align1,FALSE,FALSE,0);
	
	/* Alignment for the Buttons */

	align2=gtk_alignment_new(0.5,0.5,0,0);
	gtk_box_pack_start(GTK_BOX(prop_vbox),align2,FALSE,FALSE,0);
	
	prop_hbox=gtk_hbox_new(TRUE,5);
	gtk_container_add(GTK_CONTAINER(align1),prop_hbox);
	
	day_label=gtk_label_new("Day:");
	gtk_box_pack_start(GTK_BOX(prop_hbox),day_label,FALSE,FALSE,0);
	
	day_entry=gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(day_entry),2);
	gtk_entry_set_width_chars(GTK_ENTRY(day_entry),3);
	gtk_box_pack_start(GTK_BOX(prop_hbox),day_entry,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(day_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);
	
	month_label=gtk_label_new("Month:");
	gtk_box_pack_start(GTK_BOX(prop_hbox),month_label,FALSE,FALSE,0);
	
	month_entry=gtk_entry_new();
        gtk_entry_set_max_length(GTK_ENTRY(month_entry),2);
        gtk_entry_set_width_chars(GTK_ENTRY(month_entry),3);
        gtk_box_pack_start(GTK_BOX(prop_hbox),month_entry,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(month_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

        year_label=gtk_label_new("Year:");
        gtk_box_pack_start(GTK_BOX(prop_hbox),year_label,FALSE,FALSE,0);

        year_entry=gtk_entry_new();
        gtk_entry_set_max_length(GTK_ENTRY(year_entry),4);
        gtk_entry_set_width_chars(GTK_ENTRY(year_entry),5);
        gtk_box_pack_start(GTK_BOX(prop_hbox),year_entry,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(year_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

        button_box=gtk_hbutton_box_new();
        gtk_box_set_spacing(GTK_BOX(button_box),0);
        gtk_container_add(GTK_CONTAINER(align2),button_box);

        get_button=gtk_button_new_with_label("Get Date");
        gtk_box_pack_start(GTK_BOX(button_box),get_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_date_call),NULL);
	
        set_button=gtk_button_new_with_label("Set Date");
        gtk_box_pack_start(GTK_BOX(button_box),set_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_date_call),NULL);

        home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
        gtk_box_pack_end(GTK_BOX(prop_vbox),home_button,FALSE,FALSE,0);
        g_signal_connect(G_OBJECT(home_button),"clicked",G_CALLBACK(home_call),NULL);

	gtk_widget_show_all(prop_window);

}

																												
void set_date_call(void)
{
	guint year,month,day;
	HildonDateEditor *date=HILDON_DATE_EDITOR(date_editor);

	day=atoi(gtk_entry_get_text(GTK_ENTRY(day_entry)));
	month=atoi(gtk_entry_get_text(GTK_ENTRY(month_entry)));
	year=atoi(gtk_entry_get_text(GTK_ENTRY(year_entry)));

	
	if(((year!=NULL)&&(month!=NULL)&&(day!=NULL))&&(month<=12)&&(day<=31))
	{
		gtk_widget_hide(prop_window);
		hildon_date_editor_set_date(date,year,month,day);
		gtk_widget_show(main_window);
	}
	else
		gtk_infoprint(GTK_WINDOW(prop_window),"Invalid Date");

}

void get_date_call(void)
{

	gchar dstr[20],mstr[20],ystr[20];
	guint year,month,day;
	HildonDateEditor *date=HILDON_DATE_EDITOR(date_editor);

	hildon_date_editor_get_date(date,&year,&month,&day);

	sprintf(dstr, "%d", day);
	sprintf(mstr, "%d", month);
	sprintf(ystr, "%d", year);

	gtk_entry_set_text(GTK_ENTRY(day_entry), dstr);
	gtk_entry_set_text(GTK_ENTRY(month_entry), mstr);
	gtk_entry_set_text(GTK_ENTRY(year_entry), ystr);

}

gboolean entry_key_pressed(GtkWidget *widget,GdkEventKey *event,gpointer data)
{
	if ((isdigit((char) event->keyval))||(event->keyval == GDK_BackSpace)||
		(event->keyval == GDK_Left)||(event->keyval == GDK_Right)||
		(event->keyval == GDK_Up)||(event->keyval == GDK_Down)||
		(event->keyval == GDK_End)||(event->keyval == GDK_Home)||
		(event->keyval == GDK_Delete)||(event->keyval == GDK_KP_0)||
		(event->keyval == GDK_KP_1)||(event->keyval == GDK_KP_2)||
		(event->keyval == GDK_KP_3)||(event->keyval == GDK_KP_4)||
		(event->keyval == GDK_KP_5)||(event->keyval == GDK_KP_6)||
		(event->keyval == GDK_KP_7)||(event->keyval == GDK_KP_8)||
		(event->keyval == GDK_KP_9))
		return FALSE;
	else
	        return TRUE;
		
}

void home_call(void)
{

	gtk_widget_hide(prop_window);
	gtk_widget_show(main_window);

}


	
