/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include <hildon-widgets/hildon-controlbar.h>
#include <gtk/gtk.h>
#include <gtk/gtkspinbutton.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>

#include <libintl.h>
#define _(String) gettext(String)

/*---------To update the spin button values when values are changed on the controlbar widget------*/
static void ctrlbar_value( GtkWidget *ctrl,
		    GtkWidget *spin )
{
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), 
			    (gdouble)hildon_controlbar_get_value(HILDON_CONTROLBAR(ctrl)));
}

static void spin_set_max( GtkWidget *spin,
	   GtkWidget  *spin2 )
{
  gtk_spin_button_set_range(GTK_SPIN_BUTTON(spin2), 0.0,
			    gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin)));
}

/*----------Activated on value-changed of maximum field spin button---------*/
static void spin_max( GtkWidget *spin,
	       GtkWidget  *ctrl )
{
  hildon_controlbar_set_max(HILDON_CONTROLBAR(ctrl), 
			    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));	
}

/*----------Activated on value-changed of the value field spin button----------*/
static void spin_value( GtkWidget *spin,
		 GtkWidget  *ctrl )
{
  hildon_controlbar_set_value(HILDON_CONTROLBAR(ctrl), 
			      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));	
}

/*-----------This displays the window that contains the test widget and controls--------*/
void _testControlBar(GtkWidget *parent)
{
    GtkWidget *hbox, *vbox, *spin, *spin2;	    
    GtkWidget *ctrlbar = hildon_controlbar_new();	    
    GtkWidget *vbox2 = gtk_vbox_new( FALSE, 0 );
    GtkWidget *quit_button;


    vbox = gtk_vbox_new( FALSE, 2 );
    hbox = gtk_hbox_new( FALSE, 2 );

    gtk_box_pack_start(GTK_BOX(vbox), gtk_label_new(_("maximum:")),
	    TRUE, TRUE, 0 );
    gtk_box_pack_start(GTK_BOX(vbox), gtk_label_new(_("value:")),
	    TRUE, TRUE, 0 );
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(vbox),
	    FALSE, FALSE, 0 );

    vbox = gtk_vbox_new( FALSE, 2 );

    spin = gtk_spin_button_new_with_range(0.0, 100.0, 1.0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), 
	    hildon_controlbar_get_max(HILDON_CONTROLBAR(ctrlbar)));	    
    g_signal_connect(G_OBJECT(spin), "value-changed",
	    G_CALLBACK(spin_max), ctrlbar);

    gtk_box_pack_start(GTK_BOX(vbox), 
	    GTK_WIDGET(spin),
	    TRUE, TRUE, 0 );

    spin2 = spin;
    spin = gtk_spin_button_new_with_range(0.0, hildon_controlbar_get_max(HILDON_CONTROLBAR(ctrlbar)) , 1.0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), 
	    hildon_controlbar_get_value(HILDON_CONTROLBAR(ctrlbar)));	    

    g_signal_connect(spin2, "value-changed",
	    G_CALLBACK(spin_set_max), spin);
    g_signal_connect(ctrlbar, "value-changed",
	    G_CALLBACK(ctrlbar_value), spin);
    g_signal_connect(G_OBJECT(spin), "value-changed",
	    G_CALLBACK(spin_value), ctrlbar);

    gtk_box_pack_start(GTK_BOX(vbox), 
	    GTK_WIDGET(spin),
	    TRUE, TRUE, 0 );
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(vbox),
	    FALSE, FALSE, 0 );

    gtk_widget_show_all( GTK_WIDGET(hbox) );	    
    gtk_widget_show( GTK_WIDGET(ctrlbar) );	    

    gtk_container_add(GTK_CONTAINER(parent), vbox2);

    quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
    g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
    
    gtk_box_pack_start(GTK_BOX(vbox2), 
	    GTK_WIDGET(hbox), TRUE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox2), 
	    GTK_WIDGET(ctrlbar), TRUE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox2),quit_button,TRUE,FALSE,5);

    gtk_widget_show(quit_button);
    gtk_widget_show (vbox2);
}

void create_window()
{
  GtkWidget *window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  _testControlBar(window);
  gtk_widget_show(window);
}
  
