/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Action on clicking 'Exit'
void On_exit(GtkWidget *button, gpointer data)
{
	/*-------------If freed gives a core dump, hence commented------------*/
	/*if(x!=NULL)
		gdk_color_free(x);
	if(color!=NULL)
	gdk_color_free(color);*/
	
	gtk_main_quit();
}

//Action on clicking 'Return' button 
void on_ret(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(display_window);
	gtk_widget_show(window);
	gtk_widget_show(color_sel);
	gint i=gtk_dialog_run(GTK_DIALOG(color_sel));
        if(i==GTK_RESPONSE_OK)
                gtk_widget_hide(color_sel);
        else if(i==GTK_RESPONSE_CANCEL)
	{
                gtk_widget_destroy(color_sel);
		gtk_widget_show(Blaunch);
	}
			
}

//Action on clicking 'Get Color' button
void on_get(GtkWidget *button, gpointer data)
{
	color=hildon_color_selector_get_color(HILDON_COLOR_SELECTOR(color_sel));
	gtk_widget_modify_bg(display_window, GTK_STATE_NORMAL, color);
}

//Action on clicking 'Set Color'
void on_set(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(display_window);
        gtk_widget_show(window);
        gtk_widget_show(color_sel);
	GdkColor p;
	p.pixel=0;
	p.red=65535;
	p.green=0;
	p.blue=0;
	x=&p;
	hildon_color_selector_set_color(HILDON_COLOR_SELECTOR(color_sel), x);
	gint i=gtk_dialog_run(GTK_DIALOG(color_sel));
	if(i==GTK_RESPONSE_OK)
		gtk_widget_hide(color_sel);
	else if(i==GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy(color_sel);
		gtk_widget_show(Blaunch);
	}
}
	
//Action on clicking 'Launch Hildon Color Selector' button
void on_launch(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(Blaunch);
	color_sel=hildon_color_selector_new(NULL);
	gtk_widget_show(color_sel);
	gint i=gtk_dialog_run(GTK_DIALOG(color_sel));
        if(i==GTK_RESPONSE_OK)
                gtk_widget_hide(color_sel);
        else if(i==GTK_RESPONSE_CANCEL)
	{
                gtk_widget_hide(color_sel);
		gtk_widget_show(Blaunch);
	}

}

//Action on clicking 'Properties' button
void on_prop(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(color_sel);
	gtk_widget_hide(window);
	display_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(display_window), 10);

	 hbox3=gtk_hbox_new(FALSE, 0);
	 hbox4=gtk_hbox_new(FALSE, 0);
	 hbox5=gtk_hbox_new(FALSE, 0);
	 vbox2=gtk_vbox_new(FALSE, 40);
	 


	 frame1=gtk_frame_new(" ");
	 gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
	 gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);

	 Bget=gtk_button_new_with_label("Get current color");
	 align=gtk_alignment_new(0.5, 0.5, 0, 0);
	 gtk_widget_set_usize(Bget, 250, 40);
	 gtk_container_add(GTK_CONTAINER(align), Bget);
	 gtk_box_pack_start(GTK_BOX(hbox3), align, TRUE, 0, 0);
	 gtk_widget_show(Bget);

	 Bset=gtk_button_new_with_label("Set Color");
	 align=gtk_alignment_new(0.5, 0.5, 0, 0);
	 gtk_widget_set_usize(Bset, 250, 40);
	 gtk_container_add(GTK_CONTAINER(align), Bset);
	 gtk_box_pack_start(GTK_BOX(hbox4), align, TRUE , 0, 0);
	 gtk_widget_show(Bset);

	 Bret=gtk_button_new_with_label("Return");
	 align=gtk_alignment_new(0.5, 0.5, 0, 0);
         gtk_widget_set_usize(Bret, 250, 40);
         gtk_container_add(GTK_CONTAINER(align), Bret);
         gtk_box_pack_start(GTK_BOX(hbox5), align, TRUE , 0, 0);
         gtk_widget_show(Bret);


	 gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox2), hbox4, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox2), hbox5, FALSE, 0, 0);
	 gtk_container_add(GTK_CONTAINER(frame1), vbox2);
	 gtk_container_add(GTK_CONTAINER(display_window), frame1);

	 /*---------------------------Signal Handlers----------------------------*/
	 gtk_signal_connect(GTK_OBJECT(Bret), "clicked", GTK_SIGNAL_FUNC(on_ret), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bget), "clicked", GTK_SIGNAL_FUNC(on_get), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bset), "clicked", GTK_SIGNAL_FUNC(on_set), NULL);
	 gtk_widget_show_all(display_window);
}
	      
	   
