/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Creates the get menu
void  create_getmenu(GtkWidget* table)
{
	gchar *menu_items_text[]={"Icon","Label","Size group","Status","Is Caption Mandatory"};
	  
	GtkWidget* menu_item[7];
	gint i;
	GtkWidget* caption_menu = gtk_menu_new();
        for(i = 0;i < 5;i++)
	{
		menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (caption_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        h_optionmenu2 = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (h_optionmenu2), caption_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (h_optionmenu2), 1);
        gtk_widget_set_usize(h_optionmenu2,200,40);
        gtk_table_attach(GTK_TABLE(table), h_optionmenu2, 0, 1, 2, 3,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (h_optionmenu2);


}


//Creates the menu for 'Select Properties' 
void  create_menu(GtkWidget* table)
{
        GtkWidget* menu_item[7];
	GtkWidget* caption_menu = gtk_menu_new();
	 /* Create the menu items */
        if(flag == 0)
	{
    		menu_item[0] = gtk_menu_item_new_with_label ("Button Control");
	}
	else
	{
		menu_item[0] = gtk_menu_item_new_with_label ("Entry Control");
	}

        if(hildon_caption_get_icon_image(HILDON_CAPTION(h_captioncontrol1)) == NULL)
	{
    		menu_item[1] = gtk_menu_item_new_with_label ("Put icon");
	}
	else
	{
    		menu_item[1] = gtk_menu_item_new_with_label ("Remove icon");
	}
        if(strcmp(hildon_caption_get_label(HILDON_CAPTION(h_captioncontrol1)),"Enter ID") == 0)
	{ 
    		menu_item[2] = gtk_menu_item_new_with_label ("label \"Enter Full Name\"");
	}
	else
	{
		menu_item[2] = gtk_menu_item_new_with_label ("label \"Enter ID\"");
	}
	/*if(hildon_caption_get_separator_char(HILDON_CAPTION(h_captioncontrol1)) == '$')
	{
    		menu_item[3] = gtk_menu_item_new_with_label ("Use separator :");
	}
	else
	{
    		menu_item[3] = gtk_menu_item_new_with_label ("Use separator $");
	}*/
        
	if(hildon_caption_get_sizegroup(HILDON_CAPTION(h_captioncontrol1)) == NULL)
	{
    		menu_item[3] = gtk_menu_item_new_with_label ("Enable Size Group");
	}
	else
	{
		menu_item[3] = gtk_menu_item_new_with_label ("Disable Size Group");
	}

        if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
	{
    		menu_item[4] = gtk_menu_item_new_with_label ("Status: Optional");

	}
	else
	{ 
    		menu_item[4] = gtk_menu_item_new_with_label ("Status: Mandatory");
	}
    		
	menu_item[5] = gtk_menu_item_new_with_label ("Get Control & Set Text");

        gint i;
        for(i=0;i<6;i++)
	{
    		/* Add them to the menu */
    		gtk_menu_append (GTK_MENU (caption_menu), menu_item[i]);
		/* We do need to show menu items */
    		gtk_widget_show (menu_item[i]);
	}

	h_optionmenu1 = gtk_option_menu_new ();
      	gtk_option_menu_set_menu (GTK_OPTION_MENU (h_optionmenu1), caption_menu);
      	gtk_option_menu_set_history (GTK_OPTION_MENU (h_optionmenu1), 1);
	gtk_widget_set_usize(h_optionmenu1,200,40);
	gtk_table_attach(GTK_TABLE(table), h_optionmenu1, 1, 2, 0, 1,GTK_SHRINK,GTK_EXPAND,0,0);
    	gtk_widget_show (h_optionmenu1);
	 
}


//Creates the second window
GtkWidget*
create_window (void)
{
	GtkWidget *table;
	h_captionwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 	/* Sets the border width of the window. */
    	gtk_container_set_border_width (GTK_CONTAINER (h_captionwindow), 10);
	table = gtk_table_new (4, 2, TRUE);
        gtk_container_add (GTK_CONTAINER (h_captionwindow), table);	
        GtkWidget *label1 = gtk_label_new("Select Properties:");
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_FILL);
	gtk_table_attach(GTK_TABLE(table), label1, 0, 1, 0, 1,GTK_SHRINK,GTK_EXPAND,0,0);
        create_menu(table);	
        GtkWidget *hset_button = gtk_button_new_with_label("Set it now");
	gtk_widget_set_usize(hset_button,150,40);
	gtk_table_attach(GTK_TABLE(table), hset_button, 0, 2, 1, 2,GTK_SHRINK,GTK_EXPAND,0,0);
	g_signal_connect (G_OBJECT(hset_button), "clicked",
                    	G_CALLBACK (setbutton_callback),
                    	NULL);
        create_getmenu(table);
        /* Create Get Button*/
        GtkWidget *hget_button = gtk_button_new_with_label("Get it now");
	gtk_widget_set_usize(hget_button,150,40);
	gtk_table_attach(GTK_TABLE(table), hget_button, 0, 2, 3, 4,GTK_SHRINK,GTK_EXPAND,0,0);
	g_signal_connect (G_OBJECT(hget_button), "clicked",
                    	G_CALLBACK (getbutton_callback),
                    	NULL);
	h_getentry = gtk_entry_new ();
	gtk_widget_set_usize(h_getentry, 200, 40);
	gtk_table_attach(GTK_TABLE(table), h_getentry, 1, 2, 2, 3,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show(hset_button);
        gtk_widget_show(h_getentry);
        gtk_widget_show(hget_button);
	gtk_widget_show(label1);
	gtk_widget_show(table);
        gtk_widget_show(h_captionwindow);
}

//Creates the main window
GtkWidget*
create_main_window(void)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
        flag = 0;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);

       	vbox = gtk_vbox_new (FALSE, 20);
	hbox = gtk_hbox_new ( FALSE, 0);
	hbox1 = gtk_hbox_new (FALSE, 0);
       	entry = gtk_entry_new ();
       	h_captioncontrol1 = hildon_caption_new( NULL, "Enter Full Name",
                                                     entry, NULL, HILDON_CAPTION_OPTIONAL);
	g_signal_connect(G_OBJECT(entry),"changed",G_CALLBACK(changed_entry),NULL);
       	gtk_box_pack_start (GTK_BOX (vbox), h_captioncontrol1, FALSE, FALSE, 10);

	GtkWidget *control = gtk_check_button_new();
       	h_captioncontrol2 = hildon_caption_new( NULL, "Toggle Button",
                                                     control, NULL, HILDON_CAPTION_OPTIONAL);

       	gtk_box_pack_start (GTK_BOX (vbox), h_captioncontrol2, FALSE, FALSE,10);

	button = gtk_button_new_with_label("Get & Set Properties");
	gtk_widget_set_usize(GTK_WIDGET(button), 300, 40);
	g_signal_connect (G_OBJECT(button), "clicked",
                    	G_CALLBACK (show_main_window),
                    	NULL);
       	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	exit_button = gtk_button_new_with_label("Exit");
	gtk_widget_set_usize(GTK_WIDGET(exit_button), 300, 40);
	g_signal_connect(G_OBJECT(exit_button), "clicked", G_CALLBACK(exit_clicked), NULL);
	gtk_box_pack_end (GTK_BOX(hbox), exit_button, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
       	gtk_widget_show_all (GTK_WIDGET (vbox));
	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_widget_show(window);
}

