/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"
#include "string.h"

//Action on clicking 'Exit' button
void 
exit_clicked(GtkButton *button, gpointer user_data)
 {
	 gtk_main_quit();
 }

//Callback attached to 'changed entry' event 
void
changed_entry(GtkEntry *entry, gpointer data)
{
	entry_flag=1;
}

//Action on clicking 'Get & Set Properties' button
void
show_main_window(GtkButton *button, gpointer user_data)
{
	if(hildon_caption_get_status(HILDON_CAPTION(h_captioncontrol1)) == HILDON_CAPTION_MANDATORY)
	{
		if(entry_flag==0)
			gtk_infoprint(window, "Mandatory field\n Cannot be left blank");
		else if(entry_flag==1)
		{
			 create_window();
                         gtk_widget_hide(window);
                         gtk_entry_set_text(GTK_ENTRY(entry)," ");
		}
											 
			
	}
	
	else
	{
        entry_flag=0;
	create_window();
	gtk_widget_hide(window);
	}
}

//Action on clicking 'Set it now' button
void
setbutton_callback(GtkButton *button, gpointer user_data)
{
        GtkWidget* icon_image = NULL;
        GtkWidget* caption_button;
	GtkWidget *control;

	gint menu_indx = gtk_option_menu_get_history(GTK_OPTION_MENU(h_optionmenu1));

        switch(menu_indx)
	{
		case 0:
		    if(flag == 0)
		    {
		    	flag = 1;
                    	caption_button = gtk_button_new_with_label("Hello"); 
			gtk_widget_set_usize(GTK_WIDGET(caption_button), 200, 35);
		    	hildon_caption_set_control(HILDON_CAPTION(h_captioncontrol1),caption_button);
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
								                                       					hildon_caption_set_status(HILDON_CAPTION(h_captioncontrol1),HILDON_CAPTION_OPTIONAL);

		    	gtk_widget_show(caption_button);
		    }
		    else
	            {
			flag = 0;
                        GtkWidget *entry = gtk_entry_new ();
			hildon_caption_set_control(HILDON_CAPTION(h_captioncontrol1),entry);
			gtk_widget_show(entry);
		    }
                    break;
		case 1:
		    if(hildon_caption_get_icon_image(HILDON_CAPTION(h_captioncontrol1)) == NULL)
		    {
		    	icon_image= gtk_image_new_from_stock("gtk-ok",GTK_ICON_SIZE_SMALL_TOOLBAR);
		    	hildon_caption_set_icon_image(HILDON_CAPTION(h_captioncontrol1),icon_image);
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
			 {
				control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
				if(control != NULL)
	                         {
				   if(flag==0)	 
				      entry_flag=0;
				 }
			 }	
                    }
		    else
		    {
		    	hildon_caption_set_icon_image(HILDON_CAPTION(h_captioncontrol1),NULL);
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
			    {
			       control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
			       if(control != NULL)
			           {
			              if(flag==0)
			                    entry_flag=0;
			           }
			    }

		    }
                    break;
		case 2:
		    if(strcmp(hildon_caption_get_label(HILDON_CAPTION(h_captioncontrol1)),"Enter ID") == 0)
		    {
		    	hildon_caption_set_label(HILDON_CAPTION(h_captioncontrol1),"Enter Full Name");		
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
			  {
			      control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
			       if(control != NULL)
			         {
			             if(flag==0)
			               entry_flag=0;
			         }
			   }

		    }
		    else
		    {
		    	hildon_caption_set_label(HILDON_CAPTION(h_captioncontrol1),"Enter ID");	
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
			  {
			     control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
			     if(control != NULL)
			      {
			         if(flag==0)
			          entry_flag=0;
			      }
			  }

		    }
                    break;
		case 3:
		    if(hildon_caption_get_sizegroup(HILDON_CAPTION(h_captioncontrol1)) == NULL)
		    {
			GtkSizeGroup *group= GTK_SIZE_GROUP( gtk_size_group_new( GTK_SIZE_GROUP_HORIZONTAL ) );
			hildon_caption_set_sizegroup(HILDON_CAPTION(h_captioncontrol1),group);
			hildon_caption_set_sizegroup(HILDON_CAPTION(h_captioncontrol2),group);
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
			   {
			       control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
			      if(control != NULL)
			       {
			          if(flag==0)
			             entry_flag=0;
			       }
			   }

		    }
		    else
		    {
			hildon_caption_set_sizegroup(HILDON_CAPTION(h_captioncontrol1),NULL);
                        hildon_caption_set_sizegroup(HILDON_CAPTION(h_captioncontrol2),NULL);
			if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
			   {
			      control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
			      if(control != NULL)
			        {
			            if(flag==0)
			              entry_flag=0;
			         }
			   }

		    }
                    break;
		case 4:
                    if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
		    {
		    	hildon_caption_set_status(HILDON_CAPTION(h_captioncontrol1),HILDON_CAPTION_OPTIONAL);
		    }
		    else
		    {
		    	hildon_caption_set_status(HILDON_CAPTION(h_captioncontrol1),HILDON_CAPTION_MANDATORY);
			entry_flag=0;
		    }
                    break;
		case 5:
		   control = hildon_caption_get_control(HILDON_CAPTION(h_captioncontrol1));
		   if(control != NULL)
		   {
                        if(flag == 0)
                        {
				gtk_entry_set_text(GTK_ENTRY(control),"Test Control");
			} 
			else
			{
		         	gtk_button_set_label(GTK_BUTTON(control),"Test Control");
			}
		    }
		default:
 		    break;	
	}
       
	gtk_widget_hide(h_captionwindow);	
	gtk_widget_show(window);
}



//Action on clicking 'Get it now' button
void
getbutton_callback(GtkButton *button, gpointer user_data)
{

	gint menu_indx = gtk_option_menu_get_history(GTK_OPTION_MENU(h_optionmenu2));
        gchar sep;	
        gchar buff[2];
	
        switch(menu_indx)
	{
		case 0:
                   if(hildon_caption_get_icon_image(HILDON_CAPTION(h_captioncontrol1)) == NULL)
		   {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"No Icon");
		   }
		   else
		   {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"Icon is set");
		   }
		   break;
		case 1:
		   gtk_entry_set_text(GTK_ENTRY(h_getentry),hildon_caption_get_label(HILDON_CAPTION(h_captioncontrol1)));
		   break;

		case 2:
		   if(hildon_caption_get_sizegroup(HILDON_CAPTION(h_captioncontrol1)) == NULL)
		   {
                  	gtk_entry_set_text(GTK_ENTRY(h_getentry),"group disabled");
		   }
		   else
		   {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"group enabled");
                   }
		   break;
		case 3:
		   if(hildon_caption_get_status(HILDON_CAPTION(h_captioncontrol1)) == HILDON_CAPTION_OPTIONAL)
		   {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"Optional");
		   }
                   else
	           {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"Mandatory");
                   }
		   break;
		case 4:
		   if(hildon_caption_is_mandatory(HILDON_CAPTION(h_captioncontrol1)))
		   {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"Mandatory");
		   }
                   else
	           {
			gtk_entry_set_text(GTK_ENTRY(h_getentry),"Optional");
                   }
		   break;
                default:
		   break;
      }
}
