/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void create_window(void)
{

	GtkWidget *quit_button;
	
	/* Create Main Window */
	
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(window),10);
	gtk_window_set_title(GTK_WINDOW(window),"Calendar App");
	g_signal_connect(G_OBJECT(window),"destroy",gtk_main_quit,NULL);

	vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);

	align1=gtk_alignment_new(0.5,0.5,0,0);
	gtk_box_pack_start(GTK_BOX(vbox),align1,FALSE,FALSE,0);
	
	cal_button=gtk_button_new_with_label("View Calendar");
	gtk_container_add(GTK_CONTAINER(align1),cal_button);
	g_signal_connect(G_OBJECT(cal_button),"clicked",G_CALLBACK(view_calendar),NULL);
	
	align2=gtk_alignment_new(0.5,0.5,0,0);
	gtk_box_pack_start(GTK_BOX(vbox),align2,FALSE,FALSE,0);
	
	hbox=gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(align2),hbox);
	
	/* Entry boxes used for display of the selected dates and for user entry */
	
	year_label=gtk_label_new("Year :");
	gtk_box_pack_start(GTK_BOX(hbox),year_label,FALSE,FALSE,0);

	year_entry=gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(year_entry),4);
	gtk_entry_set_width_chars(GTK_ENTRY(year_entry),5);
	gtk_box_pack_start(GTK_BOX(hbox),year_entry,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(year_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);

	month_label=gtk_label_new("Month :");
	gtk_box_pack_start(GTK_BOX(hbox),month_label,FALSE,FALSE,0);

	month_entry=gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(month_entry),2);
	gtk_entry_set_width_chars(GTK_ENTRY(month_entry),3);
	gtk_box_pack_start(GTK_BOX(hbox),month_entry,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(month_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);
	
	day_label=gtk_label_new("Day :");
	gtk_box_pack_start(GTK_BOX(hbox),day_label,FALSE,FALSE,0);

	day_entry=gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(day_entry),2);
	gtk_entry_set_width_chars(GTK_ENTRY(day_entry),3);
	gtk_box_pack_start(GTK_BOX(hbox),day_entry,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(day_entry),"key-press-event",G_CALLBACK(entry_key_pressed),NULL);
	
	align3=gtk_alignment_new(0.5,0.5,0,0);
	gtk_box_pack_start(GTK_BOX(vbox),align3,FALSE,FALSE,0);
	
	button_box=gtk_hbutton_box_new();
	gtk_box_set_spacing(GTK_BOX(button_box),0);
	gtk_container_add(GTK_CONTAINER(align3),button_box);

	set_button=gtk_button_new_with_label("Set Date");
	gtk_box_pack_start(GTK_BOX(button_box),set_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_date),NULL);

	quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_end(GTK_BOX(vbox),quit_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);

	gtk_widget_show_all(window);

}
	

	
