/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

void view_calendar(void)
{

	/* View Calendar implemented for the usage of new() & get_date() function */
	
	gint res;
        guint tyear,tmonth,tday;
        guchar str1[30],str2[30],str3[30];
	
	cal_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(cal_window),10);
	gtk_window_set_title(GTK_WINDOW(cal_window),"View Calendar");
	
	calendar=hildon_calendar_popup_new(GTK_WINDOW(cal_window),year,month,day);
	gtk_widget_show(calendar);
	gtk_widget_show(cal_window);

	res=gtk_dialog_run(GTK_DIALOG(calendar));
	switch(res)
	{
		case GTK_RESPONSE_OK:
		case GTK_RESPONSE_ACCEPT:
			hildon_calendar_popup_get_date(HILDON_CALENDAR_POPUP(calendar),&tyear,&tmonth,&tday);
	                sprintf(str1,"%d",tyear);
		        sprintf(str2,"%d",tmonth);
		        sprintf(str3,"%d",tday);

		        gtk_entry_set_text(GTK_ENTRY(year_entry),str1);
		        gtk_entry_set_text(GTK_ENTRY(month_entry),str2);
		        gtk_entry_set_text(GTK_ENTRY(day_entry),str3);
			break;
	}
												
	
	gtk_widget_destroy(calendar);
	gtk_widget_destroy(cal_window);

	gtk_widget_show(window);
	
}


void set_date(void)
{

	/* This creates a new calendar popup to check the usage of set_date() function */
	
	gint res;
	
	cal_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(cal_window),10);
	gtk_window_set_title(GTK_WINDOW(cal_window),"View Calendar");
	
	calendar=hildon_calendar_popup_new(GTK_WINDOW(cal_window),year,month,day);
	
	year=atoi(gtk_entry_get_text(GTK_ENTRY(year_entry)));
	month=atoi(gtk_entry_get_text(GTK_ENTRY(month_entry)));
	day=atoi(gtk_entry_get_text(GTK_ENTRY(day_entry)));
		
	if(month==NULL||day==NULL||year==NULL)
	{
		gtk_infoprint(GTK_WINDOW(window),"Enter valid date");
	}
	else
	{
		if((month<=12)&&(day<=31))
			hildon_calendar_popup_set_date(HILDON_CALENDAR_POPUP(calendar),year,month,day);
		else
			gtk_infoprint(GTK_WINDOW(window),"Enter valid date");

		gtk_widget_show(calendar);
		gtk_widget_show(cal_window);

		res=gtk_dialog_run(GTK_DIALOG(calendar));
		gtk_widget_destroy(calendar);
		gtk_widget_destroy(cal_window);

		gtk_widget_show(window);
	}

}


gboolean entry_key_pressed(GtkWidget *widget,GdkEventKey *event,gpointer data)
{
        if((isdigit((char) event->keyval))||(event->keyval == GDK_BackSpace)||
	        (event->keyval == GDK_Left)||(event->keyval == GDK_Right)||
	        (event->keyval == GDK_Up)||(event->keyval == GDK_Down)||
	        (event->keyval == GDK_End)||(event->keyval == GDK_Home)||
	        (event->keyval == GDK_Delete)||(event->keyval == GDK_KP_0)||
	        (event->keyval == GDK_KP_1)||(event->keyval == GDK_KP_2)||
	        (event->keyval == GDK_KP_3)||(event->keyval == GDK_KP_4)||
	        (event->keyval == GDK_KP_5)||(event->keyval == GDK_KP_6)||
	        (event->keyval == GDK_KP_7)||(event->keyval == GDK_KP_8)||
	        (event->keyval == GDK_KP_9))
		return FALSE;
	else
	        return TRUE;

}


