/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Action on Clicking 'Properties' button on the main window
void on_property()
{
	gtk_widget_hide(app);
	
        window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	hbox1=gtk_hbox_new(FALSE, 20);
	hbox2=gtk_hbox_new(FALSE,0);
        hbox3=gtk_hbox_new(FALSE, 20);
        hbox4=gtk_hbox_new(FALSE,0);
	vbox1=gtk_vbox_new(FALSE, 30);

	frame=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);

	Lset_properties=gtk_label_new("Set Properties:");
        gtk_box_pack_start(GTK_BOX(hbox1), Lset_properties, FALSE,0 ,0);


	option_menu=gtk_option_menu_new();
	gtk_widget_set_usize(GTK_WIDGET(option_menu),400 , 50);
	
	menu=gtk_menu_new();

	menu_item=gtk_menu_item_new_with_label("Set Title to 'New Title'");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Toolbar");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set FullScreen Size ");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Scrollbar");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Normal Screen Size");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);
		

	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu),menu);
	gtk_box_pack_start(GTK_BOX(hbox1), option_menu, FALSE, 0, 0);


	Lget_properties=gtk_label_new("Get Properties:");
	gtk_box_pack_start(GTK_BOX(hbox3), Lget_properties, FALSE,0 ,0);
	
	option_menu2=gtk_option_menu_new();
        gtk_widget_set_usize(GTK_WIDGET(option_menu2), 400, 50);
        
	menu2=gtk_menu_new();
			        
	menu_item2=gtk_menu_item_new_with_label("Get Title");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get ToolBar");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get Menu");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Is FullScreen Set?");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Toggle Menu");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);
      
	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu2),menu2);
	gtk_box_pack_start(GTK_BOX(hbox3), option_menu2, FALSE, 0, 0);
		
	Eget=gtk_entry_new();
	gtk_widget_set_usize(Eget, 400, 30);
	gtk_box_pack_start(GTK_BOX(hbox4), Eget, TRUE, 0, 0);
	
	Bexit=gtk_button_new_with_label("Return");
	gtk_widget_set_usize(Bexit, 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox2), Bexit, TRUE, 0, 0);
		
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, 0, 0);
	hsep=gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox1), hsep, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox4, FALSE, 0, 0);
        gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox1);
	gtk_container_add(GTK_CONTAINER(window), frame);
	
	/*---------------------------Signal Handlers-----------------------------------*/
	gtk_signal_connect(GTK_OBJECT(option_menu), "changed", GTK_SIGNAL_FUNC(on_change), NULL);
	gtk_signal_connect(GTK_OBJECT(option_menu2), "changed", GTK_SIGNAL_FUNC(on_change2), NULL);
	gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", GTK_SIGNAL_FUNC(on_return), NULL);
        gtk_widget_show_all(window);
}

//Creates the main window
void main_window()
{
		
	hbox=gtk_hbox_new(FALSE, 0);
	hboxa=gtk_hbox_new(FALSE, 0);
        vbox=gtk_vbox_new(FALSE, 350);
	
	appview=hildon_appview_new("Appview");
	app=hildon_app_new_with_appview(appview);

	frame1=gtk_frame_new(" ");
	gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
	gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);
	gtk_container_add(GTK_CONTAINER(appview), frame1);
        /*----------------------Menu added to the AppView----------------------*/ 
	menubar = gtk_menu_bar_new();
	gtk_box_pack_start(GTK_BOX(hboxa), menubar, FALSE, 0, 0);
	
	menuFile = gtk_menu_item_new_with_label ("File");
	gtk_menu_bar_append (GTK_MENU_BAR(menubar), menuFile);
        gtk_widget_show(menuFile);

	menu = gtk_menu_new();
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuFile), menu);

	menuitem = gtk_menu_item_new_with_label ("New");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show (menuitem);

	menuitem = gtk_menu_item_new_with_label ("Open");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show (menuitem);
        //----------------------------------------------------------------------
	menuEdit = gtk_menu_item_new_with_label ("Edit");
        gtk_menu_bar_append (GTK_MENU_BAR(menubar), menuEdit);
        gtk_widget_show(menuEdit);

	menu = gtk_menu_new();
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuEdit), menu);

	menuitem = gtk_menu_item_new_with_label ("Copy");
        gtk_menu_append(GTK_MENU(menu), menuitem);
        gtk_widget_show (menuitem);
			                                                                                                   
        menuitem = gtk_menu_item_new_with_label ("Paste");
        gtk_menu_append(GTK_MENU(menu), menuitem);
        gtk_widget_show (menuitem);
        //----------------------------------------------------------------------

	gtk_widget_show(menuFile);
        gtk_widget_show(menuEdit);

	Bproperty=gtk_button_new_with_label("Properties");
        gtk_widget_set_usize(Bproperty, 170, 30);
        gtk_box_pack_start(GTK_BOX(hbox), Bproperty, TRUE, 0, 15);
			
	Breturn=gtk_button_new_with_label("Exit");
	gtk_widget_set_usize(Breturn, 170, 40);
	gtk_box_pack_start(GTK_BOX(hbox), Breturn, TRUE, 0, 15);
	gtk_box_pack_start(GTK_BOX(vbox), hboxa, FALSE, 0, 0);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(frame1), vbox);

	gtk_signal_connect(GTK_OBJECT(Breturn), "clicked", gtk_main_quit, NULL);
	gtk_signal_connect(GTK_OBJECT(Bproperty), "clicked", GTK_SIGNAL_FUNC(on_property), NULL);
	gtk_widget_show_all(app);
}

	
