/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//ACtion on clicking 'Exit' button
void on_return(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(window);
	gtk_widget_show(app);
}

//Callback function for the icon in toolbar of the appview with scrollbar
void on_sc_back(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(sc_app);
	gtk_widget_show(window);
}

//Callback function for the 'button press event' to retrieve the menu attached to the appview
void on_click(GtkWidget *widget, gpointer data)
{
	event=gdk_event_get();
        type=event->type;
	if (type=4 )
        {
		m=hildon_appview_get_menu(HILDON_APPVIEW(appview));
	
		gtk_menu_popup(m, NULL, NULL, NULL, NULL,3, gtk_get_current_event_time ());
	}
}

//Action on clicking 'return' on the window containing the retrieved menu(context-sensitive menu) 
void on_ret_m(GtkWidget *button, gpointer data)
{
	gtk_widget_destroy(menu_window);
	gtk_widget_show(app);
}

//Action on selection of an item from 'Set Properties' option menu
void on_change()
{
	gchar s[30];
	i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
	sprintf(s, "%i", i);
	if(i==0)
	{
		hildon_appview_set_title(HILDON_APPVIEW(appview), "New Title");
	}
	else if(i==1)
	{
		toolbar = gtk_toolbar_new ();
		gtk_toolbar_set_orientation (GTK_TOOLBAR (toolbar), GTK_ORIENTATION_HORIZONTAL);
		gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_BOTH);
		gtk_container_set_border_width (GTK_CONTAINER (toolbar), 5);

		iconw = gtk_image_new_from_file("images/back.png");
		back_button=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),"Back", "Dummy Icon", "private", iconw, NULL, NULL);
		gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
		
		iconw = gtk_image_new_from_file("images/add.png");
                back_button=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),"Add icon", "Dummy Icon", "private", iconw, NULL, NULL);
		gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
		
		iconw = gtk_image_new_from_file("images/clkalarm.png");
                back_button=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),"Clock Alarm icon", "Dummy Icon", "private", iconw, NULL, NULL);
		gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
		
		iconw = gtk_image_new_from_file("images/cancel.png");
                back_button=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),"Cancel icon", "Dummy Icon", "private", iconw, NULL, NULL);
                gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
		
		iconw = gtk_image_new_from_file("images/calendar.png");
                back_button=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),"Calander icon", "Dummy Icon", "private", iconw, NULL, NULL);
                gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
		 
		gtk_widget_show(toolbar);
		hildon_appview_set_toolbar(HILDON_APPVIEW(appview),GTK_TOOLBAR( toolbar));
		gtk_widget_hide(window);
                gtk_widget_show(app);
	}
	else if(i==2)
	{
		 hildon_appview_set_fullscreen_key_allowed(HILDON_APPVIEW(appview), TRUE);
                 hildon_appview_set_fullscreen(HILDON_APPVIEW(appview), TRUE);
                 gtk_widget_hide(window);
                 gtk_widget_show(app);
	}
	else if(i==3)
	{
		
		label=gtk_label_new("  scroll window \n  scroll window \n  scroll window \n  scroll window\n  scroll window\n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window\n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n  scroll window \n ");
				
		sc_view=hildon_appview_new("Appview with ScrollBar");
		sc_app=hildon_app_new_with_appview(sc_view);
			
		hildon_appview_add_with_scrollbar(HILDON_APPVIEW(sc_view), label);
		sc_toolbar = gtk_toolbar_new ();
		gtk_toolbar_set_orientation (GTK_TOOLBAR (sc_toolbar), GTK_ORIENTATION_HORIZONTAL);
        	gtk_toolbar_set_style (GTK_TOOLBAR (sc_toolbar), GTK_TOOLBAR_BOTH);
                gtk_container_set_border_width (GTK_CONTAINER (sc_toolbar), 5);
		iconw = gtk_image_new_from_file("/targets/PC/usr/share/themes/hildon-harry/back.png");
                back_button=gtk_toolbar_append_item (GTK_TOOLBAR (sc_toolbar),"Back", "Dummy Icon", "private", iconw, GTK_SIGNAL_FUNC(on_sc_back), NULL);
                gtk_toolbar_append_space (GTK_TOOLBAR (sc_toolbar));
				
		hildon_appview_set_toolbar(HILDON_APPVIEW(sc_view),GTK_TOOLBAR( sc_toolbar));	

		
		gtk_widget_hide(window);
		gtk_widget_hide(app);
                gtk_widget_show_all(sc_app);
		
				 
	}
	else if(i==4)
	{
		hildon_appview_set_fullscreen_key_allowed(HILDON_APPVIEW(appview), FALSE);
                hildon_appview_set_fullscreen(HILDON_APPVIEW(appview), FALSE);
                gtk_widget_hide(window);
                gtk_widget_show(app);
	}
	
		
	

}

//Action on selection of an item from 'Get Properties' option menu
void on_change2()
{	
	gchar x[30];
	gint j;
	vboxx=gtk_vbox_new(FALSE, 70);
	vboxy=gtk_vbox_new(FALSE, 70);
	j=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu2));
	sprintf(x, "%i", j);
	if(j==0)
	{
		const gchar *title;
		gchar s[40];
		title=hildon_appview_get_title(HILDON_APPVIEW(appview));
		sprintf(s, "%s", title);
		gtk_entry_set_text(GTK_ENTRY(Eget), s);
	}
	else if(j==1)
	{
		gint x;
		gtk_widget_hide(window);
		gtk_widget_show(app);
		bar=hildon_appview_get_toolbar (HILDON_APPVIEW(appview));
		if(gtk_toolbar_get_orientation(bar)==0)
		{
			gtk_infoprint_with_icon_stock(GTK_WINDOW(app), "The toolbar icons are now \nseparated by double spaces.", GTK_STOCK_DIALOG_INFO);
			gtk_toolbar_insert_space(bar, 1);
			gtk_toolbar_insert_space(bar, 5);
			gtk_toolbar_insert_space(bar, 7);
			gtk_toolbar_insert_space(bar, 10);
			gtk_toolbar_insert_space(bar, 13);
			
			
		}
		else if(gtk_toolbar_get_orientation(bar)==1)
			gtk_infoprint(GTK_WINDOW(app), "Vertical");
	}
	
	else if(j==2)
	{
		gtk_widget_hide(window);
		menu_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
                gtk_container_set_border_width(GTK_CONTAINER(menu_window), 10);

		hboxm=gtk_hbox_new(FALSE, 0);
		vboxm=gtk_vbox_new(FALSE, 0);

		Bret=gtk_button_new_with_label("Return");
	        gtk_widget_set_usize(Bret, 100, 40);
	        gtk_box_pack_end(GTK_BOX(hboxm), Bret, FALSE, 0, 0);
		gtk_box_pack_end(GTK_BOX(vboxm), hboxm, FALSE, 0, 0);
		gtk_container_add(GTK_CONTAINER(menu_window), vboxm);
		gtk_widget_set_events(menu_window, GDK_BUTTON_PRESS_MASK);
		
	        gtk_signal_connect(GTK_OBJECT(menu_window), "button_press_event", GTK_SIGNAL_FUNC(on_click), NULL);
		gtk_signal_connect(GTK_OBJECT(Bret), "clicked", GTK_SIGNAL_FUNC(on_ret_m), NULL);
		gtk_widget_show_all(menu_window);
	}
	else if(j==3)
	{
		if(hildon_appview_get_fullscreen_key_allowed(HILDON_APPVIEW(appview))== 1)
		{
			if(hildon_appview_get_fullscreen(HILDON_APPVIEW(appview))==1)
				gtk_entry_set_text(GTK_ENTRY(Eget), "TRUE");
			else
				gtk_entry_set_text(GTK_ENTRY(Eget),"FALSE");
		}
		else if(hildon_appview_get_fullscreen_key_allowed(HILDON_APPVIEW(appview))== 0)
			gtk_entry_set_text(GTK_ENTRY(Eget),"FALSE");
		
	}
	else if(j==4)
	{
		_hildon_appview_toggle_menu(HILDON_APPVIEW(appview),gtk_get_current_event_time ());
		gtk_widget_hide(window);
                gtk_widget_show(app);

	}
	
}

	
		
