/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Action on clicking 'back' button
void on_back()
{
	gtk_widget_hide(more_window);
	gtk_widget_show(window);
}

//Action on clicking 'More' button on the second window
void on_more2()
{
        more2_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_WINDOW(more2_window), 10);

	hbox11=gtk_hbox_new(FALSE, 0);
	hbox12=gtk_hbox_new(FALSE,10);
	hbox13=gtk_hbox_new(FALSE,0);
	vbox3=gtk_vbox_new(FALSE, 30);

	frame2=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame2), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame2), 0.5, 0.5);
        gtk_container_add(GTK_CONTAINER(more2_window), frame2);
				
	Blaunch_view=gtk_button_new_with_label("Launch HildonApp with AppView");
        align=gtk_alignment_new(0.0, 0.5, 0, 0);
        gtk_widget_set_usize(GTK_WIDGET(Blaunch_view), 450, 40);
        gtk_container_add(GTK_CONTAINER(align), Blaunch_view);
        gtk_box_pack_start(GTK_BOX(hbox11), align, TRUE, 0, 0);
        gtk_box_pack_start(GTK_BOX(vbox3), hbox11, FALSE, 0, 0);

	hsep=gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox3), hsep, FALSE, 0, 0);
        gtk_widget_show(hsep);
			

	Tset_title=gtk_check_button_new_with_label("Set Two Part Title");
        gtk_widget_set_usize(GTK_WIDGET(Tset_title), 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox12), Tset_title, TRUE , 0, 0);
        gtk_widget_set_sensitive(Tset_title, FALSE);
			                                                                                                      
        vsep=gtk_vseparator_new();
        gtk_box_pack_start(GTK_BOX(hbox12), vsep, TRUE, 0, 0);
						                                                                                                        
        Bgettitle=gtk_button_new_with_label("Get Two Part Title");
        gtk_widget_set_usize(GTK_WIDGET(Bgettitle), 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox12), Bgettitle, TRUE, 0, 0);
        gtk_widget_set_sensitive(Bgettitle, FALSE);
											                                                                                                    
        Egettitle=gtk_entry_new();
        gtk_widget_set_sensitive(Egettitle, FALSE);
	gtk_widget_set_usize(Egettitle, 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox12), Egettitle, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox12, FALSE, 0, 0);
	                                                                                                   
        hsep=gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox3), hsep, FALSE, 0, 0);
        gtk_widget_show(hsep);

	Breset=gtk_button_new_with_label("Return");
        align=gtk_alignment_new(0.0,1.0, 0, 0);
        gtk_widget_set_usize(GTK_WIDGET(Breset), 250, 40);
        gtk_container_add(GTK_CONTAINER(align), Breset);
        gtk_widget_show(Breset);
        gtk_box_pack_start(GTK_BOX(hbox13), align, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox13, FALSE, 0, 0);

	gtk_container_add(GTK_CONTAINER(frame2), vbox3);
	gtk_widget_show(Blaunch_view);
	
	/*--------------------Signal Handlers-----------------------------*/
	gtk_signal_connect(GTK_OBJECT(Blaunch_view), "clicked", GTK_SIGNAL_FUNC(on_launch_view), NULL);
        gtk_signal_connect(GTK_OBJECT(Tset_title), "toggled", GTK_SIGNAL_FUNC(on_toggled), NULL);
        gtk_signal_connect(GTK_OBJECT(Bgettitle), "clicked", GTK_SIGNAL_FUNC(on_gettitle), NULL);
	gtk_signal_connect(GTK_OBJECT(Breset), "clicked", GTK_SIGNAL_FUNC(on_reset), NULL);
		  
	gtk_widget_show_all(more2_window);
}
						
//Action on clicking 'More' button on the main window
void on_more()
{
	more_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_WINDOW(more_window), 10);

	frame1=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);


	hbox8=gtk_hbox_new(FALSE, 0);
	hbox4=gtk_hbox_new(FALSE, 10);
        hbox5=gtk_hbox_new(FALSE, 10);
        hbox6=gtk_hbox_new(FALSE, 0);
			  
	vbox2=gtk_vbox_new(FALSE, 30);	
	
	Bzoom=gtk_button_new_with_label("Set Zoom");
	gtk_widget_set_usize(GTK_WIDGET(Bzoom), 250, 40);
	gtk_box_pack_start(GTK_BOX(hbox4), Bzoom, FALSE, 0, 0);
			   
	
	Bzoom_get=gtk_button_new_with_label("Get Zoom Level");
	gtk_widget_set_usize(GTK_WIDGET(Bzoom_get), 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox4),Bzoom_get, FALSE, 0, 0);
        gtk_widget_set_sensitive(Bzoom_get, FALSE);
			                                                                                                     
        Ezoom_get=gtk_entry_new();
	gtk_widget_set_usize(Ezoom_get, 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox4),Ezoom_get, FALSE, 0, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox4, FALSE, 0, 0);
        gtk_widget_set_sensitive(Ezoom_get, FALSE);
        
	hsep=gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox2), hsep, FALSE, 0, 0);
        gtk_widget_show(hsep);
											                                                                                                    
        Bdef_font=gtk_button_new_with_label("Get Default Font");
        gtk_widget_set_usize(GTK_WIDGET(Bdef_font), 250, 40);
        gtk_box_pack_start(GTK_BOX(hbox5), Bdef_font, FALSE, 0, 10);
                                                                                      
        Lfont=gtk_label_new("Font");
        align=gtk_alignment_new(0.5, 0.5, 0, 0);
        gtk_container_add(GTK_CONTAINER(align), Lfont);
        gtk_box_pack_start(GTK_BOX(hbox5), align, FALSE, 0,10);
        
	Bzoom_font=gtk_button_new_with_label("Get Zoom Font");
        gtk_widget_set_usize(GTK_WIDGET(Bzoom_font), 250, 40);
        gtk_box_pack_end(GTK_BOX(hbox5), Bzoom_font, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox5, FALSE, 0, 10);

	 hsep=gtk_hseparator_new();
	 gtk_box_pack_start(GTK_BOX(vbox2), hsep, FALSE, 0, 0);
         gtk_widget_show(hsep);

	 Bmore2=gtk_button_new_with_label("More...");
         gtk_widget_set_usize(GTK_WIDGET(Bmore2), 250, 40);
         gtk_box_pack_start(GTK_BOX(hbox6), Bmore2, FALSE, 0, 0);

	 Bback=gtk_button_new_with_label("Return");
         gtk_widget_set_usize(GTK_WIDGET(Bback), 250, 40);
         gtk_box_pack_end(GTK_BOX(hbox6), Bback, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox2), hbox6, FALSE, 0, 0);
                                                         

	gtk_container_add(GTK_CONTAINER(frame1), vbox2); 
	gtk_container_add(GTK_CONTAINER(more_window), frame1);
	gtk_signal_connect(GTK_OBJECT(Bzoom), "clicked", GTK_SIGNAL_FUNC(on_zoom), NULL);
        gtk_signal_connect(GTK_OBJECT(Bzoom_get), "clicked", GTK_SIGNAL_FUNC(on_zoom_get), NULL);
        gtk_signal_connect(GTK_OBJECT(Bdef_font), "clicked", GTK_SIGNAL_FUNC(on_def_font), NULL);
	gtk_signal_connect(GTK_OBJECT(Bmore2), "clicked", GTK_SIGNAL_FUNC(on_more2), NULL);
	gtk_signal_connect(GTK_OBJECT(Bback), "clicked", GTK_SIGNAL_FUNC(on_back), NULL);
	
	
        gtk_signal_connect(GTK_OBJECT(Bzoom_font), "clicked", GTK_SIGNAL_FUNC(on_zoom_font), NULL);


	gtk_widget_show_all(more_window);

}

//Creates the main window
void main_window()
{
	 
	 window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
         gtk_container_set_border_width(GTK_WINDOW(window), 10);

	 vbox1=gtk_vbox_new(FALSE, 30);
	 hbox1=gtk_hbox_new(FALSE, 70);
	 hbox2=gtk_hbox_new(FALSE, 70);
         hbox3=gtk_hbox_new(FALSE, 70);
	 hbox4=gtk_hbox_new(FALSE, 40);
	 hbox5=gtk_hbox_new(FALSE, 80);
	 hbox6=gtk_hbox_new(FALSE, 40);
	 hbox7=gtk_hbox_new(FALSE, 40);
	 
	 
	 frame=gtk_frame_new(" ");
         gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
         gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0.5);
         gtk_container_add(GTK_CONTAINER(window), frame);

	 Blaunch=gtk_button_new_with_label("Launch HildonApp");
	 align=gtk_alignment_new(0, 0, 0.5, 0.5);
	 gtk_widget_set_usize(GTK_WIDGET(Blaunch), 250, 40);
	 gtk_container_add(GTK_CONTAINER(align), Blaunch);
         gtk_box_pack_start(GTK_BOX(hbox1), align, TRUE, 0, 0);
         gtk_widget_show(Blaunch);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, 0, 0);

	 hsep=gtk_hseparator_new();
	 gtk_box_pack_start(GTK_BOX(vbox1), hsep, FALSE, 0, 0);
	 gtk_widget_show(hsep);		 
	 gtk_container_add(GTK_CONTAINER(frame), vbox1);

	 Bget_title=gtk_button_new_with_label("Get Title");
	 gtk_widget_set_usize(GTK_WIDGET(Bget_title), 250, 40);
	 gtk_box_pack_start(GTK_BOX(hbox2), Bget_title, FALSE, 0, 0);

	 Eget_title=gtk_entry_new();
	 gtk_widget_set_usize(GTK_WIDGET(Eget_title), 250, 40);
	 gtk_box_pack_end(GTK_BOX(hbox2), Eget_title, FALSE, 0, 0);
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, 0, 0);

	 Eset_title=gtk_entry_new();
         gtk_widget_set_usize(GTK_WIDGET(Eset_title), 250, 40);
         gtk_box_pack_start(GTK_BOX(hbox3), Eset_title, FALSE, 0, 0);
         gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, 0, 0);
				    
 	 Bset_title=gtk_button_new_with_label("Set title");
         gtk_widget_set_usize(GTK_WIDGET(Bset_title), 250, 40);
         gtk_box_pack_end(GTK_BOX(hbox3), Bset_title, FALSE, 0, 0);

	 hsep=gtk_hseparator_new();
         gtk_box_pack_start(GTK_BOX(vbox1), hsep, FALSE, 0, 0);
         gtk_widget_show(hsep);


	 Bmore=gtk_button_new_with_label("More...");
	 gtk_widget_set_usize(GTK_WIDGET(Bmore), 250, 40);
	 gtk_box_pack_start(GTK_BOX(hbox7), Bmore, FALSE, 0, 0);
	 
	 Bexit=gtk_button_new_with_label("Exit");
	 align=gtk_alignment_new(1.0,1.0, 0, 0);
         gtk_widget_set_usize(GTK_WIDGET(Bexit), 250, 40);
         gtk_container_add(GTK_CONTAINER(align), Bexit);
	 gtk_box_pack_end(GTK_BOX(hbox7), align, FALSE, 0, 0);
	 
	 gtk_box_pack_start(GTK_BOX(vbox1), hbox7, FALSE, 0, 0);

	 /*-----------------------------------Signal Handlers---------------------------------*/		   
	 gtk_signal_connect(GTK_OBJECT(Blaunch), "clicked", GTK_SIGNAL_FUNC(on_launch), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bget_title), "clicked", GTK_SIGNAL_FUNC(on_get_title), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bset_title), "clicked", GTK_SIGNAL_FUNC(on_set_title), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", GTK_SIGNAL_FUNC(on_exit), NULL);
	 gtk_signal_connect(GTK_OBJECT(Bmore), "clicked", GTK_SIGNAL_FUNC(on_more), NULL);

	 gtk_widget_show_all(window);
}


		 
