/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Action on clicking 'Exit' button
void on_exit(GtkWidget *button, gpointer data)
{
	gtk_widget_destroy(hildon_app);
	gtk_widget_destroy(hildon_app1);
	gtk_main_quit();
}

//Action on clicking 'Click here' button on the Hildon App widget
void on_button(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(hildon_app);
}

//Action on clicking 'Click here' on the Hildon Appview widget
void on_button1(GtkWidget *button, gpointer data)
{
	        gtk_widget_hide(hildon_app1);
}

//Action on clicking 'Launch Hildon App' button on the main window
void on_launch(GtkWidget *button, gpointer data)
{
	GtkWidget *button;
	hildon_app=hildon_app_new();
	hildon_app_set_title(HILDON_APP(hildon_app), "Part1");
	button=gtk_button_new_with_label("Click here");
	gtk_container_add(GTK_CONTAINER(hildon_app), button);
	gtk_widget_show(GTK_WIDGET(button));
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_button), NULL);
	gtk_widget_show(hildon_app);
	gtk_widget_set_sensitive(Blaunch, FALSE);
}

//Action on clicking 'Launch Hildon App with Appview' button
void on_launch_view(GtkWidget *button, gpointer data)
{
	gtk_widget_set_sensitive(Tset_title, TRUE);
	gtk_widget_set_sensitive(Bgettitle, TRUE);

	GtkWidget *button1;
	hildon_appview=hildon_appview_new("AppView ");
	tool_item=gtk_tool_item_new ();
	tool_bar=gtk_toolbar_new();
	gtk_toolbar_insert (tool_bar, tool_item, 0);
	hildon_appview_set_toolbar (HILDON_APPVIEW(hildon_appview), tool_bar);
	hildon_app1=hildon_app_new_with_appview(HILDON_APPVIEW(hildon_appview));
	hildon_app_set_title(HILDON_APP(hildon_app1), "Hildon");
        button1=gtk_button_new_with_label("Click here");
        gtk_container_add(GTK_CONTAINER(hildon_appview), button1);
	gtk_signal_connect(GTK_OBJECT(button1), "clicked", GTK_SIGNAL_FUNC(on_button1), NULL);
        gtk_widget_show(GTK_WIDGET(button1));
	gtk_widget_show(hildon_app1);
	gtk_widget_set_sensitive(Blaunch_view, FALSE);
}

//Action on clicking 'Get Title' button on the main window
void on_get_title(GtkWidget *button, gpointer data)
{
	const gchar *title;
	title=hildon_app_get_title (HILDON_APP(hildon_app));
	gtk_entry_set_text(GTK_ENTRY(Eget_title), title);
}

//Action on clicking 'Set Title' button on the main window
void on_set_title(GtkWidget *button, gpointer data)
{
	const gchar *title;
	title=gtk_entry_get_text(GTK_ENTRY(Eset_title));
	hildon_app_set_title(HILDON_APP(hildon_app), title);
	gtk_widget_show(hildon_app);
}

//Action on clicking 'Set Zoom' button on teh main window
void on_zoom(GtkWidget *button, gpointer data)
{
	hildon_app_set_zoom (HILDON_APP(hildon_app),3);
	gtk_widget_set_sensitive(Bzoom_get, TRUE);
}

//Action on clicking 'Get Zoom' button on the main window
void on_zoom_get(GtkWidget *button, gpointer data)
{
	HildonZoomLevel zoom;
	gchar s[30];
	zoom=hildon_app_get_zoom (HILDON_APP(hildon_app));
	sprintf(s, "%i", zoom);
	gtk_entry_set_text(GTK_ENTRY(Ezoom_get), s);
	
}

//Action on clicking on 'Get Default font' button on the main button
void on_def_font(GtkWidget *button, gpointer data)
{
	PangoFontDescription* pf;
	pf=hildon_app_get_default_font(HILDON_APP(hildon_app));
	gtk_widget_modify_font(Lfont, pf);

}

//Action on clicking on 'Get Zoom font' button on the main button
void on_zoom_font(GtkWidget *button, gpointer data)
{
	PangoFontDescription* pf;
        pf=hildon_app_get_zoom_font(HILDON_APP(hildon_app));
        gtk_widget_modify_font(Lfont, pf);
}

//Action on toggling 'Set Title' checkbox on the third window
void on_toggled(GtkWidget *button, gpointer data)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Tset_title)))
	{
		hildon_app_set_two_part_title(HILDON_APP(hildon_app1), TRUE);
		gtk_widget_show(hildon_app1);
	}
	else
	{
		hildon_app_set_two_part_title(HILDON_APP(hildon_app1), FALSE);
		gtk_widget_show(hildon_app1);
	}
}

//Action on clicking 'Get Two Part Title' button on the third window
void on_gettitle(GtkWidget *button, gpointer data)
{
	if(hildon_app_get_two_part_title(HILDON_APP(hildon_app1)))
		gtk_entry_set_text(GTK_ENTRY(Egettitle), "TRUE");
	else
		gtk_entry_set_text(GTK_ENTRY(Egettitle), "FALSE");
}

//Action on clicking 'Return' button on the third window
void on_reset(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(more2_window);
	gtk_widget_hide(more_window);
	gtk_widget_show(window);
}


			
			

			


