/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"


void  create_setmenu(GtkWidget* table)
{
        gchar *menu_items_text[]={"headers invisible","rules hint","unset drag","H_VAdjustment","column autosize",\
"headers clickable","insert column","remove column","move column",\
"scroll to point","scroll to cell","row activated","reorderable","expand all","collapse all",\
"expand row","collapse row"
};

        GtkWidget* menu_item[17];
        GtkWidget* set_optionmenu;
        gint i;
        PangoFontDescription *smallfont;
        /*Get the font*/
        smallfont = pango_font_description_from_string ("swissa 12");
        GtkWidget* option_menu = gtk_menu_new();
        for(i = 0;i < 17;i++)
        {
                menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
                gtk_widget_modify_font(GTK_BIN(menu_item[i])->child,smallfont);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (option_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        set_optionmenu = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (set_optionmenu), option_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (set_optionmenu), 1);
        gtk_widget_set_usize(set_optionmenu,250,21);
        gtk_table_attach(GTK_TABLE(table), set_optionmenu, 1, 2, 0, 1,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (set_optionmenu);

        GtkWidget *set_button = gtk_button_new_with_label("Set it now");
        gtk_widget_set_usize(set_button,250,25);
        smallfont = pango_font_description_from_string ("swissa 12");
        gtk_widget_modify_font(GTK_BIN(set_button)->child,smallfont);
        gtk_table_attach(GTK_TABLE(table), set_button, 0, 2, 1, 2,GTK_SHRINK,GTK_EXPAND,0,0);
        g_signal_connect (G_OBJECT(set_button), "clicked",
                        G_CALLBACK (setbutton_callback),
                        set_optionmenu);
        gtk_widget_show(set_button);
}

void  create_getmenu(GtkWidget* table)
{

        gchar *menu_items_text[]={"bin window","selection","H_VAdjustment","No of columns","expander","cursor","reorderable",\
  "row expanded","cell area","background area","visible rect","dest row pos","widget to tree (x,y)","tree to widget (x,y"};

        GtkWidget* menu_item[14];
        GtkWidget* get_optionmenu;
        gint i;
        PangoFontDescription *smallfont;
        /*Get the font*/
        smallfont = pango_font_description_from_string ("swissa 12");
        GtkWidget* option_menu = gtk_menu_new();
        for(i = 0;i < 14;i++)
        {
                menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
                gtk_widget_modify_font(GTK_BIN(menu_item[i])->child,smallfont);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (option_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        get_optionmenu = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (get_optionmenu), option_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (get_optionmenu), 1);
        gtk_widget_set_usize(get_optionmenu,250,21);
        gtk_table_attach(GTK_TABLE(table), get_optionmenu, 0, 1, 2, 3,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (get_optionmenu);

        h_getlabel = gtk_label_new ("");
        smallfont = pango_font_description_from_string ("swissa 12");
        gtk_widget_modify_font(h_getlabel,smallfont);
        gtk_table_attach(GTK_TABLE(table), h_getlabel, 1, 2, 2, 3,GTK_SHRINK,GTK_EXPAND,0,0);

        GtkWidget *get_button = gtk_button_new_with_label("Get it now");
        gtk_widget_set_usize(get_button,250,25);
        gtk_widget_modify_font(GTK_BIN(get_button)->child,smallfont);
        gtk_table_attach(GTK_TABLE(table), get_button, 0, 2, 3, 4,GTK_SHRINK,GTK_EXPAND,0,0);
        g_signal_connect (G_OBJECT(get_button), "clicked",
                        G_CALLBACK (getbutton_callback),
                        get_optionmenu);
}
void  create_more_setmenu(GtkWidget* table)
{
        gchar *menu_items_text[]={"drag dest row","row drag icon","enable search","search column","cursor on cell",\
"search equal function","map expanded row","set model","expand to path",\
"insert column data func","enable multiple selection"
};

        GtkWidget* menu_item[11];
        GtkWidget* set_optionmenu;
        gint i;
        PangoFontDescription *smallfont;
        /*Get the font*/
        smallfont = pango_font_description_from_string ("swissa 12");
        GtkWidget* option_menu = gtk_menu_new();
        for(i = 0;i < 11;i++)
        {
                menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
                gtk_widget_modify_font(GTK_BIN(menu_item[i])->child,smallfont);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (option_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        set_optionmenu = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (set_optionmenu), option_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (set_optionmenu), 1);
        gtk_widget_set_usize(set_optionmenu,250,21);
        gtk_table_attach(GTK_TABLE(table), set_optionmenu, 1, 2, 4, 5,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (set_optionmenu);

        GtkWidget *set_button = gtk_button_new_with_label("Set it ");
        gtk_widget_set_usize(set_button,250,25);
        smallfont = pango_font_description_from_string ("swissa 12");
        gtk_widget_modify_font(GTK_BIN(set_button)->child,smallfont);
        gtk_table_attach(GTK_TABLE(table), set_button, 0, 2, 5, 6,GTK_SHRINK,GTK_EXPAND,0,0);
        g_signal_connect (G_OBJECT(set_button), "clicked",
                        G_CALLBACK (moresetbutton_callback),
                        set_optionmenu);
        gtk_widget_show(set_button);
}

void  create_more_getmenu(GtkWidget* table)
{

        gchar *menu_items_text[]={"drag dest row","enable search","search column","path at pos","Search Equal Func"};


        GtkWidget* menu_item[5];
        GtkWidget* get_optionmenu;
        gint i;
        PangoFontDescription *smallfont;
        /*Get the font*/
        smallfont = pango_font_description_from_string ("swissa 12");
        GtkWidget* option_menu = gtk_menu_new();
        for(i = 0;i < 5;i++)
        {
                menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
                gtk_widget_modify_font(GTK_BIN(menu_item[i])->child,smallfont);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (option_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        get_optionmenu = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (get_optionmenu), option_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (get_optionmenu), 1);
        gtk_widget_set_usize(get_optionmenu,250,21);
        gtk_table_attach(GTK_TABLE(table), get_optionmenu, 0, 1, 6, 7,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (get_optionmenu);

        h_moregetlabel = gtk_label_new ("");
        smallfont = pango_font_description_from_string ("swissa 12");
        gtk_widget_modify_font(h_moregetlabel,smallfont);
        gtk_table_attach(GTK_TABLE(table), h_moregetlabel, 1, 2, 6, 7,GTK_SHRINK,GTK_EXPAND,0,0);

        GtkWidget *get_button = gtk_button_new_with_label("Get it");
        gtk_widget_set_usize(get_button,250,25);
        gtk_widget_modify_font(GTK_BIN(get_button)->child,smallfont);
        gtk_table_attach(GTK_TABLE(table), get_button, 0, 2, 7, 8,GTK_SHRINK,GTK_EXPAND,0,0);
        g_signal_connect (G_OBJECT(get_button), "clicked",
                        G_CALLBACK (moregetbutton_callback),
                        get_optionmenu);
}


void populate_tree_model(GtkTreeStore *store)
{
  GtkTreeIter   iter,iter2;

  gtk_tree_store_append (store, &iter, NULL);  /* Acquire an iterator */

  gtk_tree_store_set (store, &iter,
                    TITLE_COLUMN, "The Principle of Reason",
                    AUTHOR_COLUMN, "Martin Heidegger",
                    CHECKED_COLUMN, FALSE,
                    -1);
  gtk_tree_store_append (store, &iter, NULL);  /* Acquire an iterator */
  gtk_tree_store_set (store, &iter,
                    TITLE_COLUMN, "Teach Ur Self Perl",
                    AUTHOR_COLUMN, "Laura Lemay",
                    CHECKED_COLUMN, TRUE,
                    -1);
  gtk_tree_store_append (store, &iter, NULL);  /* Acquire an iterator */
  gtk_tree_store_set (store, &iter,
                    TITLE_COLUMN, "Shell Programming",
                    AUTHOR_COLUMN, "Sriranga",
                    CHECKED_COLUMN, TRUE,
                    -1);
  gtk_tree_store_append (store, &iter2, &iter);  /* Acquire a child iterator */
  gtk_tree_store_set (store, &iter2,
                    TITLE_COLUMN, "Some Book",
                    -1);
  gtk_tree_store_append (store, &iter, NULL);  /* Acquire an iterator */
  gtk_tree_store_set (store, &iter,
                    TITLE_COLUMN, "C Programming",
                    AUTHOR_COLUMN, "XYZ",
                    CHECKED_COLUMN, TRUE,
                    -1);

  gtk_tree_store_append (store, &iter2, &iter);  /* Acquire a child iterator */
  gtk_tree_store_set (store, &iter2,
                    TITLE_COLUMN, "Volume 1: Fundamental Algorithms ",
                    -1);

  gtk_tree_store_append (store, &iter2, &iter);
  gtk_tree_store_set (store, &iter2,
                    TITLE_COLUMN, "Volume 2: Seminumerical Algorithms",
                    -1);

  gtk_tree_store_append (store, &iter2, &iter);
  gtk_tree_store_set (store, &iter2,
                    TITLE_COLUMN, "Volume 3: Sorting and Searching",
                    -1);
}

void
setup_tree (GtkWidget *table)
{
   GtkTreeStore *store;
   GtkTreeViewColumn *column;
   GtkCellRenderer *renderer;
   GtkTreeModel *tmodel;

   /* Create a model.  We are using the store model for now, though we
    * could use any other GtkTreeModel */
   store = gtk_tree_store_new (N_COLUMNS,
                               G_TYPE_STRING,
                               G_TYPE_STRING,
                               G_TYPE_BOOLEAN);

   /* custom function to fill the model with data */
   populate_tree_model (store);

   /* Create a view */
   h_tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  /* Disable Search*/
  gtk_tree_view_set_enable_search(h_tree,FALSE);

   /* Enable drag dest & drag source*/
   gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (h_tree),
                                          GDK_BUTTON1_MASK,
                                          row_targets,
                                          G_N_ELEMENTS (row_targets),
                                          GDK_ACTION_MOVE | GDK_ACTION_COPY);

  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (h_tree),
                                        row_targets,
                                        G_N_ELEMENTS (row_targets),
                                        GDK_ACTION_MOVE | GDK_ACTION_COPY);

   /* The view now holds a reference.  We can get rid of our own
    * reference */
   g_object_unref (G_OBJECT (store));

   /* Create a cell render and arbitrarily make it red for demonstration
    * purposes */
   renderer = gtk_cell_renderer_text_new ();
   g_object_set (G_OBJECT (renderer),
                 "foreground", "red",
                 NULL);

   /* Create a column, associating the "text" attribute of the
    * cell_renderer to the first column of the model */
   column = gtk_tree_view_column_new_with_attributes ("Author", renderer,
                                                      "text", AUTHOR_COLUMN,
                                                      NULL);

   /* Add the column to the view. */
   gtk_tree_view_append_column (GTK_TREE_VIEW (h_tree), column);

   /* Second column.. title of the book. */
   renderer = gtk_cell_renderer_text_new ();
   column = gtk_tree_view_column_new_with_attributes ("Title",
                                                      renderer,
                                                      "text", TITLE_COLUMN,
                                                      NULL);
   gtk_tree_view_append_column (GTK_TREE_VIEW (h_tree), column);

   /* Last column.. whether a book is checked out. */
   tmodel=gtk_tree_view_get_model(h_tree);
   renderer = gtk_cell_renderer_toggle_new ();
   g_object_set (renderer, "xalign", 0.0, NULL);
   g_object_set_data (G_OBJECT (renderer), "column", (gint *)CHECKED_COLUMN);
	 
   g_signal_connect(renderer,"toggled",G_CALLBACK(item_toggled),tmodel);
   column = gtk_tree_view_insert_column_with_attributes (h_tree,-1,"Checked out",
                                                      renderer,
                                                      "active", CHECKED_COLUMN,
                                                      NULL);

   g_signal_connect (h_tree,
                    "row-activated",
                    G_CALLBACK (rowactivated_callback),
                    NULL);

}

GtkWidget*
create_main_window(void)
{
   GtkWidget *table;
   GtkWidget *sw;
   GtkWidget *button;
   h_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   table = gtk_table_new (4, 2, TRUE);
   gtk_container_add (GTK_CONTAINER (h_window), table);
   setup_tree(table);
   button = gtk_button_new_with_label("Set/Get Properties");
   gtk_table_attach(GTK_TABLE(table), button, 0, 1, 3, 4,GTK_SHRINK,GTK_EXPAND,0,0);
   g_signal_connect (G_OBJECT(button), "clicked",
                        G_CALLBACK (show_main_window),
                        NULL);

   button = gtk_button_new_with_label("Close");
   gtk_table_attach(GTK_TABLE(table), button, 0, 2, 3, 4,GTK_SHRINK,GTK_EXPAND,0,0);
   g_signal_connect (G_OBJECT(button), "clicked",GTK_SIGNAL_FUNC (gtk_exit), NULL);
   
   /*scroller  */
  sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_AUTOMATIC);

  gtk_table_attach (GTK_TABLE (table), sw,
                    0, 2, 0, 2,
                    GTK_EXPAND | GTK_FILL,
                    GTK_EXPAND | GTK_FILL,
                    0, 0);
  gtk_container_add (GTK_CONTAINER (sw), h_tree);

   gtk_widget_show_all(h_window);
   
}
GtkWidget* create_window (void)
{
        GtkWidget *table;
        h_treewindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        /* Sets the border width of the window. */
        gtk_container_set_border_width (GTK_CONTAINER (h_treewindow), 10);
        table = gtk_table_new (8, 2, TRUE);
        gtk_container_add (GTK_CONTAINER (h_treewindow), table);
        GtkWidget *label1 = gtk_label_new("Select Properties:");
        gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_FILL);
        gtk_table_attach(GTK_TABLE(table), label1, 0, 1, 0, 1,GTK_SHRINK,GTK_EXPAND,0,0);
        create_setmenu(table);
        create_getmenu(table);
        label1 = gtk_label_new("More Properties:");
        gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_FILL);
        gtk_table_attach(GTK_TABLE(table), label1, 0, 1, 4, 5,GTK_SHRINK,GTK_EXPAND,0,0);
        create_more_setmenu(table);
        create_more_getmenu(table);
        gtk_widget_show(label1);
        gtk_widget_show_all(table);
        gtk_widget_show(h_treewindow);
}

void item_toggled (GtkCellRendererToggle *cell, gchar *path_str, gpointer data)
{

	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
	GtkTreeIter iter;
	gboolean toggle_item;
        gint *column;

        column = g_object_get_data (G_OBJECT (cell), "column");
  
	/* get toggled iter */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, column, &toggle_item, -1);

	/* do something with the value */
	toggle_item ^= 1;

	/* set new value */
	gtk_tree_store_set (GTK_TREE_STORE (model), &iter, column, toggle_item, -1);

	/* clean up */
	gtk_tree_path_free (path);
}

