/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

void
rowactivated_callback (GtkTreeView * treeview,
		       GtkTreePath * arg1,
		       GtkTreeViewColumn * arg2, gpointer user_data)
{
 
	gtk_infoprint(GTK_WINDOW(h_window),"Signal Generated");
	
}


void
show_main_window (GtkButton * button, gpointer user_data)
{
  create_window ();
  gtk_widget_hide (h_window);
}

void
setbutton_callback (GtkButton * button, gpointer user_data)
{
  GtkTreeViewColumn *column, *base_column;
  GtkCellRenderer *renderer;
  GtkAdjustment *ha, *va;
  gint menu_indx = gtk_option_menu_get_history (user_data);

  switch (menu_indx)
    {
    case 0:
      {
	gtk_tree_view_set_headers_visible (h_tree, FALSE);
	break;
      }
    case 1:
      {
	gtk_tree_view_set_rules_hint (h_tree, TRUE);
	break;
      }
    case 2:
      {
	gtk_tree_view_unset_rows_drag_source (h_tree);
	gtk_tree_view_unset_rows_drag_dest (h_tree);
	break;
      }
    case 3:
      {
	ha = (GtkAdjustment *) gtk_adjustment_new (0, 0, 6, 1, 1, 1);
	va = (GtkAdjustment *) gtk_adjustment_new (0, 0, 100, 1, 1, 1);
	gtk_tree_view_set_hadjustment (GTK_TREE_VIEW (h_tree), ha);
	gtk_tree_view_set_vadjustment (GTK_TREE_VIEW (h_tree), va);
	break;
      }
    case 4:
      {
	gtk_tree_view_columns_autosize (h_tree);
	break;
      }
    case 5:
      {
	gtk_tree_view_set_headers_clickable (h_tree, TRUE);
	break;
      }
    case 6:
      {
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Price",
							   renderer, NULL);
	gtk_tree_view_insert_column (h_tree, column, 2);

	break;
      }
    case 7:
      {
	gtk_tree_view_remove_column (h_tree,
				     gtk_tree_view_get_column (h_tree, 2));
	break;
      }
    case 8:
      {
	column = gtk_tree_view_get_column (h_tree, 0);
	base_column = gtk_tree_view_get_column (h_tree, 1);
	gtk_tree_view_move_column_after (h_tree, column, base_column);
	break;
      }
    case 9:
      {
	gtk_tree_view_scroll_to_point (h_tree, 280, 280);
	break;
      }
    case 10:
      {
	gtk_tree_view_scroll_to_cell (h_tree,
				      gtk_tree_path_new_from_string ("2"),
				      gtk_tree_view_get_column (h_tree, 2),
				      TRUE, 0.5, 0.0);
	break;
      }
    case 11:
      {
	gtk_tree_view_row_activated (h_tree,
				     gtk_tree_path_new_from_string ("2"),
				     gtk_tree_view_get_column (h_tree, 2));
	break;
      }
    case 12:
      {
	gtk_tree_view_set_reorderable (h_tree, TRUE);
	break;
      }
    case 13:
      {
	gtk_tree_view_expand_all (h_tree);
	break;
      }
    case 14:
      {
	gtk_tree_view_collapse_all (h_tree);
	break;
      }
    case 15:
      {
	gtk_tree_view_expand_row (h_tree, gtk_tree_path_new_from_string ("3"),
				  TRUE);
	break;
      }
    case 16:
      {
	gtk_tree_view_collapse_row (h_tree,
				    gtk_tree_path_new_from_string ("3"));
	break;
      }
    }
//Using gtk_widget_hide() since gtk_widget_destroy() crashes the application!  
//  gtk_widget_destroy (h_treewindow);
  gtk_widget_hide(h_treewindow);
  gtk_widget_show (h_window);


}


void
check_getcursor ()
{
  GtkTreeViewColumn *column, *c_column;
  GtkTreePath *c_path;
  column = gtk_tree_view_get_column (h_tree, 2);
  gtk_tree_view_set_cursor (h_tree, gtk_tree_path_new_from_string ("3"), column, TRUE);
  gtk_tree_view_get_cursor (h_tree, &c_path, &c_column);
  if (column == c_column)
    {
      gtk_label_set_text (h_getlabel, "get cursor PASSED");
    }
  else
    {
      gtk_label_set_text (h_getlabel, "get cursor FAILED");
    }
}



void
getbutton_callback (GtkButton * button, gpointer user_data)
{
  GdkRectangle rect;
  GtkTreeViewDropPosition pos;
  GtkTreePath *path;
  gint tx, ty, row;
  GdkWindow *window = NULL;
  GtkAdjustment *ha, *va;
  gint menu_indx = gtk_option_menu_get_history (user_data);
  char buffer[64];
  GtkTreeSelection *selection = NULL;
  GList *columns = NULL;

  switch (menu_indx)
    {
    case 0:
      {
        window = gtk_tree_view_get_bin_window(h_tree);
        if(window == NULL)
        {
           gtk_label_set_text(h_getlabel,"Bin window is NULL");
        }
        else
        {
           gtk_label_set_text(h_getlabel,"Bin window is not NULL");
        }
	break;
      }
    case 1:
      {
        selection = gtk_tree_view_get_selection(h_tree);
        if(selection == NULL)
        {
           gtk_label_set_text(h_getlabel,"Selection is NULL");
        }
        else
        {
           gtk_label_set_text(h_getlabel,"Selection is not NULL");
        }
	break;
      }
    case 2:
      {
	ha = gtk_tree_view_get_vadjustment (h_tree);
	va = gtk_tree_view_get_hadjustment (h_tree);
	sprintf (buffer, "H:(%d,%d,%d,%d,%d,%d) V:(%d,%d,%d,%d,%d,%d)\n",
		 (gint)ha->value, (gint)ha->lower, (gint)ha->upper, (gint)ha->step_increment,
		 (gint)ha->page_increment, (gint)ha->page_size, (gint)va->value, (gint)va->lower,
		 (gint)va->upper, (gint)va->step_increment, (gint)va->page_increment,
		 (gint)va->page_size);
        gtk_label_set_line_wrap(h_getlabel,TRUE);
        gtk_label_set_text(h_getlabel,buffer);
	break;
      }
    case 3:
      {
        columns = gtk_tree_view_get_columns(h_tree);
        sprintf(buffer,"No. of columns = %d",g_list_length(columns));
        gtk_label_set_text(h_getlabel,buffer);
	break;
      }
    case 4:
      {
	gtk_tree_view_set_expander_column (h_tree,
					   gtk_tree_view_get_column (h_tree,
								     1));
	if (gtk_tree_view_get_expander_column (h_tree) ==
	    gtk_tree_view_get_column (h_tree, 1))
	  {
	    gtk_label_set_text (h_getlabel, "Expander column: 1");
	  }
	break;
      }
    case 5:
      {
	check_getcursor ();
	break;
      }
    case 6:
      {
	if (gtk_tree_view_get_reorderable (h_tree) == TRUE)
	  {
	    gtk_label_set_text (h_getlabel, "reorderable TRUE");
	  }
	else
	  {
	    gtk_label_set_text (h_getlabel, "reorderable FALSE");
	  }
	break;
      }
    case 7:
      {
	if (gtk_tree_view_row_expanded
	    (h_tree, gtk_tree_path_new_from_string ("3")) == TRUE)
	  {
	    gtk_label_set_text (h_getlabel, "Row expanded: TRUE");
	  }
	else
	  {
	    gtk_label_set_text (h_getlabel, "Row expanded: FALSE");
	  }
	break;
      }
    case 8:
      {
	gtk_tree_view_get_cell_area (h_tree,
				     gtk_tree_path_new_from_string ("2"),
				     gtk_tree_view_get_column (h_tree, 2),
				     &rect);
	sprintf (buffer, "%d,%d,%d,%d", rect.x, rect.y, rect.width,
		 rect.height);
	gtk_label_set_text (h_getlabel, buffer);
	break;
      }
    case 9:
      {
	gtk_tree_view_get_background_area (h_tree,
					   gtk_tree_path_new_from_string
					   ("2"),
					   gtk_tree_view_get_column (h_tree,
								     2),
					   &rect);
	sprintf (buffer, "%d,%d,%d,%d", rect.x, rect.y, rect.width,
		 rect.height);
	gtk_label_set_text (h_getlabel, buffer);
	break;
      }
    case 10:
      {
	gtk_tree_view_get_visible_rect (h_tree, &rect);
	sprintf (buffer, "%d,%d,%d,%d", rect.x, rect.y, rect.width,
		 rect.height);
	gtk_label_set_text (h_getlabel, buffer);
	break;
      }
    case 11:
      {
        gtk_tree_view_get_dest_row_at_pos(h_tree,20,80,&path,&pos);
        row = atoi (gtk_tree_path_to_string (path));
        sprintf(buffer,"Path =%d, Pos =%d",row,pos);
        gtk_label_set_text (h_getlabel,buffer);
        gtk_tree_path_free(path);

	break;
      }
    case 12:
      {
	gtk_tree_view_widget_to_tree_coords (h_tree, 50, 50, &tx, &ty);
	sprintf (buffer, "%d,%d", tx, ty);
	gtk_label_set_text (h_getlabel, buffer);
	break;
      }
    case 13:
      {
	gtk_tree_view_tree_to_widget_coords (h_tree, 50, 50, &tx, &ty);
	sprintf (buffer, "%d,%d", tx, ty);
	gtk_label_set_text (h_getlabel, buffer);
	break;
      }
    }


}


static gboolean
on_treeview_row_search (GtkTreeModel *model, gint column,
						const gchar *key, GtkTreeIter *iter, gpointer data)
{
	g_message ("Search key == '%s'", key);
	return FALSE;
}

void        map_row_func(GtkTreeView *tree_view,
                                             GtkTreePath *path,
                                             gpointer user_data)
{

            char buffer[32];
            gint row;
            GtkWidget *dialog;

            row = atoi (gtk_tree_path_to_string (path));
            sprintf(buffer,"Row expanded = %d",row);
	    dialog = gtk_message_dialog_new (h_window,
					     GTK_DIALOG_MODAL,
					     GTK_MESSAGE_INFO,
					     GTK_BUTTONS_CLOSE,
					     buffer);
	    gtk_dialog_run (GTK_DIALOG (dialog));

//Using gtk_widget_hide() since gtk_widget_destroy() crashes the application!	    
//	    gtk_widget_destroy (dialog);
	    gtk_widget_hide(dialog);
}



static void
column_set_func (GtkTreeViewColumn * tree_column,
		  GtkCellRenderer * cell,
		  GtkTreeModel * model, GtkTreeIter * iter, gpointer data)
{

  g_object_set (G_OBJECT (cell), "text", "ISBN 8767-98-90", NULL);

      g_object_set (G_OBJECT (cell),
		    "foreground", "darkgreen",
		    "weight", PANGO_WEIGHT_NORMAL,
		    "style", PANGO_STYLE_ITALIC, NULL);
}

void
moresetbutton_callback (GtkButton * button, gpointer user_data)
{

  gint menu_indx = gtk_option_menu_get_history (user_data);
  GdkPixmap *pixmap = NULL;
  GtkWidget *dialog;
  GtkTreeModel *model;
  GtkCellRenderer *cell_renderer;

  switch (menu_indx)
    {
    case 0:
      {
	gtk_tree_view_set_drag_dest_row (h_tree,
					 gtk_tree_path_new_from_string ("2"),
					 GTK_TREE_VIEW_DROP_BEFORE);
	break;
      }
    case 1:
      {
	pixmap =
	  gtk_tree_view_create_row_drag_icon (h_tree,
					      gtk_tree_path_new_from_string
					      ("2"));
	if (pixmap != NULL)
	  {
	    dialog = gtk_message_dialog_new (h_window,
					     GTK_DIALOG_MODAL,
					     GTK_MESSAGE_INFO,
					     GTK_BUTTONS_CLOSE,
					     "GdkPixmap Created");
	    gtk_dialog_run (GTK_DIALOG (dialog));

//Using gtk_widget_hide() since gtk_widget_destroy() crashes the application!	    
//	    gtk_widget_destroy (dialog);
	    gtk_widget_hide(dialog);
	  }
	break;
      }
    case 2:
      {
	gtk_tree_view_set_enable_search (h_tree, TRUE);
	break;
      }
    case 3:
      {
	gtk_tree_view_set_search_column (h_tree, 1);
	break;
      }
    case 4:
      {
	gtk_tree_view_set_cursor_on_cell (h_tree,
					  gtk_tree_path_new_from_string ("2"),
					  gtk_tree_view_get_column (h_tree,
								    0), NULL,
					  TRUE);
	break;
      }
    case 5:
      {
	gtk_tree_view_set_search_equal_func(h_tree, on_treeview_row_search,NULL,NULL);
	break;
      }
    case 6:
      {
	gtk_tree_view_map_expanded_rows(h_tree, map_row_func,NULL);
	break;
      }
    case 7:
      {
	model = gtk_tree_view_get_model(h_tree);
        gtk_tree_view_set_model(h_tree, model);
	break;
      }
    case 8:
      {
	gtk_tree_view_expand_to_path(h_tree,gtk_tree_path_new_from_string ("2"));
	break;
      }
    case 9:
      {
        cell_renderer = gtk_cell_renderer_text_new ();

        gtk_tree_view_insert_column_with_data_func (h_tree,
					      -1,
					      "ISBN No",
					      cell_renderer,
					      column_set_func, NULL, NULL);
	break;
      }
    case 10:
    {
        gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (h_tree)), GTK_SELECTION_MULTIPLE);
	break;
    }
	    
    }

//Using gtk_widget_hide() since gtk_widget_destroy() crashes the application!  
//  gtk_widget_destroy (h_treewindow);
    gtk_widget_hide(h_treewindow);
  gtk_widget_show (h_window);

}

void
moregetbutton_callback (GtkButton * button, gpointer user_data)
{

  char buffer[32];
  gint menu_indx = gtk_option_menu_get_history (user_data);
  GtkTreePath *path = NULL;
  GtkTreeViewDropPosition pos;
  GtkTreeViewColumn *column;
  gint cell_x;
  gint cell_y;
  gint row = 0;
  GtkTreeViewSearchEqualFunc func = NULL;

  switch (menu_indx)
    {
    case 0:
      {
	gtk_tree_view_get_drag_dest_row (h_tree, &path, &pos);
	row = atoi (gtk_tree_path_to_string (path));
	if (pos == GTK_TREE_VIEW_DROP_BEFORE && row == 2)
	  {
	    gtk_label_set_text (h_moregetlabel,
				"Pos: GTK_TREE_VIEW_DROP_BEFORE     Path: 2");
	  }
	break;
      }
    case 1:
      {
	if (gtk_tree_view_get_enable_search (h_tree) == TRUE)
	  {
	    gtk_label_set_text (h_moregetlabel, "Enable Search: TRUE");
	  }
	else
	  {
	    gtk_label_set_text (h_moregetlabel, "Enable Search: FALSE");
	  }
	break;
      }
    case 2:
      {
	if (gtk_tree_view_get_search_column (h_tree) == 1)
	  {
	    gtk_label_set_text (h_moregetlabel, "Search Column: 1");
	  }
	else
	  {
	    gtk_label_set_text (h_moregetlabel, "Search Column:None");
	  }
	break;
      }
    case 3:
      {
        gtk_tree_view_get_path_at_pos(h_tree,20,60,&path,&column,&cell_x,&cell_y);
        sprintf(buffer,"Path =%d,Cell =(%d,%d)",atoi (gtk_tree_path_to_string (path)),cell_x,cell_y);
        gtk_label_set_text (h_moregetlabel,buffer);
        gtk_tree_path_free(path);
	break;
      }
    case 4:
      {
        if(gtk_tree_view_get_search_equal_func(h_tree) == NULL)
        {
	    gtk_label_set_text (h_moregetlabel, "Search Eq fn is not set");
        }
        else
        {
	    gtk_label_set_text (h_moregetlabel, "Search Equal fn is set");
        }
	break;
      }
    }
}
