/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

void create_main_window()
{
	GList *group=NULL;
	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	box1=gtk_vbox_new(FALSE,0);
	handlebox=gtk_handle_box_new();
        hbox1=gtk_hbox_new(FALSE,0);
	hbox2=gtk_hbox_new(FALSE,0);
	
	g_signal_connect(G_OBJECT(main_window),"delete-event",gtk_main_quit,NULL);

	toolbar=gtk_toolbar_new();
	
	property_button=gtk_button_new_with_label("Set & Get Properties..");
	g_signal_connect(G_OBJECT(property_button),"clicked",G_CALLBACK(property_callback),NULL);
	
	button_tips=gtk_tooltips_new();
	gtk_tooltips_disable(button_tips);

	icon=gtk_image_new_from_file("new.xpm");
        toolitem=gtk_tool_button_new(icon,"New");
        gtk_toolbar_insert(GTK_TOOLBAR(toolbar),toolitem,-1);
	gtk_tool_item_set_tooltip(      toolitem,
                                        GTK_TOOLTIPS(button_tips),
                                        "Loads a new document",
                                        "Private Text");

	icon=gtk_image_new_from_file("open.xpm");
	toolitem=gtk_tool_button_new(icon,"Open");	
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),toolitem,-1);
	gtk_tool_item_set_tooltip(      toolitem,
                                        GTK_TOOLTIPS(button_tips),
                                        "Opens a document",
                                        "Private Text");

/*	tool1=gtk_toggle_tool_button_new();
	gtk_toolbar_insert(GTK_TOOLBAR(toolbar),tool1,-1);
	gtk_tool_button_set_stock_id(GTK_TOOL_BUTTON(tool1),"hildon-clock-alarm" );*/
	    
	
	toolitem=gtk_toggle_tool_button_new_from_stock(GTK_STOCK_BOLD);
        gtk_toolbar_insert(GTK_TOOLBAR(toolbar),toolitem,-1);

	toolitem=gtk_toggle_tool_button_new_from_stock(GTK_STOCK_ITALIC);
        gtk_toolbar_insert(GTK_TOOLBAR(toolbar),toolitem,-1);

	icon=gtk_image_new_from_file("cut.xpm");
        toolitem=gtk_tool_button_new(icon,"Cut");
        gtk_toolbar_insert(GTK_TOOLBAR(toolbar),toolitem,-1);
	gtk_tool_item_set_tooltip(      toolitem,
                                        GTK_TOOLTIPS(button_tips),
                                        "Deletes the selected item",
                                        "Private Text");

	icon=gtk_image_new_from_file("close.xpm");
        toolitem=gtk_tool_button_new(icon,"Close");
        gtk_toolbar_insert(GTK_TOOLBAR(toolbar),toolitem,-1);
	gtk_tool_item_set_tooltip(      toolitem,
                                        GTK_TOOLTIPS(button_tips),
                                        "Closes the document",
                                        "Private Text");

	quit_button=gtk_button_new_with_label("Quit");
	g_signal_connect(G_OBJECT(quit_button),"clicked",G_CALLBACK(gtk_main_quit),NULL);

	/*---------Creating the properties window-------*/
	create_second_window();
	
	/*----------CONTEXTUAL MENU creation--------------*/
       /* popup = gtk_menu_new ();
	menu_times=gtk_menu_item_new_with_label("Times");
        menu_sans=gtk_menu_item_new_with_label("Sans");
		
	gtk_widget_show (menu_sans);
	gtk_widget_show (menu_times);
	gtk_menu_append(GTK_MENU_SHELL(popup),menu_times);
	gtk_menu_append(GTK_MENU_SHELL(popup),menu_sans);
	    
	
	gtk_widget_tap_and_hold_setup (GTK_WIDGET(tool1), GTK_WIDGET(popup),
			            (GtkCallback)gtk_widget_tap_and_hold_menu_position_top, TRUE);*/
	
	//gtk_widget_tap_and_hold_setup(GTK_WIDGET(tool1),popup,NULL,TRUE);
       /*------------------------------------------------------*/
	 g_signal_connect (toolbar, "popup_context_menu", G_CALLBACK (popup_context_menu), NULL);
	
	 /*****************PACKING*******************/
	gtk_widget_set_usize(GTK_WIDGET(handlebox),500,100);
	gtk_box_pack_start(GTK_BOX(box1),hbox1,0,0,0);
	gtk_box_pack_start(GTK_BOX(hbox1),handlebox,TRUE,0,0);
	gtk_container_add(GTK_CONTAINER(handlebox),toolbar);
	gtk_box_pack_end(GTK_BOX(box1),hbox2,0,0,0);
	gtk_box_pack_start(GTK_BOX(hbox2),property_button,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox2),quit_button,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(main_window),box1);		
	gtk_widget_show_all(main_window);
}

void create_second_window(void)
{
	PangoFontDescription *smallfont;
	smallfont=pango_font_description_from_string("swissa 12");

	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(window),"delete-event",gtk_main_quit,NULL);
	
	box2=gtk_vbox_new(FALSE,20);
	set_box=gtk_hbox_new(FALSE,0);
	get_box=gtk_hbox_new(FALSE,0);
	back_box=gtk_hbox_new(FALSE,0);

	result_text=gtk_label_new("");
	gtk_widget_modify_font(GTK_WIDGET(result_text),smallfont);

	set_frame=gtk_frame_new("Set toolbar properties");
	get_frame=gtk_frame_new("Get toolbar properties");

	/*------------------GET n SET buttons--------------*/
	set_button=gtk_button_new_with_label("Set");
	get_button=gtk_button_new_with_label("Get");
	
	/*----------------------MENU for SET---------------*/
	set_menu=gtk_option_menu_new();
	gtk_widget_set_usize(GTK_WIDGET(set_menu),200,5);
	menu=gtk_menu_new();
	
	menu_item=gtk_menu_item_new_with_label("Show Arrow");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Orientation Vertical");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Orientation Horizontal");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Style-Text");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Tooltips");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Unset Style");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Drop Highlight Item");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(set_menu),menu);

	/*----------------------MENU for SET-----------------*/

	/*-----------------------SIGNAL HANDLERS-------------*/
	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_button_click),NULL);

	/*----------------------MENU for GET-----------------*/
	get_menu=gtk_option_menu_new();
        gtk_widget_set_usize(GTK_WIDGET(get_menu),200,40);
        menu=gtk_menu_new();

        menu_item=gtk_menu_item_new_with_label("Orientation");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Toolbar Style");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Tooltips");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Show Arrow");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        menu_item=gtk_menu_item_new_with_label("Icon Size");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);
	
	menu_item=gtk_menu_item_new_with_label("Relief Style");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Number of items");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Item Index");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("2nd Item");
        gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Drop Index");
	gtk_widget_modify_font(GTK_BIN(GTK_ITEM(menu_item))->child,smallfont);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

        gtk_option_menu_set_menu(GTK_OPTION_MENU(get_menu),menu);

        /*----------------------MENU for GET-----------------*/

	back_button=gtk_button_new_with_label("Back");

	/*--------------------SIGNAL HANDLERS----------------*/
	g_signal_connect(G_OBJECT(get_menu),"changed",G_CALLBACK(get_menu_changed),NULL);
        g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_button_click),NULL);
	g_signal_connect(G_OBJECT(back_button),"clicked",G_CALLBACK(back_button_click),NULL);

	/*------------------------PACKING--------------------*/

	gtk_box_pack_start(GTK_BOX(set_box),set_menu,0,0,10);
	gtk_box_pack_start(GTK_BOX(set_box),set_button,0,0,10);
	gtk_container_add(GTK_CONTAINER(set_frame),set_box);

	gtk_box_pack_start(GTK_BOX(get_box),get_menu,0,0,10);
        gtk_box_pack_start(GTK_BOX(get_box),get_button,0,0,10);
	gtk_box_pack_start(GTK_BOX(get_box),result_text,0,0,0);
        gtk_container_add(GTK_CONTAINER(get_frame),get_box);

	gtk_box_pack_start(GTK_BOX(back_box),back_button,0,0,10);

	gtk_box_pack_start(GTK_BOX(box2),set_frame,0,0,5);
	gtk_box_pack_start(GTK_BOX(box2),get_frame,0,0,5);
	gtk_box_pack_start(GTK_BOX(box2),back_box,0,0,5);
	gtk_container_add(GTK_CONTAINER(window),box2);

}
