/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"
#include<string.h>

void property_callback(GtkButton *b,gpointer user_data)
{
	gtk_widget_hide(main_window);
	gtk_widget_show_all(window);
}

void set_button_click(GtkButton *b,gpointer user_data)
{
	
	gint set_menu_index=gtk_option_menu_get_history(GTK_OPTION_MENU(set_menu));

	switch(set_menu_index)
	{
		case 0: gtk_widget_set_usize(GTK_WIDGET(handlebox),400,100);
			gtk_toolbar_set_show_arrow(GTK_TOOLBAR(toolbar),TRUE);
			break;
		case 1: gtk_widget_set_usize(GTK_WIDGET(handlebox),100,300);
			gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar),GTK_ORIENTATION_VERTICAL);
			break;
		case 2: gtk_widget_set_usize(GTK_WIDGET(handlebox),400,100);
			gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar),GTK_ORIENTATION_HORIZONTAL);
			break;
		case 3: gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),GTK_TOOLBAR_TEXT);
			break;
		case 4: gtk_tooltips_enable(button_tips);
			break;
		case 5: gtk_toolbar_unset_style(GTK_TOOLBAR(toolbar));
			break;
		case 6: /*drop highlight item*/
			ic=gtk_image_new_from_file("save.xpm");
			item1=gtk_tool_button_new(ic,"save");
			gtk_toolbar_set_drop_highlight_item(GTK_TOOLBAR(toolbar),item1,1);
			break;
	}

	gtk_widget_hide(window);
	gtk_widget_show_all(main_window);
}

void get_menu_changed(GtkOptionMenu *o,gpointer user_data)
{
	gtk_label_set_text(GTK_LABEL(result_text),"");
}

void get_button_click(GtkButton *b,gpointer user_data)
{
	gint get_menu_index=gtk_option_menu_get_history(GTK_OPTION_MENU(get_menu));
	gint result;
	gchar *str;
	GtkToolItem *tr;
	switch(get_menu_index)
	{
		case 0: result=gtk_toolbar_get_orientation(GTK_TOOLBAR(toolbar));
			if(result==0)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ORIENTATION_HORIZONTAL");
			}
			else
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ORIENTATION_VERTICAL");
			}
			break;
		case 1: result=gtk_toolbar_get_style(GTK_TOOLBAR(toolbar));
			if(result==0)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_TOOLBAR_ICONS");
			}
			else if(result==1)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_TOOLBAR_TEXT");
			}
			else if(result==2)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_TOOLBAR_BOTH");
			}
			else if(result==3)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_TOOLBAR_BOTH_HORIZ");
			}
			break;
		case 2: result=gtk_toolbar_get_tooltips(GTK_TOOLBAR(toolbar));
			if(result==0)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"FALSE");
			}
			else
			{
				gtk_label_set_text(GTK_LABEL(result_text),"TRUE");
			}
			break;
		case 3: result=gtk_toolbar_get_show_arrow(GTK_TOOLBAR(toolbar));
			if(result==0)
                        {
                                gtk_label_set_text(GTK_LABEL(result_text),"FALSE");
                        }
                        else
                        {
                                gtk_label_set_text(GTK_LABEL(result_text),"TRUE");
                        }
                        break;
		case 4: result=gtk_toolbar_get_icon_size(GTK_TOOLBAR(toolbar));
			if(result==0)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_INVALID");
			}
			else if(result==1)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_MENU");
			}
			else if(result==2)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_SMALL_TOOLBAR");
			}
			else if(result==3)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_LARGE_TOOLBAR");
			}
			else if(result==4)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_BUTTON");
			}
			else if(result==5)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_DND");
			}
			else
			{
				gtk_label_set_text(GTK_LABEL(result_text),"GTK_ICON_SIZE_DIALOG");
			}
			break;
		case 5: result=gtk_toolbar_get_relief_style(GTK_TOOLBAR(toolbar));
			if(result==0)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"NORMAL");
			}
			else if(result==1)
			{
				gtk_label_set_text(GTK_LABEL(result_text),"HALF");
			}
			else
			{
				gtk_label_set_text(GTK_LABEL(result_text),"NONE");
			}
			break;
		case 6: result=gtk_toolbar_get_n_items(GTK_TOOLBAR(toolbar));
			sprintf(str,"%d",result);
			gtk_label_set_text(GTK_LABEL(result_text),str);
			break;
		case 7: result=gtk_toolbar_get_item_index(GTK_TOOLBAR(toolbar),toolitem);
			str="Index of \'close\':";
			gchar s[20];
			sprintf(s,"%d",result);
			str=g_strjoin(" ",str,s,NULL);
			gtk_label_set_text(GTK_LABEL(result_text),str);
			break;
		case 8:
			tr=gtk_toolbar_get_nth_item(GTK_TOOLBAR(toolbar),1);
			gchar *f;
			f=gtk_tool_button_get_label(GTK_TOOL_BUTTON(tr));
			gtk_label_set_text(GTK_LABEL(result_text),f);
			break;
		case 9: result=gtk_toolbar_get_drop_index(GTK_TOOLBAR(toolbar),77,99);
			sprintf(str,"%d",result);
			gtk_label_set_text(GTK_LABEL(result_text),str);
			break;
	}
}

void back_button_click(GtkButton *b,gpointer user_data)
{
	gtk_widget_hide(window);
	gtk_widget_show_all(main_window);
}

gboolean popup_context_menu (GtkToolbar *toolbar, gint x, gint y, gint button_number)
{
	GtkMenu *menu = GTK_MENU (gtk_menu_new ());
	int i;
        for (i = 0; i < 5; i++)
		{
		GtkWidget *item;
		gchar *label = g_strdup_printf ("Item _%d", i);
		item = gtk_menu_item_new_with_mnemonic (label);
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
		}
	gtk_widget_show_all (GTK_WIDGET (menu));
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, 1, gtk_get_current_event_time());
        return TRUE;
}

