/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*---------------Creation of the properties window---------------*/
void create_second_window(void)
{
	s_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	s_vbox=gtk_vbox_new(FALSE,0);
	s_hbox1=gtk_hbox_new(FALSE,0);
	s_hbox2=gtk_hbox_new(FALSE,0);
	s_hbox3=gtk_hbox_new(FALSE,0);

	set_menu=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Wrap Mode");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Not Editable");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Editable");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Overwrite");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"No Overwrite");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Pixels above lines");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Pixels below lines");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Pixels inside wrap");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Justification-Left");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Indent");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Left Margin");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Justification-Right");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Justification-Center");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Justification-Fill");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Right Margin");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Tabs");
	gtk_combo_box_append_text(GTK_COMBO_BOX(set_menu),"Accepts tab-No");
	gtk_combo_box_set_active(GTK_COMBO_BOX(set_menu),0);
	
	get_menu=gtk_combo_box_new_text();
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Wrap Mode");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Editable");
	gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Cursor Visible");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Overwrite");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Pixels above lines");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Pixels below lines");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Pixels inside wrap");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Justification");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Left Margin");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Right Margin");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Indent");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Tabs");
        gtk_combo_box_append_text(GTK_COMBO_BOX(get_menu),"Accepts tab");
	gtk_combo_box_set_active(GTK_COMBO_BOX(get_menu),0);

	set_button=gtk_button_new_with_label("Set");
	get_button=gtk_button_new_with_label("Get");
	result=gtk_label_new("");
	back=gtk_button_new_with_label("Back");

	g_signal_connect(G_OBJECT(set_button),"clicked",G_CALLBACK(set_callback),NULL);
	g_signal_connect(G_OBJECT(get_button),"clicked",G_CALLBACK(get_callback),NULL);
	g_signal_connect(G_OBJECT(back),"clicked",G_CALLBACK(back_callback),NULL);
	
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox1,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox2,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(s_vbox),s_hbox3,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_menu,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox1),set_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox2),get_menu,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox2),get_button,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox2),result,FALSE,FALSE,10);
	gtk_box_pack_start(GTK_BOX(s_hbox3),back,FALSE,FALSE,10);
	gtk_container_add(GTK_CONTAINER(s_window),s_vbox);
}

/*------------Creates the first window of the widget----------*/
void create_main_window (void)
{
	m_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	m_vbox=gtk_vbox_new(FALSE,0);
	m_hbox1=gtk_hbox_new(FALSE,0);
	m_hbox2=gtk_hbox_new(FALSE,0);
	m_hbox3=gtk_hbox_new(FALSE,0);
	m_hbox4=gtk_hbox_new(FALSE,0);

	frame=gtk_frame_new("TextView");
	smallfont=pango_font_description_from_string("Swissa 12");
	
	text_view=gtk_text_view_new();
	gtk_widget_set_usize(text_view,600,150);
	text_buff=gtk_text_view_get_buffer(GTK_TEXT_VIEW(text_view));
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(text_view),text_buff);

	property=gtk_button_new_with_label("Set/Get Properties");
	quit_button=gtk_button_new_with_label(" Quit ");

	create_second_window();

	/*-------------------Signal Handlers-----------------*/
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(m_window),"destroy",gtk_main_quit,NULL);
	g_signal_connect(G_OBJECT(property),"clicked",G_CALLBACK(property_callback),NULL);
	
	/*---------------------PACKING-------------------------*/
	gtk_box_pack_start(GTK_BOX(m_vbox),m_hbox1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox3,0,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_vbox),m_hbox2,0,FALSE,0);

	gtk_box_pack_start(GTK_BOX(m_hbox1),frame,TRUE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(m_hbox4),text_view,TRUE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame),m_hbox4);
	gtk_box_pack_end(GTK_BOX(m_hbox2),property,TRUE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(m_hbox3),quit_button,TRUE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(m_window),m_vbox);

	gtk_widget_show_all(m_window);
	pango_font_description_free(smallfont);
}
