/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*----------Callback for SET/GET property button---------*/
void property_callback(GtkButton *b,gpointer data)
{
	gtk_widget_hide(m_window);
	gtk_label_set_text(GTK_LABEL(result),"");
	gtk_widget_show_all(s_window);
}

/*----------Callback for the set button -----------*/
void set_callback(GtkButton *b,gpointer data)
{
	gint val;
	val=gtk_combo_box_get_active(GTK_COMBO_BOX(set_menu));
	PangoTabArray *pa;
	switch(val)
	{
		case 0: gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text_view),GTK_WRAP_WORD);
			break;
		case 1: gtk_text_view_set_editable(GTK_TEXT_VIEW(text_view),FALSE);
			gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(text_view),FALSE);
			break;
		case 2: gtk_text_view_set_editable(GTK_TEXT_VIEW(text_view),TRUE);
			gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(text_view),TRUE);
			break;
		case 3: gtk_text_view_set_overwrite(GTK_TEXT_VIEW(text_view),TRUE);
			break;
		case 4: gtk_text_view_set_overwrite(GTK_TEXT_VIEW(text_view),FALSE);
                        break;
		case 5: gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(text_view),9);
			break;
		case 6: gtk_text_view_set_pixels_below_lines(GTK_TEXT_VIEW(text_view),12);
                        break;
		case 7: gtk_text_view_set_pixels_inside_wrap(GTK_TEXT_VIEW(text_view),10);
			break;
		case 8: gtk_text_view_set_justification(GTK_TEXT_VIEW(text_view),GTK_JUSTIFY_LEFT);
			break;
		case 9: gtk_text_view_set_indent(GTK_TEXT_VIEW(text_view),20);
			 break;
		case 10: gtk_text_view_set_left_margin(GTK_TEXT_VIEW(text_view),15);
			break;
		case 11:gtk_text_view_set_justification(GTK_TEXT_VIEW(text_view),GTK_JUSTIFY_RIGHT);
                        break;
		case 12:gtk_text_view_set_justification(GTK_TEXT_VIEW(text_view),GTK_JUSTIFY_CENTER);
                        break;
		case 13:gtk_text_view_set_justification(GTK_TEXT_VIEW(text_view),GTK_JUSTIFY_FILL);
                        break;
		case 14: gtk_text_view_set_right_margin(GTK_TEXT_VIEW(text_view),10);
			break;
		case 15: pa=pango_tab_array_new_with_positions(1,TRUE,PANGO_TAB_LEFT,10);
			 gtk_text_view_set_tabs(GTK_TEXT_VIEW(text_view),pa);
			break;
		case 16:gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(text_view),FALSE);
			break;
			
	}
	gtk_widget_hide(s_window);
	gtk_widget_show_all(m_window);
}


/*---------------Callback for the get button---------------*/
void get_callback(GtkButton *b,gpointer data)
{
	gboolean res;
	PangoTabArray *pa;
	gint num;
	gchar str[10];
	gint val;
        val=gtk_combo_box_get_active(GTK_COMBO_BOX(get_menu));
	PangoTabAlign align;
                                                                                                                             
        switch(val)
        {
	                case 0: num=gtk_text_view_get_wrap_mode(GTK_TEXT_VIEW(text_view));
				if(num==0)
				gtk_label_set_text(GTK_LABEL(result),"GTK_WRAP_NONE");
				else if(num==1)
				gtk_label_set_text(GTK_LABEL(result),"GTK_WRAP_CHAR");
				else if(num==2)
				gtk_label_set_text(GTK_LABEL(result),"GTK_WRAP_WORD");
				else if(num==3)
				gtk_label_set_text(GTK_LABEL(result),"GTK_WRAP_WORD_CHAR");
				break;
	                case 1: res=gtk_text_view_get_editable(GTK_TEXT_VIEW(text_view));
				if(res==TRUE)
                                gtk_label_set_text(GTK_LABEL(result),"TRUE");
                                else
	                        gtk_label_set_text(GTK_LABEL(result),"FALSE");
	                        break;
			case 2: res=gtk_text_view_get_cursor_visible(GTK_TEXT_VIEW(text_view));
				if(res==TRUE)
                                gtk_label_set_text(GTK_LABEL(result),"TRUE");
                                else
                                gtk_label_set_text(GTK_LABEL(result),"FALSE");
                                break;
			case 3: res=gtk_text_view_get_overwrite(GTK_TEXT_VIEW(text_view));
				if(res==TRUE)
                                gtk_label_set_text(GTK_LABEL(result),"TRUE");
                                else
                                gtk_label_set_text(GTK_LABEL(result),"FALSE");
                                break;
			case 4: num=gtk_text_view_get_pixels_above_lines(GTK_TEXT_VIEW(text_view));
				sprintf(str,"%d",num);
                                gtk_label_set_text(GTK_LABEL(result),str);
				break;
			case 5: num=gtk_text_view_get_pixels_below_lines(GTK_TEXT_VIEW(text_view));
                                sprintf(str,"%d",num);
                                gtk_label_set_text(GTK_LABEL(result),str);
                                break;
			case 6: num=gtk_text_view_get_pixels_inside_wrap(GTK_TEXT_VIEW(text_view));
				sprintf(str,"%d",num);
				gtk_label_set_text(GTK_LABEL(result),str);
				break;
			case 7: num=gtk_text_view_get_justification(GTK_TEXT_VIEW(text_view));
				if(num==0)
					 gtk_label_set_text(GTK_LABEL(result),"LEFT");
				else if(num==1)
					 gtk_label_set_text(GTK_LABEL(result),"RIGHT");
				else if(num==2)
					 gtk_label_set_text(GTK_LABEL(result),"CENTER");
				else
					 gtk_label_set_text(GTK_LABEL(result),"FILL");
				break;
			case 8: num=gtk_text_view_get_left_margin(GTK_TEXT_VIEW(text_view));
				sprintf(str,"%d",num);
                                gtk_label_set_text(GTK_LABEL(result),str);
				break;
			case 9: num=gtk_text_view_get_right_margin(GTK_TEXT_VIEW(text_view));
                                sprintf(str,"%d",num);
                                gtk_label_set_text(GTK_LABEL(result),str);
                                break;
			case 10:num=gtk_text_view_get_indent(GTK_TEXT_VIEW(text_view));
				sprintf(str,"%d",num);
				gtk_label_set_text(GTK_LABEL(result),str);
				break;
			case 11:pa=gtk_text_view_get_tabs(GTK_TEXT_VIEW(text_view));
				pango_tab_array_get_tab(pa,NULL,&align,NULL);
				if(align==0)
					gtk_label_set_text(GTK_LABEL(result),"PANGO_TAB_LEFT");
				break;
			case 12:res=gtk_text_view_get_accepts_tab(GTK_TEXT_VIEW(text_view));
				if(res==TRUE)
				gtk_label_set_text(GTK_LABEL(result),"TRUE");
				else
				gtk_label_set_text(GTK_LABEL(result),"FALSE");
				break;
	}
}

/*---------Displays the first window-------*/
void back_callback(GtkButton *b,gpointer data)
{
	gtk_widget_hide(s_window);
	gtk_widget_show_all(m_window);
}
