/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"



void sec_window()
{
	sec_win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(sec_win), 30);

	s_hbox=gtk_hbox_new(FALSE, 0);
	s_hbox1=gtk_hbox_new(FALSE, 0);
	s_hbox2=gtk_hbox_new(FALSE, 0);
	s_vbox=gtk_vbox_new(FALSE, 0);
	
	Lpolicy=gtk_label_new("Show ScrollBars?");
	gtk_box_pack_start(GTK_BOX(s_hbox), Lpolicy, FALSE, 0, 0);
		
	c_policy=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_policy), "Always");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_policy), "Never");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_policy), "Automatic");
	gtk_box_pack_start(GTK_BOX(s_hbox), c_policy, FALSE, 0, 10);
	gtk_signal_connect(GTK_OBJECT(c_policy), "changed", GTK_SIGNAL_FUNC(on_policy), NULL);

	Lshadow=gtk_label_new("Set Shadow:");
	gtk_box_pack_start(GTK_BOX(s_hbox),Lshadow, FALSE, 0, 20);

	c_shadow=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_shadow), "Etched IN");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_shadow), "Etched OUT");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_shadow), "IN");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_shadow), "OUT");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_shadow), "NONE");
	gtk_box_pack_end(GTK_BOX(s_hbox), c_shadow, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(c_shadow), "changed", GTK_SIGNAL_FUNC(on_shadow), NULL);

	Lplace=gtk_label_new("Set Placement:");
	gtk_box_pack_start(GTK_BOX(s_hbox1), Lplace, FALSE, 0 , 0);
	
	c_place=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_place), "Bottom Left");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_place), "Bottom Right");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_place), "Top Right");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_place), "Top Left");
	gtk_box_pack_start(GTK_BOX(s_hbox1), c_place, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(c_place), "changed", GTK_SIGNAL_FUNC(on_place), NULL);

	Lalign=gtk_label_new("Set:");
	gtk_box_pack_start(GTK_BOX(s_hbox1), Lalign, FALSE, 0 , 20);

	c_align=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_align), "Horizontal Adjustment");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_align), "Vertical Adjustment");
	gtk_box_pack_end(GTK_BOX(s_hbox1), c_align, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(c_align), "changed", GTK_SIGNAL_FUNC(on_align), NULL);

	Lget=gtk_label_new("Get:");
	gtk_box_pack_start(GTK_BOX(s_hbox2), Lget, FALSE, 0 , 0);

	c_get=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_get), "Shadow Type");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_get), "Placement");
	gtk_combo_box_append_text(GTK_COMBO_BOX(c_get), "Policy");
	gtk_box_pack_start(GTK_BOX(s_hbox2), c_get, FALSE, 0, 10);
	gtk_signal_connect(GTK_OBJECT(c_get), "changed", GTK_SIGNAL_FUNC(on_get), NULL);

	Lget_value=gtk_label_new(" ");
	gtk_box_pack_start(GTK_BOX(s_hbox2), Lget_value, FALSE, 0 , 10);

	gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox1, FALSE, 0, 20);
	gtk_box_pack_start(GTK_BOX(s_vbox), s_hbox2, FALSE, 0, 20);
	gtk_container_add(GTK_CONTAINER(sec_win), s_vbox);
	
	
}
//Creates the main window
void create_window()
{
	sec_window();
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 30);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", gtk_main_quit, NULL);

	vbox = gtk_vbox_new(FALSE, 0);
	vbox1=gtk_vbox_new(FALSE, 0);
	
	hbox=gtk_hbox_new(FALSE, 0);
	hbox1=gtk_hbox_new(FALSE, 0);

	/*-----Creating ScrollWindow----*/
	hadj=gtk_adjustment_new(0.0, 0.0, 30.0, 2.0,5.0, 0.0);
	vadj=gtk_adjustment_new(0.0, 0.0, 30.0, 2.0, 5.0, 0.0);
	scrollwindow=gtk_scrolled_window_new(	GTK_ADJUSTMENT(hadj), GTK_ADJUSTMENT(vadj));
	gtk_widget_set_usize(scrollwindow, 710, 300);

	text_buff=gtk_text_buffer_new (NULL);
	
	gtk_text_buffer_insert_at_cursor(text_buff, "Scroll Control is a “remote control” widget for Scroll Bar 3.6.4 that enables the user to scroll the application area even if he/she single taps\n or drags stylus on the area between the scroll bar and the right edge of the screen. \nScroll Control simply replaces the right side bitmap of the application area. \nThe interaction of the control is the same as in\n the equivalent position of the Scroll Bar 3.6.4.\n See Graphical Details for exact hotspots and pixel measurements.\nScroll Bar is used to indicate that all contents of a window or region does not\n fit to the reserved area. The length of the thumb indicates the relative size of the component\n that is currently It allows the user to scroll page up/down/right/left.\n A Scroll Bar can be used in a view or dialog, but it also appears automatically\n when content of the dialog or application area does not fit into display.\nNOTE: In widgets that do not have a native support for scrolling, \nscroll bars are implemented by creating a scrollable window for them with GtkScrolledWindow.\n \nThumb moves to the same direction as the pen. Content being scrolled scrolls smoothly \nrather than updating when the\nButton down effect and thumb moves to the direction of the arrow (in lists,\n focus moves one list item at a time). Long press performs a key repeat.\n Stylus up on an arrow causes button up effect and thumb stops moving", 1300);
		
	//gtk_text_buffer_insert_at_cursor(text_buff, "hello there!!?",14);
	textview=gtk_text_view_new_with_buffer(text_buff);
	scroll_area=hildon_scroll_area_new(scrollwindow, textview);
	gtk_box_pack_start_defaults (GTK_BOX (vbox), scroll_area);
	
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwindow), vbox);
	gtk_container_add(GTK_CONTAINER(hbox), scrollwindow);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, 0, 0);

	Bprop=gtk_button_new_with_label("Properties");
	gtk_widget_set_usize(Bprop, 300, 40);
	gtk_box_pack_start(GTK_BOX(hbox1), Bprop, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bprop), "clicked", GTK_SIGNAL_FUNC(on_prop), NULL);

	Bexit=gtk_button_new_with_label("Exit");
	gtk_widget_set_usize(Bexit, 300, 40);
	gtk_box_pack_end(GTK_BOX(hbox1), Bexit, FALSE, 0, 0);
	gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", GTK_SIGNAL_FUNC(on_exit), NULL);

	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, 0, 20);
	gtk_container_add(GTK_CONTAINER(window), vbox1);
//	label=gtk_label_new("Scroll Control is a �@~\remote control�@~] widget for Scroll Bar l 3.6.4 that enables the user to scroll the application area even if he/she single taps\n or drags stylus on the area between the scroll bar and the right edge of the screen. \nScroll Control simply replaces the right side bitmap of the application area. \nThe interaction of the control is the same as in\n the equivalent position of the Scroll Bar 3.6.4.\n See Graphical Details for exact hotspots and pixel measurements.\nScroll Bar is used to indicate that all contents of a window or region does not\n fit to the reserved area. The length of the thumb indicates the relative size of the component\n that is currently It allows the user to scroll page up/down/right/left.\n A Scroll Bar can be used in a view or dialog, but it also appears automatically\n when content of the dialog or application area does not fit into display.\nNOTE: In widgets that do not have a native support for scrolling, \nscroll bars are implemented by creating a scrollable window for them with GtkScrolledWindow.\n \nThumb moves to the same direction as the pen. Content being scrolled scrolls smoothly \nrather than updating when the\nButton down effect and thumb moves to the direction of the arrow (in lists,\n focus moves one list item at a time). Long press performs a key repeat.\n Stylus up on an arrow causes button up effect and thumb stops moving");
//	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwindow),label);
//	gtk_container_add(GTK_CONTAINER(window),scrollwindow);
	gtk_widget_show_all(window);
}
