/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*------Callback on clicking 'Exit'------*/
void on_exit(GtkWidget *button, gpointer data)
{
	gtk_main_quit();
}

/*------Callback on clicking 'Properties'------*/
void on_prop(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(window);
	gtk_widget_show_all(sec_win);
}

/*------Callback on selecting an item from 'Show Scrollbar?' combo box------*/
void on_policy(GtkWidget *cobo, gpointer data)
{
	gint i;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(c_policy));
        if(i == 0 )
        {
                gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow), GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
        }
	else if(i == 1 )
	{
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow), GTK_POLICY_NEVER, GTK_POLICY_NEVER);
	}
	else if(i == 2 )
	{
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	}
	gtk_widget_hide(sec_win);
        gtk_widget_show_all(window);
	
			
}

/*------Callback on selecting an item from 'Set' combo box------*/
void on_shadow(GtkWidget *combo, gpointer data)
{
	gint i;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(c_shadow));
        if(i == 0 )
        {
		gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollwindow), GTK_SHADOW_ETCHED_IN);
	}
	else if(i == 1 )
	{
		gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollwindow), GTK_SHADOW_ETCHED_OUT);
	}
	else if(i == 2 )
	{
		gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollwindow), GTK_SHADOW_IN);
	}
	else if(i == 3 )
	{
		gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollwindow), GTK_SHADOW_OUT);
	}
	else if(i == 4 )
	{
		gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollwindow), GTK_SHADOW_NONE);
	}
			
	gtk_widget_hide(sec_win);
        gtk_widget_show_all(window);
}

/*------Callback on selecting an item from 'Set PLacement' combo box-----*/
void on_place(GtkWidget *combo, gpointer data)
{
	gint i;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(c_place));
	if(i == 0 )
	{
		gtk_scrolled_window_set_placement(GTK_SCROLLED_WINDOW(scrollwindow), GTK_CORNER_BOTTOM_LEFT);
	}
	else if( i == 1 )
	{
		gtk_scrolled_window_set_placement(GTK_SCROLLED_WINDOW(scrollwindow), GTK_CORNER_BOTTOM_RIGHT);
	}
	else if(i == 2 )
	{
		gtk_scrolled_window_set_placement(GTK_SCROLLED_WINDOW(scrollwindow),GTK_CORNER_TOP_RIGHT);
	}
	else if( i == 3 )
	{
		gtk_scrolled_window_set_placement(GTK_SCROLLED_WINDOW(scrollwindow), GTK_CORNER_TOP_LEFT);
	}
	 gtk_widget_hide(sec_win);
         gtk_widget_show_all(window);
		
}

/*------Callbak on selecgting an item from 'Set' combo box------*/
void on_align(GtkWidget *combo, gpointer data)
{
	gint i;
	GtkAdjustment *adj;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(c_align));
	if(i == 0 )
	{
		adj=gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(scrollwindow));
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj), 10.0);
		gtk_scrolled_window_set_hadjustment(GTK_SCROLLED_WINDOW(scrollwindow), GTK_ADJUSTMENT(adj));
	}
	else if(i == 1 )
	{
		adj=gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrollwindow));
		gtk_adjustment_set_value(GTK_ADJUSTMENT(adj), 15.0);
		gtk_scrolled_window_set_hadjustment(GTK_SCROLLED_WINDOW(scrollwindow), GTK_ADJUSTMENT(adj));
	}
	gtk_widget_hide(sec_win);
	gtk_widget_show(window);
	
}

/*------Callback on selecting an item from the 'Get' combo box------*/
void on_get(GtkWidget *combo, gpointer data)
{
	gint i;
	gint x;
	GtkAdjustment *adj;
        i=gtk_combo_box_get_active(GTK_COMBO_BOX(c_get));
	if(i == 0 )
	{
		x=gtk_scrolled_window_get_shadow_type(GTK_SCROLLED_WINDOW(scrollwindow));
		if(x == 0 )
			gtk_label_set_text(GTK_LABEL(Lget_value),"NONE");
		else if(x == 1 )
			gtk_label_set_text(GTK_LABEL(Lget_value),"IN");
		else if(x == 2 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "OUT");
		else if(x == 3 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "Etched IN");
		else if(x == 4 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "Etched OUT");
	}
			
	else if(i == 1 )
	{
		x=gtk_scrolled_window_get_placement(GTK_SCROLLED_WINDOW(scrollwindow));
		if(x == 0)
			gtk_label_set_text(GTK_LABEL(Lget_value), "Top Left");
		else if(x == 1 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "Bottom Left");
		else if(x == 2 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "Top Right");
		else if(x == 3 )
			gtk_label_set_text(GTK_LABEL(Lget_value), "Bottom Right");
	}
	
	else if(i == 2 )
	{
		GtkPolicyType *hpolicy, *vpolicy; 
		gtk_scrolled_window_get_policy(GTK_SCROLLED_WINDOW(scrollwindow), &hpolicy, &vpolicy);
		if(hpolicy == 0 && vpolicy == 0)
			gtk_label_set_text(GTK_LABEL(Lget_value), "Always");
		else if(hpolicy == 1 && vpolicy == 1)
			gtk_label_set_text(GTK_LABEL(Lget_value), "Automatic");
		else if(hpolicy == 2 && vpolicy == 2)
			gtk_label_set_text(GTK_LABEL(Lget_value), "Never");
			
	}
}
