/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

/*-------------Creates the window with the widget--------*/
 GtkWidget* create_main_window(void)
{
    
    GtkWidget *mvbox,*mhbox;
    GtkWidget *vbox1,*vbox2;
    GtkWidget *label;
    GtkWidget *radio1,*radio2;
    GtkWidget *radio3,*radio4;
    GtkWidget *radio5,*radio6;
    GtkWidget *entry;
    GtkWidget *button1;
    GtkWidget *button2;
    GtkWidget *separator;
    GtkWidget *quit_button;
    GSList *group;
  
    window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window),"Radio Button App");
    gtk_container_set_border_width(GTK_CONTAINER(window),10);
    gtk_signal_connect(GTK_OBJECT(window),"delete_event",GTK_SIGNAL_FUNC(gtk_main_quit),NULL);

    mvbox=gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(window),mvbox);
    
    mhbox=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(mvbox),mhbox,FALSE,FALSE,0);
    
    vbox1=gtk_vbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(mhbox),vbox1,TRUE,TRUE,5);

    /* create a radiobutton with entry box as its label */
    
    radio1=gtk_radio_button_new(NULL);
    entry=gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry),"Rose");
    gtk_container_add(GTK_CONTAINER(radio1),entry);
    gtk_box_pack_start(GTK_BOX(vbox1),radio1,TRUE,TRUE,5);

    /* add radiobuttons to radio1 buttongroup */
    
    radio2=gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio1),"Lily");
    gtk_box_pack_start(GTK_BOX(vbox1),radio2,TRUE,TRUE,5);

    radio3=gtk_radio_button_new_with_mnemonic_from_widget(GTK_RADIO_BUTTON(radio1),"Da_isy");
    gtk_box_pack_start(GTK_BOX(vbox1),radio3,TRUE,TRUE,5);

    radio4=gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(radio1));
    label=gtk_label_new("Jasmine");
    gtk_container_add(GTK_CONTAINER(radio4),label);
    gtk_box_pack_start(GTK_BOX(vbox1),radio4,TRUE,TRUE,5);
    
    /* define a separator */
    
    separator=gtk_vseparator_new();
    gtk_box_pack_start(GTK_BOX(mhbox),separator,TRUE,TRUE,5);
    
    vbox2=gtk_vbox_new(FALSE,0);
    gtk_box_pack_end(GTK_BOX(mhbox),vbox2,TRUE,TRUE,5);

    /* define a different button group */
    
    radio5=gtk_radio_button_new_with_label(NULL,"Black");
    gtk_box_pack_start(GTK_BOX(vbox2),radio5,TRUE,TRUE,5);
    /* add a signal */
    g_signal_connect(G_OBJECT(radio5),"clicked",G_CALLBACK(test),NULL);
    
    /* add radiobuttons to the new group */
    
    group=gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio5));
    button1=gtk_radio_button_new_with_label(group,"Green");
    gtk_box_pack_start(GTK_BOX(vbox2),button1,TRUE,TRUE,5);
    
    group=gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio5));
    button2=gtk_radio_button_new_with_mnemonic(NULL,"Bl_ue");
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(button2),group);
    gtk_box_pack_start(GTK_BOX(vbox2),button2,TRUE,TRUE,5);

    group=gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio5));
    radio6=gtk_radio_button_new_with_mnemonic(NULL,"Magen_ta");
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio6),group);
    gtk_box_pack_start(GTK_BOX(vbox2),radio6,TRUE,TRUE,5);

    quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
    gtk_box_pack_end(GTK_BOX(mvbox),quit_button,FALSE,FALSE,0);
    g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);
    
    gtk_widget_show_all(window);
}
