/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "interface.h"
#include "callbacks.h"

//Creates the main window
void  create_main_window()
{
 window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_container_set_border_width(GTK_CONTAINER(window), 10);
 gtk_window_set_default_size(GTK_WINDOW(window),200,90);
 v_box=gtk_vbox_new(FALSE,5);
 hh_box=gtk_hbox_new(TRUE,5);
 vv_box=gtk_vbox_new(TRUE,5);
 vvv_box=gtk_vbox_new(FALSE,15);
 
/*-------------------Creates the progress bar--------------------*/
 progress_bar=gtk_progress_bar_new();
 gtk_progress_configure(GTK_PROGRESS(progress_bar), 0.0, 0.0, 100.0 );
 gtk_box_pack_start(GTK_BOX(v_box), progress_bar,FALSE,FALSE, 5);
/*---------------------------------------------------------------*/
 
 Bproperty=gtk_button_new_with_label("Properties");
 gtk_widget_set_usize(Bproperty,20,40);
 gtk_box_pack_start(GTK_BOX(v_box), Bproperty, FALSE, FALSE,5);
 
 Bexit=gtk_button_new_with_label("Exit"); 
 gtk_box_pack_end(GTK_BOX(hh_box), Bexit, TRUE, TRUE, 6); 
 
 gtk_container_add(GTK_CONTAINER(vv_box), v_box);
 gtk_container_add(GTK_CONTAINER(vv_box), hh_box);
 gtk_container_add(GTK_CONTAINER(window), vv_box);
 
 /*-------------------------Signal Handlers-----------------------*/
 gtk_signal_connect(GTK_OBJECT(Bexit), "clicked", GTK_SIGNAL_FUNC(quit), NULL);
 gtk_signal_connect(GTK_OBJECT(Bproperty), "clicked", GTK_SIGNAL_FUNC(create_option_window), NULL);
/*----------------------------------------------------------------*/
 
 gtk_widget_show_all(window);
}

//Creates the second window containing the different properties of the progress bar
void create_option_window()
{
 option_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_container_set_border_width(GTK_CONTAINER(option_window), 10);
 v1_box=gtk_vbox_new(FALSE,5);
 h1_box=gtk_hbox_new(FALSE,5);
 h2_box=gtk_hbox_new(TRUE,5);
 h3_box=gtk_hbox_new(TRUE,5);
 h4_box=gtk_hbox_new(TRUE,5);
 
 frame=gtk_frame_new("Set/Get Value");
 gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
 frame2=gtk_frame_new(" Bar Style"); 
 gtk_frame_set_shadow_type(GTK_FRAME(frame2), GTK_SHADOW_ETCHED_OUT);
 frame3=gtk_frame_new(" Orientation ");
 gtk_frame_set_shadow_type(GTK_FRAME(frame3), GTK_SHADOW_ETCHED_OUT);
 
 Vmain_box=gtk_vbox_new(FALSE,15);
 Vmain1_box=gtk_vbox_new(FALSE,5);
 Vmain2_box=gtk_vbox_new(FALSE,5); 
 Vf_box=gtk_vbox_new(FALSE,5);
 Vf2_box=gtk_vbox_new(FALSE, 5);
 Vf3_box=gtk_vbox_new(FALSE,5);
 v5_box=gtk_hbox_new(TRUE,5);
 v6_box=gtk_hbox_new(FALSE,5);
 
 Eget=gtk_entry_new();
 gtk_widget_set_usize(Eget, 20,40);
 gtk_box_pack_end(GTK_BOX(h2_box), Eget, FALSE, TRUE, 5);
 
 Cset = gtk_check_button_new_with_label ("Set Value"); 
 gtk_box_pack_start(GTK_BOX(h4_box), Cset, FALSE, FALSE, 5);
 
 Eset=gtk_entry_new();
 gtk_widget_set_sensitive(GTK_WIDGET(Eset), FALSE);
 gtk_box_pack_end(GTK_BOX(h4_box), Eset, FALSE, TRUE, 5);
 
 Cget = gtk_check_button_new_with_label ("Get Value"); 
 gtk_box_pack_end(GTK_BOX(h2_box), Cget, FALSE, FALSE, 5);
 
 Ccont = gtk_check_button_new_with_label ("Continuous");
 gtk_box_pack_start(GTK_BOX(h3_box), Ccont, FALSE, FALSE, 5);
 
 if(flag_cont==1)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Ccont), TRUE);
 else if(flag_cont==0)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Ccont), FALSE);

 if(flag_dis_check==1)
   gtk_widget_set_sensitive(GTK_WIDGET(Ccont), FALSE);

 if(flag_activity_check==1)
   gtk_widget_set_sensitive(GTK_WIDGET(Ccont),FALSE);

 Cdis = gtk_check_button_new_with_label("Discrete");
 gtk_box_pack_start(GTK_BOX(h3_box), Cdis, FALSE, FALSE, 5);

 if(flag_dis==1)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cdis), TRUE);
 else if(flag_dis==0)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cdis), FALSE);

 if(flag_cont_check==1)
   gtk_widget_set_sensitive(GTK_WIDGET(Cdis), FALSE);

 if(flag_activity_check==1)
   gtk_widget_set_sensitive(GTK_WIDGET(Cdis),FALSE);
 
 Cact = gtk_check_button_new_with_label("Activity Mode/Step ");
 gtk_box_pack_start(GTK_BOX(v5_box), Cact, FALSE, TRUE, 5);

 if(flag_activity==1)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cact), TRUE);
 else if(flag_activity==0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cact),FALSE);

 if(flag_cont_check==1)
   gtk_widget_set_sensitive(GTK_WIDGET(Cact),FALSE);

 if(flag_dis_check==1)
   gtk_widget_set_sensitive(GTK_WIDGET(Cact),FALSE);

 Bmore=gtk_button_new_with_label("More..");
 gtk_box_pack_end(GTK_BOX(h1_box), Bmore, FALSE, TRUE, 5);
 
 Bback1=gtk_button_new_with_label("Back");
 gtk_box_pack_end(GTK_BOX(h1_box), Bback1, FALSE, TRUE, 5);
 
 adjustment3=GTK_ADJUSTMENT(gtk_adjustment_new(2.0, 2.0, 22.0,10.0, 1.0,1.0));
 Sstep=gtk_spin_button_new(adjustment3, 0.1, 1.0);

 gtk_box_pack_start(GTK_BOX(h1_box), Sstep, FALSE, TRUE, 5);
 gtk_container_add(GTK_CONTAINER(v6_box), h4_box);
 gtk_container_add(GTK_CONTAINER(v1_box), h2_box);
 gtk_container_add(GTK_CONTAINER(Vmain1_box), v6_box);
 gtk_container_add(GTK_CONTAINER(Vmain1_box), v1_box);
 gtk_container_add(GTK_CONTAINER(frame), Vmain1_box);
 gtk_container_add(GTK_CONTAINER(Vf_box), frame);
 gtk_container_add(GTK_CONTAINER(Vf2_box), frame2);
 gtk_container_add(GTK_CONTAINER(Vmain2_box), h3_box);
 gtk_container_add(GTK_CONTAINER(frame2), Vmain2_box);
 gtk_container_add(GTK_CONTAINER(Vmain_box), Vf_box);
 gtk_container_add(GTK_CONTAINER(Vmain_box), Vf2_box);
 gtk_container_add(GTK_CONTAINER(v5_box), h1_box);
 gtk_container_add(GTK_CONTAINER(Vmain_box), v5_box);
 gtk_container_add(GTK_CONTAINER(option_window), Vmain_box);

 /*----------------------------------Signal handlers-------------------------------*/
 gtk_signal_connect(GTK_OBJECT(Cset), "toggled", GTK_SIGNAL_FUNC(Cset_toggled), NULL);
 gtk_signal_connect(GTK_OBJECT(Cget), "toggled", GTK_SIGNAL_FUNC(Cget_toggled), NULL);
 gtk_signal_connect(GTK_OBJECT(Ccont), "toggled", GTK_SIGNAL_FUNC(Ccont_toggled), NULL); 
 gtk_signal_connect(GTK_OBJECT(Cdis), "toggled", GTK_SIGNAL_FUNC(Cdis_toggled), NULL);
 gtk_signal_connect(GTK_OBJECT(Cact), "toggled", GTK_SIGNAL_FUNC(Cact_toggled), NULL);
 gtk_signal_connect(GTK_OBJECT(Eset), "activate", GTK_SIGNAL_FUNC(entry_changed), NULL);
 gtk_signal_connect(GTK_OBJECT(Bmore), "clicked", GTK_SIGNAL_FUNC(option_window_2), NULL);
 gtk_signal_connect(GTK_OBJECT(Bback1), "clicked", GTK_SIGNAL_FUNC(go_back_1), NULL);
	 
 gtk_widget_show_all(option_window);
 
}

//Creates the third window containing the remaining properties of the progressbar
void option_window_2()
{
 option_window2=gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_container_set_border_width(GTK_CONTAINER(option_window2), 10); 


 h5_box=gtk_hbox_new(TRUE,5);
 h6_box=gtk_hbox_new(TRUE,5);
 h7_box=gtk_hbox_new(FALSE,5);
 h8_box=gtk_hbox_new(FALSE,5);
 VOmain_box=gtk_vbox_new(FALSE, 5);
 VOf1_box=gtk_vbox_new(FALSE,5);
 VOf2_box=gtk_vbox_new(FALSE,5);
 v21_box=gtk_vbox_new(FALSE, 5); 
 v22_box=gtk_vbox_new(TRUE,5);

 O_frame1=gtk_frame_new(" Bar Orientation");
 gtk_frame_set_shadow_type(GTK_FRAME(O_frame1), GTK_SHADOW_ETCHED_OUT);
 gtk_box_pack_start(GTK_BOX(VOf1_box), O_frame1, FALSE, FALSE,1);

 O_frame2=gtk_frame_new(" Text Align ");
  gtk_frame_set_shadow_type(GTK_FRAME(O_frame2), GTK_SHADOW_ETCHED_OUT);
 gtk_box_pack_start(GTK_BOX(VOf2_box), O_frame2, FALSE, TRUE,0);
 gtk_widget_set_sensitive(GTK_WIDGET(O_frame2),FALSE);
 option_menu=gtk_option_menu_new();
 menu=gtk_menu_new();
 menu_item=gtk_menu_item_new_with_label("Left to Right");
 gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

 menu_item=gtk_menu_item_new_with_label("Right to Left");
 gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

 menu_item=gtk_menu_item_new_with_label("Bottom to Top");
 gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

 menu_item=gtk_menu_item_new_with_label("Top to Bottom");
 gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);


 gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu),menu);
 gtk_widget_set_usize(option_menu, 50,40);

 if(orient_flag==1)
  {
    gtk_option_menu_set_history(GTK_OPTION_MENU(option_menu), orient_index);
    orient_flag=0;
  }

 Ctext=gtk_check_button_new_with_label(" Show text " );

 if(flag_text==1)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Ctext), TRUE);
 else if(flag_text==0)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Ctext), FALSE);

 gtk_box_pack_start(GTK_BOX(h8_box), Ctext, FALSE, TRUE, 0);

 Cformat=gtk_check_button_new_with_label(" Format String " );
 gtk_box_pack_start(GTK_BOX(h8_box), Cformat, FALSE, TRUE, 0);
 gtk_widget_set_sensitive(GTK_WIDGET(Cformat), FALSE);

 if(flag_format_true==1)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cformat), TRUE);
 else if(flag_format_true==0)
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cformat), FALSE);

 if(flag_format==1)
  gtk_widget_set_sensitive(GTK_WIDGET(Cformat), TRUE);
 else if(flag_format==0)
  gtk_widget_set_sensitive(GTK_WIDGET(Cformat), FALSE);
 
 adjustment=GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0,0.1, 1.0,1.0));
 adjustment2=GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0,0.1, 1.0,1.0));
 adjustment3=GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 1.0,0.1, 1.0,1.0));

 Lx=gtk_label_new("X :");
 gtk_box_pack_start(GTK_BOX(h6_box), Lx, FALSE, TRUE,0);
 gtk_widget_set_sensitive(GTK_WIDGET(Lx), FALSE);

 Sxalign=gtk_spin_button_new(adjustment, 0.1, 1.0);
 gtk_box_pack_start(GTK_BOX(h6_box), Sxalign, FALSE, TRUE, 0);
 gtk_widget_set_sensitive(GTK_WIDGET(Sxalign), FALSE);

 Ly=gtk_label_new("Y :");
 gtk_box_pack_start(GTK_BOX(h6_box), Ly, FALSE, TRUE,0);
 gtk_widget_set_sensitive(GTK_WIDGET(Ly), FALSE);

 Syalign=gtk_spin_button_new(adjustment2, 0.1, 1.0);
 gtk_box_pack_start(GTK_BOX(h6_box), Syalign, TRUE, TRUE, 0);
 gtk_widget_set_sensitive(GTK_WIDGET(Syalign), FALSE);

 Bset=gtk_button_new_with_label(" Set ");
 gtk_box_pack_start(GTK_BOX(h6_box), Bset, FALSE, TRUE, 0); 
 gtk_widget_set_sensitive(GTK_WIDGET(Bset), FALSE);

 if(flag_align_true==1)
  {
    gtk_widget_set_sensitive(GTK_WIDGET(Lx), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(Sxalign), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(Ly), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(Syalign), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(Bset), TRUE);
    gtk_widget_set_sensitive(GTK_WIDGET(O_frame2), TRUE);
 }
 else if(flag_align_true==0)
  {
    gtk_widget_set_sensitive(GTK_WIDGET(Lx), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Sxalign), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Ly), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Syalign), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Bset), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(O_frame2), FALSE);
 }
 

 Lper=gtk_label_new("%:");
 gtk_box_pack_start(GTK_BOX(h7_box), Lper, FALSE, TRUE, 0);

 Sper=gtk_spin_button_new(adjustment3, 0.1, 1.0); 
 gtk_box_pack_start(GTK_BOX(h7_box), Sper, FALSE, TRUE, 0);
 Bset_per=gtk_button_new_with_label("Set %  ");
 gtk_box_pack_start(GTK_BOX(h7_box), Bset_per, FALSE, TRUE, 0);

 Bback2=gtk_button_new_with_label(" Back ");
 gtk_box_pack_end(GTK_BOX(h7_box), Bback2, FALSE, TRUE, 0);

 gtk_box_pack_start(GTK_BOX(h5_box), option_menu, FALSE, TRUE, 0);
 gtk_container_add(GTK_CONTAINER(O_frame1),h5_box );
 gtk_container_add(GTK_CONTAINER(VOmain_box), VOf1_box);
 gtk_container_add(GTK_CONTAINER(O_frame2), h6_box);
 gtk_container_add(GTK_CONTAINER(v21_box), h8_box);
 gtk_container_add(GTK_CONTAINER(VOmain_box),v21_box );
 gtk_container_add(GTK_CONTAINER(VOmain_box),VOf2_box ); 
 gtk_container_add(GTK_CONTAINER(v22_box), h7_box);
 gtk_container_add(GTK_CONTAINER(VOmain_box), v22_box);
 gtk_container_add(GTK_CONTAINER(option_window2), VOmain_box);
 gtk_widget_show_all(option_window2);

 /*-------------------------------Signal Handlers---------------------------------*/
 gtk_signal_connect(GTK_OBJECT(option_menu), "changed", GTK_SIGNAL_FUNC(get_history), NULL);
 gtk_signal_connect(GTK_OBJECT(Ctext), "toggled", GTK_SIGNAL_FUNC(Ctext_toggled), NULL);
 gtk_signal_connect(GTK_OBJECT(Cformat), "toggled", GTK_SIGNAL_FUNC(Cformat_toggled), NULL);
 gtk_signal_connect(GTK_OBJECT(Bset), "clicked", GTK_SIGNAL_FUNC(set_text_align), NULL);
 gtk_signal_connect(GTK_OBJECT(Bback2), "clicked" , GTK_SIGNAL_FUNC(go_back_2), NULL);
 gtk_signal_connect(GTK_OBJECT(Bset_per), "clicked" , GTK_SIGNAL_FUNC(set_percentage), NULL);

}


                                                                                                                             




