/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Timer function 
gint timer_function(gpointer data)
{
        gfloat new_val;
        GtkAdjustment *adj;
        new_val = gtk_progress_get_value( GTK_PROGRESS(data) ) + 1;
        adj = GTK_PROGRESS (data)->adjustment;
        if (new_val > adj->upper)
              new_val = adj->lower;
        gtk_progress_set_value (GTK_PROGRESS (data), new_val);
        return(TRUE);
}

//Action on clicking 'Exit' button
void quit(GtkWidget *button, gpointer data)
{
 gtk_main_quit();
}

//Action on toggling 'Set Value' checkbox
void Cset_toggled(GtkToggleButton *b, gpointer data)
{
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cget), FALSE);
 gtk_entry_set_text(GTK_ENTRY(Eget), " "); 

 gint value;
 if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Cset))) 
 {
  gtk_widget_set_sensitive(GTK_WIDGET(Eset), TRUE); 
 }  
  else
  gtk_widget_set_sensitive(GTK_WIDGET(Eset), FALSE);

}

//Action on clicking 'Get Value' checkbox
void Cget_toggled(GtkToggleButton *b, gpointer data)
{
 if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Cget)))
  {
    get_value();
  }
 else
  gtk_entry_set_text(GTK_ENTRY(Eget), " ");
}

//Action on toggling 'Continuous' mode checkbox
void Ccont_toggled(GtkToggleButton *b, gpointer data)
{
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Ccont)))
      {
          if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Cget)))
            {
              gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cget), FALSE);
              gtk_entry_set_text(GTK_ENTRY(Eget)," ");
            }  	 
          if(flag_activity_check==1)
            {
              g_print("Inside if : flag_activity_check");
              gtk_progress_set_activity_mode(GTK_PROGRESS(progress_bar), FALSE);
              g_print("afetr mode=false"); 
              gtk_widget_set_sensitive(GTK_WIDGET(Cact),FALSE);
              a=1; 
            } 
        gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_CONTINUOUS);
        flag_cont_check=1; 
        flag_cont=1; 
        gtk_widget_set_sensitive(GTK_WIDGET(Cdis), FALSE);
        if(a==1)
         value=0;
        else
          value=gtk_progress_get_value(GTK_PROGRESS(progress_bar));
        percent=gtk_progress_get_percentage_from_value(GTK_PROGRESS(progress_bar), value+10);
        gtk_progress_bar_update(GTK_PROGRESS_BAR(progress_bar),percent);
      }
    else
      { 
        flag_cont_check=0;
        flag_cont=0;
        gtk_widget_set_sensitive(GTK_WIDGET(Cdis), TRUE);
        gtk_widget_set_sensitive(GTK_WIDGET(Cact), TRUE);
      } 
}

// Action on toggling 'Discrete' mode checkbox
void Cdis_toggled(GtkToggleButton *b, gpointer data)
{
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Cdis)))
     {

         if(flag_cont_check==1)
            gtk_widget_set_sensitive(GTK_WIDGET(Cdis), FALSE);
         else
            gtk_widget_set_sensitive(GTK_WIDGET(Ccont), FALSE);
        if(flag_activity_check==1)
          {
            gtk_widget_set_sensitive(GTK_WIDGET(Cact),FALSE);
          }
         else
           gtk_widget_set_sensitive(GTK_WIDGET(Cact),FALSE);

        flag_dis=1; 
        flag_dis_check=1;
	gtk_progress_configure(GTK_PROGRESS(progress_bar), 0.0, 0.0, 100.0 );
	timer=gtk_timeout_add (100, timer_function, progress_bar);
	        
        gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_DISCRETE);
      gtk_progress_bar_set_discrete_blocks(GTK_PROGRESS_BAR(progress_bar), 10);
     }
    else
     {
        flag_dis_check=0;
        flag_dis=0;
        gtk_widget_set_sensitive(GTK_WIDGET(Ccont), TRUE);
        gtk_widget_set_sensitive(GTK_WIDGET(Cact),TRUE);
     } 
  }

//Action on toggling 'Activity' mode checkbox
void Cact_toggled(GtkToggleButton *b, gpointer data)
{
 if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Cact)))
   {
      if(flag_cont==1)
        {
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Ccont), FALSE);
          flag_cont=0;
          gtk_widget_set_sensitive(GTK_WIDGET(Ccont),FALSE);
        }
      else
        {
          gtk_widget_set_sensitive(GTK_WIDGET(Ccont),FALSE);
        }
   
      if(flag_dis==1)
        {
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Cdis), FALSE);
          flag_dis=0;
          gtk_widget_set_sensitive(GTK_WIDGET(Cdis),FALSE);
        }   
      else
        {
          gtk_widget_set_sensitive(GTK_WIDGET(Cdis),FALSE);
        }
       
      gint i;
      flag_activity=1;
      flag_activity_check=1; 
      i= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(Sstep));
      gtk_progress_bar_set_activity_blocks(GTK_PROGRESS_BAR(progress_bar),i);
 
      gtk_progress_bar_pulse (GTK_PROGRESS_BAR(progress_bar));
      gtk_progress_bar_set_pulse_step(GTK_PROGRESS_BAR(progress_bar), 0.2); 
 

 }
 else
  { 
   gtk_widget_set_sensitive(GTK_WIDGET(Ccont),TRUE);
   gtk_widget_set_sensitive(GTK_WIDGET(Cdis),TRUE);
   flag_activity=0;
   flag_activity_check=0;
   gtk_progress_set_activity_mode(GTK_PROGRESS(progress_bar), FALSE);
  }
}

//Action on entering the value to be set to the progressbar in the entrybox
void entry_changed(GtkWidget *b, gpointer data)
{
  gchar* value;
 value= gtk_entry_get_text(GTK_ENTRY(Eset));
 set_value(value);
}

//Function to set the value entered in the entrybox
void set_value(gchar * value)
{
 gint i;
 i=atoi(value); 
 gdouble d=i;
 gtk_progress_set_value(GTK_PROGRESS(progress_bar),d );
 gtk_widget_hide(option_window);
}

//Function to get the value set to the progressbar
void get_value()
{
 val=gtk_progress_get_value(GTK_PROGRESS(progress_bar));
 int_val=(int)val; 
 sprintf(text[0], "%i", int_val);
 gtk_entry_set_text(GTK_ENTRY(Eget), text[0]);
}

//Action on selecting bar orientation
void get_history(GtkOptionMenu *o, gpointer data)
{
  gint i;
  i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
  orient_index=i; 
  orient_flag=1;
  if(flag_text==1)
   gtk_progress_set_show_text(GTK_PROGRESS(progress_bar), TRUE);
  if(flag_format_true==1)
   gtk_progress_set_format_string (GTK_PROGRESS(progress_bar), "%v from [%l-%u] (=%p%%)");
  if(i==0)
   gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_LEFT_TO_RIGHT);
  if(i==1)
   gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_RIGHT_TO_LEFT);
  if(i==2)
   gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_BOTTOM_TO_TOP);
  if(i==3)
   gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_TOP_TO_BOTTOM);

}

//Action on toggling 'Show Text' checkbox
void Ctext_toggled(GtkToggleButton *b, gpointer data)
{
 if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Ctext)))
  {
  flag_text=1;
  flag_align_true=1;
  flag_format=1;
  gtk_progress_set_show_text(GTK_PROGRESS(progress_bar), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(Lx), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(Sxalign), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(Ly), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(Syalign), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(Bset), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(O_frame2), TRUE);
  gtk_widget_set_sensitive(GTK_WIDGET(Cformat), TRUE);
  }
 else
  {
   flag_text=0;
   flag_align_true=0;
   flag_format=0;
   gtk_progress_set_show_text(GTK_PROGRESS(progress_bar), FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(Lx), FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(Sxalign),FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(Ly), FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(Syalign), FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(Bset), FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(O_frame2), FALSE);
   gtk_widget_set_sensitive(GTK_WIDGET(Cformat), FALSE);


  }
}

//Action on clicking 'Set' button to set the text alignment on the progressbar
void set_text_align(GtkWidget *button, gpointer data)
{
  gfloat x;
  gfloat y;
  gdouble x1;
  gdouble y1;
  x=gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(Sxalign));
  y=gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(Syalign));
  x1=(gdouble)x;
  y1=(gdouble)y;

  gtk_progress_set_text_alignment(GTK_PROGRESS(progress_bar),x1,y1);
}

//Action on clicking 'Back' button in the third window
void go_back_2(GtkWidget *button, gpointer data)
{
 gtk_widget_hide(option_window2);
 gtk_widget_show(option_window);
}

//Action on clicking 'back' button in the second window
void go_back_1(GtkWidget *button, gpointer data)
{
  gtk_widget_hide(option_window);
  gtk_widget_show(window);
}

//Action on toggling the 'Format' checkbox
void Cformat_toggled(GtkToggleButton *b, gpointer data)
{
 if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(Cformat)))
  {
   flag_format_true=1; 
   gtk_progress_set_format_string (GTK_PROGRESS(progress_bar), "%v from [%l-%u] (=%p%%)");
  }
  else
  {
    flag_format_true=0;
    gtk_progress_set_format_string (GTK_PROGRESS(progress_bar), "%p%%");
  }

}

//Action on clicking 'Set %' button
void set_percentage(GtkWidget *button, gpointer data)
{
  percentage=gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(Sper));
  gdouble p;
  p=(gdouble)percentage;
  gtk_progress_set_percentage(GTK_PROGRESS(progress_bar), p);
}


