/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

int main(int argc,char *argv[])
{

	gtk_init(&argc,&argv);

	/* Create Main Window */
	
	main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(main_window),10);
	gtk_window_set_title(GTK_WINDOW(main_window),"Notebook App");
	g_signal_connect(G_OBJECT(main_window),"destroy",gtk_main_quit,NULL);

	main_box=gtk_vbox_new(FALSE,2);
	gtk_container_add(GTK_CONTAINER(main_window),main_box);

	/* Pack a frame */
	
	main_frame=gtk_frame_new("NoteBook");
	gtk_box_pack_start(GTK_BOX(main_box),main_frame,FALSE,FALSE,0);
	main_box1=gtk_hbox_new(FALSE,2);
	gtk_container_set_border_width(GTK_CONTAINER(main_box1),5);
	gtk_container_add(GTK_CONTAINER(main_frame),main_box1);

	/* pack the buttons */
	
	simple_button=gtk_button_new_with_label("Simple");
	gtk_box_pack_start(GTK_BOX(main_box1),simple_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(simple_button),"clicked",G_CALLBACK(create_simple_notebook),NULL);

	blank_button=gtk_button_new_with_label("Blank");
	gtk_box_pack_start(GTK_BOX(main_box1),blank_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(blank_button),"clicked",G_CALLBACK(create_blank_notebook),NULL);

	menu_button=gtk_button_new_from_stock("Menu");
	gtk_box_pack_start(GTK_BOX(main_box1),menu_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(menu_button),"clicked",G_CALLBACK(create_menu_notebook),NULL);

	quit_button=gtk_button_new_from_stock(GTK_STOCK_QUIT);
	gtk_box_pack_end(GTK_BOX(main_box),quit_button,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(quit_button),"clicked",gtk_main_quit,NULL);

	gtk_widget_show_all(main_window);

	gtk_main();

	return 0;

}


