/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"


GdkPixbuf *book_open;
GdkPixbuf *book_closed;
gint simple_index;

static char * book_open_xpm[] = {
"16 16 4 1",
"       c None s None",
".      c black",
"X      c #808080",
"o      c white",
"                ",
"  ..            ",
" .Xo.    ...    ",
" .Xoo. ..oo.    ",
" .Xooo.Xooo...  ",
" .Xooo.oooo.X.  ",
" .Xooo.Xooo.X.  ",
" .Xooo.oooo.X.  ",
" .Xooo.Xooo.X.  ",
" .Xooo.oooo.X.  ",
"  .Xoo.Xoo..X.  ",
"   .Xo.o..ooX.  ",
"    .X..XXXXX.  ",
"    ..X.......  ",
"     ..         ",
"                "};




static char * book_closed_xpm[] = {
"16 16 6 1",
"       c None s None",
".      c black",
"X      c red",
"o      c yellow",
"O      c #808080",
"#      c white",
"                ",
"       ..       ",
"     ..XX.      ",
"   ..XXXXX.     ",
" ..XXXXXXXX.    ",
".ooXXXXXXXXX.   ",
"..ooXXXXXXXXX.  ",
".X.ooXXXXXXXXX. ",
".XX.ooXXXXXX..  ",
" .XX.ooXXX..#O  ",
"  .XX.oo..##OO. ",
"   .XX..##OO..  ",
"    .X.#OO..    ",
"     ..O..      ",
"      ..        ",
"                "};


void set_page_image(GtkNotebook *notebook,gint page_num,GdkPixbuf *pixbuf)
{
  GtkWidget *page_widget;
  GtkWidget *pixwid;

  page_widget = gtk_notebook_get_nth_page (notebook, page_num);

  /* create images for each page */
  
  pixwid = g_object_get_data (G_OBJECT (page_widget), "tab_pixmap");
  gtk_image_set_from_pixbuf (GTK_IMAGE (pixwid), pixbuf);

  if(simple_index==1)
  {
	  pixwid = g_object_get_data (G_OBJECT (page_widget), "menu_pixmap");
	  gtk_image_set_from_pixbuf (GTK_IMAGE (pixwid), pixbuf);

  }
	

}

void page_switch(GtkWidget *widget,GtkNotebookPage *page,gint page_num)
{
  /* change the image of the page for every close or open operation */
	
  GtkNotebook *notebook = GTK_NOTEBOOK (widget);
  gint old_page_num = gtk_notebook_get_current_page (notebook);

  if (page_num == old_page_num)
    return;

  set_page_image (notebook, page_num, book_open);

  if (old_page_num != -1)
    set_page_image (notebook, old_page_num, book_closed);
}



void create_simple_notebook(void)
{

	GtkWidget *simple_next_button;
	GtkWidget *simple_prev_button;
	GtkWidget *simple_rem_button;
	GtkWidget *simple_reorder_button;
	GtkWidget *simple_home_button;
	GtkWidget *hbox,*vbox;
	GtkWidget *button;
	simple_index=0;

	simple_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(simple_window),10);
	gtk_window_set_title(GTK_WINDOW(simple_window),"Simple Notebook");
	g_signal_connect(G_OBJECT(simple_window),"destroy",G_CALLBACK(simple_window_call),NULL);

	simple_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(simple_window),simple_vbox);

	/* create a notebook for testing common operations */
	
	simple_notebook=gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(simple_notebook),GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(simple_vbox),simple_notebook,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(simple_notebook),"switch-page",G_CALLBACK(page_switch),NULL);
	gtk_widget_show(simple_notebook);

	if (!book_open)
	        book_open = gdk_pixbuf_new_from_xpm_data ((const char **)book_open_xpm);

	if (!book_closed)
    		 book_closed = gdk_pixbuf_new_from_xpm_data ((const char **)book_closed_xpm);

	for(i=1;i<=5;i++)
	{

		/* create pages for the notebook */
		
		sprintf(buffer,"Page %d",i);
		sprintf(simple_buffer,"Page _%d",i);

		simple_frame=gtk_frame_new(buffer);
		gtk_container_set_border_width(GTK_CONTAINER(simple_frame),10);
		gtk_widget_show(simple_frame);

		vbox=gtk_vbox_new(TRUE,0);
	        gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	        gtk_container_add(GTK_CONTAINER(simple_frame),vbox);

	        hbox=gtk_hbox_new(TRUE,0);
	        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,5);

		/* define the contents of each page */
		
	        button=gtk_check_button_new_with_label("Fill Tab");
	        gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,5);
	        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
	        g_signal_connect(button,"toggled",G_CALLBACK(tab_fill),simple_frame);

	        button=gtk_check_button_new_with_label("Expand Tab");
	        gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,5);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
	        g_signal_connect(button,"toggled",G_CALLBACK(tab_expand),simple_frame);

		gtk_widget_show_all(simple_frame);

		/* add the image */
		
		simple_label_box=gtk_hbox_new(FALSE,0);
		pixwid=gtk_image_new_from_pixbuf(book_closed);
		g_object_set_data(G_OBJECT(simple_frame),"tab_pixmap",pixwid);
		gtk_box_pack_start(GTK_BOX(simple_label_box),pixwid,FALSE,TRUE,0);
		gtk_misc_set_padding(GTK_MISC(pixwid),3,1);
		simple_label=gtk_label_new_with_mnemonic(simple_buffer);
		gtk_box_pack_start(GTK_BOX(simple_label_box),simple_label,FALSE,TRUE,0);
		gtk_widget_show_all(simple_label_box);
		
		gtk_notebook_append_page(GTK_NOTEBOOK(simple_notebook),simple_frame,simple_label_box);
	}

	simple_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(simple_vbox),simple_hbox,FALSE,FALSE,0);

	/* create control buttons */
	
        simple_prev_button=gtk_button_new_with_label("Prev");
        gtk_box_pack_start(GTK_BOX(simple_hbox),simple_prev_button,TRUE,TRUE,5);
        g_signal_connect(G_OBJECT(simple_prev_button),"clicked",G_CALLBACK(prev_button_call),NULL);
        gtk_widget_show(simple_prev_button);

	simple_next_button=gtk_button_new_with_label("Next");
	gtk_box_pack_start(GTK_BOX(simple_hbox),simple_next_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(simple_next_button),"clicked",G_CALLBACK(next_button_call),NULL);
	gtk_widget_show(simple_next_button);

	simple_rem_button=gtk_button_new_with_label("Remove");
	gtk_box_pack_start(GTK_BOX(simple_hbox),simple_rem_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(simple_rem_button),"clicked",G_CALLBACK(rem_button_call),NULL);
	gtk_widget_show(simple_rem_button);

	simple_reorder_button=gtk_button_new_with_label("Reorder");
	gtk_box_pack_start(GTK_BOX(simple_hbox),simple_reorder_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(simple_reorder_button),"clicked",G_CALLBACK(reorder_button_call),NULL);	
	gtk_widget_show(simple_reorder_button);

	simple_home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_start(GTK_BOX(simple_hbox),simple_home_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(simple_home_button),"clicked",G_CALLBACK(simple_window_call),NULL);
	gtk_widget_show(simple_home_button);

	gtk_widget_show(simple_hbox);    
	gtk_widget_show(hbox);
	gtk_widget_show(simple_vbox);
	gtk_widget_show(simple_window);

}


void tab_fill (GtkToggleButton *button, GtkWidget *child)
{
  gboolean expand;
  GtkPackType pack_type;

  /* fill/unfill the notebook tabs */
  
  gtk_notebook_query_tab_label_packing (GTK_NOTEBOOK (simple_notebook), child,
                                        &expand, NULL, &pack_type);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (simple_notebook), child,
                                      expand, button->active, pack_type);
}


void tab_expand (GtkToggleButton *button, GtkWidget *child)
{
  gboolean fill;
  GtkPackType pack_type;

  /* expand the tab to fit the row */
  
  gtk_notebook_query_tab_label_packing (GTK_NOTEBOOK (simple_notebook), child,
                                        NULL, &fill, &pack_type);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (simple_notebook), child,
                                      button->active, fill, pack_type);
}


void create_blank_notebook(void)
{


        blank_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(blank_window),10);
        gtk_window_set_title(GTK_WINDOW(blank_window),"Blank Notebook");
	g_signal_connect(G_OBJECT(blank_window),"destroy",G_CALLBACK(blank_window_call),NULL);

        blank_vbox=gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(blank_window),blank_vbox);

	/* create a notebook for testing their properties */
	
        blank_notebook=gtk_notebook_new();
        gtk_notebook_set_tab_pos(GTK_NOTEBOOK(blank_notebook),GTK_POS_TOP);
        gtk_box_pack_start(GTK_BOX(blank_vbox),blank_notebook,FALSE,FALSE,0);

        for(i=1;i<=3;i++)
        {

		/* add pages */
		
                sprintf(buffer,"Page%d",i);
                sprintf(simple_buffer,"Page_%d",i);

                blank_frame=gtk_frame_new(buffer);
                gtk_container_set_border_width(GTK_CONTAINER(blank_frame),10);
                gtk_widget_show(blank_frame);

                blank_frame_label=gtk_label_new(buffer);
                gtk_container_add(GTK_CONTAINER(blank_frame),blank_frame_label);
                gtk_widget_show(blank_frame_label);

                blank_label=gtk_label_new_with_mnemonic(simple_buffer);
		gtk_widget_show(blank_label);

                gtk_notebook_append_page(GTK_NOTEBOOK(blank_notebook),blank_frame,blank_label);
        }

	/* insert a page */
	
        blank_frame=gtk_frame_new("Ins Page");
        gtk_container_set_border_width(GTK_CONTAINER(blank_frame),10);
        gtk_widget_show(blank_frame);

        blank_check_button = gtk_check_button_new_with_label ("Inserted Page");
        gtk_widget_set_size_request(blank_check_button,100,75);
        gtk_container_add(GTK_CONTAINER(blank_frame),blank_check_button);
        gtk_widget_show(blank_check_button);

        blank_label=gtk_label_new_with_mnemonic("_Ins Page");
	gtk_widget_show(blank_label);

        gtk_notebook_insert_page(GTK_NOTEBOOK(blank_notebook),blank_frame,blank_label,2);

	/* prepend a page */
	
        blank_frame=gtk_frame_new("Pre Page");
        gtk_container_set_border_width(GTK_CONTAINER(blank_frame),10);
        gtk_widget_show(blank_frame);

        blank_frame_label=gtk_label_new("Prepended Page");
        gtk_container_add(GTK_CONTAINER(blank_frame),blank_frame_label);
        gtk_widget_show(blank_frame_label);

        blank_label=gtk_label_new_with_mnemonic("_Pre Page");
	gtk_widget_show(blank_label);

        gtk_notebook_prepend_page(GTK_NOTEBOOK(blank_notebook),blank_frame,blank_label);

	/* define control buttons */
	
	blank_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(blank_vbox),blank_hbox,FALSE,FALSE,0);

	blank_prop_button=gtk_button_new_from_stock(GTK_STOCK_PROPERTIES);
	gtk_box_pack_start(GTK_BOX(blank_hbox),blank_prop_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(blank_prop_button),"clicked",G_CALLBACK(blank_prop_call),NULL);
	gtk_widget_show(blank_prop_button);

	blank_home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_start(GTK_BOX(blank_hbox),blank_home_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(blank_home_button),"clicked",G_CALLBACK(blank_window_call),NULL);
	gtk_widget_show(blank_home_button);

	gtk_widget_show(blank_hbox);        
	gtk_widget_show(blank_vbox);
	gtk_widget_show(blank_notebook);
        gtk_widget_show(blank_window);
	

}

void create_menu_notebook(void)
{

	simple_index=1;
        
	menu_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(menu_window),10);
        gtk_window_set_title(GTK_WINDOW(menu_window),"Menu Notebook");
        g_signal_connect(G_OBJECT(menu_window),"destroy",G_CALLBACK(menu_window_call),NULL);

        menu_vbox=gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(menu_window),menu_vbox);

	/* create a notebook for testing the menu properties */
	
        menu_notebook=gtk_notebook_new();
        gtk_notebook_set_tab_pos(GTK_NOTEBOOK(menu_notebook),GTK_POS_TOP);
        gtk_box_pack_start(GTK_BOX(menu_vbox),menu_notebook,FALSE,FALSE,0);
        gtk_widget_show(menu_notebook);

        for(i=1;i<=3;i++)
        {

		/* add pages */
		
                sprintf(buffer,"Page %d",i);
                sprintf(simple_buffer,"Page _%d",i);

                menu_frame=gtk_frame_new(buffer);
                gtk_container_set_border_width(GTK_CONTAINER(menu_frame),10);
                gtk_widget_show(menu_frame);

                menu_frame_label=gtk_label_new(buffer);
                gtk_container_add(GTK_CONTAINER(menu_frame),menu_frame_label);
                gtk_widget_show(menu_frame_label);

                menu_label=gtk_label_new_with_mnemonic(simple_buffer);
		gtk_widget_show(menu_label);

	        label=gtk_label_new(buffer);
		gtk_widget_show(label);

		gtk_notebook_append_page_menu(GTK_NOTEBOOK(menu_notebook),menu_frame,menu_label,label);
        }

	/* insert a page */
	
        menu_frame=gtk_frame_new("Ins Page");
        gtk_container_set_border_width(GTK_CONTAINER(menu_frame),10);
        gtk_widget_show(menu_frame);

        menu_check_button=gtk_check_button_new_with_label("Inserted Page");
        gtk_widget_set_size_request(menu_check_button,100,75);
        gtk_container_add(GTK_CONTAINER(menu_frame),menu_check_button);
        gtk_widget_show(menu_check_button);

        menu_label=gtk_label_new_with_mnemonic("I_nserted Page for a check from the developer of the test application");
	gtk_widget_show(menu_label);

        label=gtk_label_new("Ins Page");
	gtk_widget_show(label);

        gtk_notebook_insert_page_menu(GTK_NOTEBOOK(menu_notebook),menu_frame,menu_label,label,2);

	/* prepend a page */
	
        menu_frame=gtk_frame_new("Pre Page");
        gtk_container_set_border_width(GTK_CONTAINER(menu_frame),10);
        gtk_widget_show(menu_frame);

        menu_frame_label=gtk_label_new("Prepended Page");
        gtk_container_add(GTK_CONTAINER(menu_frame),menu_frame_label);
        gtk_widget_show(menu_frame_label);

        menu_label=gtk_label_new_with_mnemonic("_Pre Page");
	gtk_widget_show(menu_label);

        label=gtk_label_new("Pre Page");
	gtk_widget_show(label);

        gtk_notebook_prepend_page_menu(GTK_NOTEBOOK(menu_notebook),menu_frame,menu_label,label);

	/* define control buttons */

	menu_pop_check=gtk_check_button_new_with_label("Popup Menu");
	gtk_box_pack_start(GTK_BOX(menu_vbox),menu_pop_check,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(menu_pop_check),"toggled",G_CALLBACK(pop_check_call),NULL);
	gtk_widget_show(menu_pop_check);

	menu_hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(menu_vbox),menu_hbox1,FALSE,FALSE,0);
	
	menu_prop_button=gtk_button_new_from_stock(GTK_STOCK_PROPERTIES);
	gtk_box_pack_start(GTK_BOX(menu_hbox1),menu_prop_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(menu_prop_button),"clicked",G_CALLBACK(menu_prop_call),NULL);
	gtk_widget_show(menu_prop_button);

	menu_home_button=gtk_button_new_from_stock(GTK_STOCK_HOME);
	gtk_box_pack_end(GTK_BOX(menu_hbox1),menu_home_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(menu_home_button),"clicked",G_CALLBACK(menu_window_call),NULL);
	gtk_widget_show(menu_home_button);

	gtk_widget_show(menu_hbox1);
	gtk_widget_show(menu_vbox);
	gtk_widget_show(menu_window);

}
			

	
	

