/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "interface.h"
#include "callbacks.h"

static int n=2;

void simple_window_call(void)
{

	gtk_widget_hide(simple_window);
	gtk_widget_show(main_window);

}

void next_button_call(void)
{

	gtk_notebook_next_page(GTK_NOTEBOOK(simple_notebook));

}

void prev_button_call(void)
{

	gtk_notebook_prev_page(GTK_NOTEBOOK(simple_notebook));

}
	
void rem_button_call(void)
{

	gint page;

	page=gtk_notebook_get_current_page(GTK_NOTEBOOK(simple_notebook));
	gtk_notebook_remove_page(GTK_NOTEBOOK(simple_notebook),page);

	gtk_widget_queue_draw(GTK_WIDGET(simple_notebook));

}

void reorder_button_call(void)
{

	GtkWidget *page;
	gint page_num;

	/* reorder(rotate) pages */
	
	page_num=gtk_notebook_get_current_page(GTK_NOTEBOOK(simple_notebook));
	page=gtk_notebook_get_nth_page(GTK_NOTEBOOK(simple_notebook),page_num);
	gtk_notebook_reorder_child(GTK_NOTEBOOK(simple_notebook),GTK_WIDGET(page),-1);
	gtk_notebook_set_current_page(GTK_NOTEBOOK(simple_notebook),0);

}

void menu_window_call(void)
{
        gtk_widget_hide(menu_window);
        gtk_widget_show(main_window);

}

void menu_prop_call(void)
{

	menu_prop_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(menu_prop_window),10);
	gtk_window_set_title(GTK_WINDOW(menu_prop_window),"Menu Properties");
	g_signal_connect(G_OBJECT(menu_prop_window),"destroy",G_CALLBACK(mprop_window_call),NULL);

	menu_prop_vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(menu_prop_window),menu_prop_vbox);

	menu_prop_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(menu_prop_vbox),menu_prop_hbox,FALSE,FALSE,0);

	menu_prop_label=gtk_label_new("Menu Style :");
	gtk_box_pack_start(GTK_BOX(menu_prop_hbox),menu_prop_label,TRUE,TRUE,5);
	gtk_widget_show(menu_prop_label);

	menu_prop_combo=gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(menu_prop_combo),"Label");
	gtk_combo_box_append_text(GTK_COMBO_BOX(menu_prop_combo),"Text");
	gtk_combo_box_set_active(GTK_COMBO_BOX(menu_prop_combo),0);
	gtk_box_pack_end(GTK_BOX(menu_prop_hbox),menu_prop_combo,TRUE,TRUE,5);
	gtk_widget_show(menu_prop_combo);

	menu_prop_frame=gtk_frame_new("Get Results");
	gtk_container_set_border_width(GTK_CONTAINER(menu_prop_frame),10);
	gtk_box_pack_start(GTK_BOX(menu_prop_vbox),menu_prop_frame,FALSE,FALSE,0);

	menu_tmp_label=gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(menu_prop_frame),menu_tmp_label);
	gtk_widget_show(menu_tmp_label);

	menu_prop_hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(menu_prop_vbox),menu_prop_hbox1,FALSE,FALSE,0);

	menu_prop_back=gtk_button_new_from_stock(GTK_STOCK_GO_BACK);
	gtk_box_pack_start(GTK_BOX(menu_prop_hbox1),menu_prop_back,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(menu_prop_back),"clicked",G_CALLBACK(mprop_window_call),NULL);
	gtk_widget_show(menu_prop_back);

	menu_set_button=gtk_button_new_with_label("Set");
	gtk_box_pack_start(GTK_BOX(menu_prop_hbox1),menu_set_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(menu_set_button),"clicked",G_CALLBACK(set_prop_call),NULL);
	gtk_widget_show(menu_set_button);

	menu_get_button=gtk_button_new_with_label("Get");
	gtk_box_pack_start(GTK_BOX(menu_prop_hbox1),menu_get_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(menu_get_button),"clicked",G_CALLBACK(get_prop_call),NULL);
	gtk_widget_show(menu_get_button);

	gtk_widget_show(menu_prop_hbox1);
	gtk_widget_show(menu_prop_hbox);
	gtk_widget_show(menu_prop_frame);
	gtk_widget_show(menu_prop_vbox);
	gtk_widget_show(menu_prop_window);

}

void mprop_window_call(void)
{

	gtk_widget_destroy(menu_prop_window);
	gtk_widget_show(menu_window);

}

void pop_check_call(void)
{

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(menu_pop_check)))
	{
		gtk_notebook_popup_enable(GTK_NOTEBOOK(menu_notebook));
	}
	else
	{
		gtk_notebook_popup_disable(GTK_NOTEBOOK(menu_notebook));
	}
}

void set_prop_call(void)
{

	gint sel,page_num;
	const gchar *str="Sample";
	GtkWidget *page;
	GtkWidget *simple_butn;

	gtk_widget_hide(menu_prop_window);

	page_num=gtk_notebook_get_current_page(GTK_NOTEBOOK(menu_notebook));
	page=gtk_notebook_get_nth_page(GTK_NOTEBOOK(menu_notebook),page_num);
	sel=gtk_combo_box_get_active(GTK_COMBO_BOX(menu_prop_combo));
	switch(sel)
	{
		case 0:
			simple_butn=gtk_button_new_with_label("Check Me");
			gtk_notebook_set_menu_label(GTK_NOTEBOOK(menu_notebook),GTK_WIDGET(page),GTK_WIDGET(simple_butn));
			break;

		case 1:
			gtk_notebook_set_menu_label_text(GTK_NOTEBOOK(menu_notebook),GTK_WIDGET(page),str);
			break;
	}
	gtk_widget_show(menu_window);

}


void get_prop_call(void)
{

        gint sel,page_num;
        GtkWidget *page;
        GtkWidget *wid;

	gtk_widget_hide(menu_prop_window);
        page_num=gtk_notebook_get_current_page(GTK_NOTEBOOK(menu_notebook));
        page=gtk_notebook_get_nth_page(GTK_NOTEBOOK(menu_notebook),page_num);
        sel=gtk_combo_box_get_active(GTK_COMBO_BOX(menu_prop_combo));
        switch(sel)
        {
                case 0:
			wid=gtk_notebook_get_menu_label(GTK_NOTEBOOK(menu_notebook),page);
			if(GTK_IS_LABEL(wid))
				gtk_label_set_text(GTK_LABEL(menu_tmp_label),"Label");
			else if(GTK_IS_BUTTON(wid))
				gtk_label_set_text(GTK_LABEL(menu_tmp_label),"Button");
			break;
		
		case 1:
                        gtk_label_set_text(GTK_LABEL(menu_tmp_label),gtk_notebook_get_menu_label_text(GTK_NOTEBOOK(menu_notebook),page));
			break;
	}
	gtk_widget_show(menu_tmp_label);
	gtk_widget_show(menu_prop_frame);
	gtk_widget_show(menu_prop_vbox);
	gtk_widget_show(menu_prop_window);

}
			
	
void blank_prop_call(void)
{

        blank_prop_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(blank_prop_window),10);
        gtk_window_set_title(GTK_WINDOW(blank_prop_window),"Blank Properties");
        g_signal_connect(G_OBJECT(blank_prop_window),"destroy",G_CALLBACK(bprop_window_call),NULL);

        blank_prop_vbox=gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(blank_prop_window),blank_prop_vbox);

        blank_prop_hbox=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(blank_prop_vbox),blank_prop_hbox,FALSE,FALSE,0);

        blank_prop_label=gtk_label_new("Menu Style :");
        gtk_box_pack_start(GTK_BOX(blank_prop_hbox),blank_prop_label,TRUE,TRUE,5);
        gtk_widget_show(blank_prop_label);

        blank_prop_combo=gtk_combo_box_new_text();
        gtk_combo_box_append_text(GTK_COMBO_BOX(blank_prop_combo),"Tab Position");
        gtk_combo_box_append_text(GTK_COMBO_BOX(blank_prop_combo),"Tabs");
        gtk_combo_box_append_text(GTK_COMBO_BOX(blank_prop_combo),"Border");
        gtk_combo_box_append_text(GTK_COMBO_BOX(blank_prop_combo),"Scrollable");
        gtk_combo_box_append_text(GTK_COMBO_BOX(blank_prop_combo),"Tab Label");
        gtk_combo_box_append_text(GTK_COMBO_BOX(blank_prop_combo),"Tab Text");
        gtk_combo_box_set_active(GTK_COMBO_BOX(blank_prop_combo),0);
        gtk_box_pack_end(GTK_BOX(blank_prop_hbox),blank_prop_combo,TRUE,TRUE,5);
        gtk_widget_show(blank_prop_combo);

        blank_prop_frame=gtk_frame_new("Get Results");
        gtk_container_set_border_width(GTK_CONTAINER(blank_prop_frame),10);
        gtk_box_pack_start(GTK_BOX(blank_prop_vbox),blank_prop_frame,FALSE,FALSE,0);

        blank_tmp_label=gtk_label_new("");
        gtk_container_add(GTK_CONTAINER(blank_prop_frame),blank_tmp_label);
	gtk_widget_show(blank_tmp_label);

	blank_prop_vbox1=gtk_vbox_new(FALSE,50);
	gtk_box_pack_end(GTK_BOX(blank_prop_vbox),blank_prop_vbox1,FALSE,FALSE,0);

	blank_page_hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(blank_prop_vbox1),blank_page_hbox,FALSE,FALSE,0);

	blank_page_button=gtk_button_new_with_label("Get Page No");
	gtk_box_pack_start(GTK_BOX(blank_page_hbox),blank_page_button,TRUE,TRUE,5);
	g_signal_connect(G_OBJECT(blank_page_button),"clicked",G_CALLBACK(blank_page_call),NULL);
	gtk_widget_show(blank_page_button);

	blank_page_label=gtk_label_new("");
	gtk_box_pack_end(GTK_BOX(blank_page_hbox),blank_page_label,TRUE,TRUE,5);
	gtk_widget_show(blank_page_label);
	
        blank_prop_hbox1=gtk_hbox_new(FALSE,0);
        gtk_box_pack_end(GTK_BOX(blank_prop_vbox1),blank_prop_hbox1,FALSE,FALSE,0);

        blank_prop_back=gtk_button_new_from_stock(GTK_STOCK_GO_BACK);
        gtk_box_pack_start(GTK_BOX(blank_prop_hbox1),blank_prop_back,TRUE,TRUE,5);
        g_signal_connect(G_OBJECT(blank_prop_back),"clicked",G_CALLBACK(bprop_window_call),NULL);
        gtk_widget_show(blank_prop_back);

        blank_set_button=gtk_button_new_with_label("Set");
        gtk_box_pack_start(GTK_BOX(blank_prop_hbox1),blank_set_button,TRUE,TRUE,5);
        g_signal_connect(G_OBJECT(blank_set_button),"clicked",G_CALLBACK(bset_prop_call),NULL);
        gtk_widget_show(blank_set_button);

        blank_get_button=gtk_button_new_with_label("Get");
        gtk_box_pack_start(GTK_BOX(blank_prop_hbox1),blank_get_button,TRUE,TRUE,5);
        g_signal_connect(G_OBJECT(blank_get_button),"clicked",G_CALLBACK(bget_prop_call),NULL);
        gtk_widget_show(blank_get_button);

        gtk_widget_show(blank_prop_hbox1);
        gtk_widget_show(blank_prop_hbox);
	gtk_widget_show(blank_page_hbox);
        gtk_widget_show(blank_prop_frame);
	gtk_widget_show(blank_prop_vbox1);
        gtk_widget_show(blank_prop_vbox);
        gtk_widget_show(blank_prop_window);

}

void blank_window_call(void)
{

	gtk_widget_hide(blank_window);
	gtk_widget_show(main_window);

}

void bprop_window_call(void)
{

	gtk_widget_destroy(blank_prop_window);
	gtk_widget_show(blank_window);

}

void bset_prop_call(void)
{

        gint sel,page_num,no_pages;
        GtkWidget *page,*tmp_butn;

        gtk_widget_hide(blank_prop_window);

        page_num=gtk_notebook_get_current_page(GTK_NOTEBOOK(blank_notebook));
        page=gtk_notebook_get_nth_page(GTK_NOTEBOOK(blank_notebook),page_num);
	no_pages=gtk_notebook_get_n_pages(GTK_NOTEBOOK(blank_notebook));
        sel=gtk_combo_box_get_active(GTK_COMBO_BOX(blank_prop_combo));
        switch(sel)
        {
                case 0:
                        rotate_notebook();
			break;

                case 1:
			gtk_notebook_set_show_tabs(GTK_NOTEBOOK(blank_notebook),(n++%2));
                        break;

		case 2:
			gtk_notebook_set_show_tabs(GTK_NOTEBOOK(blank_notebook),FALSE);
			gtk_notebook_set_show_border(GTK_NOTEBOOK(blank_notebook),FALSE);
			break;
		case 3:
                        gtk_notebook_set_show_tabs(GTK_NOTEBOOK(blank_notebook),TRUE);
                        gtk_notebook_set_show_border(GTK_NOTEBOOK(blank_notebook),TRUE);
                        gtk_notebook_set_scrollable(GTK_NOTEBOOK(blank_notebook),TRUE);
                        if(no_pages==5)
                                create_pages();
                        return;
                        break;
		case 4:
			gtk_notebook_set_show_tabs(GTK_NOTEBOOK(blank_notebook),TRUE);
			tmp_butn=gtk_button_new_with_label("New");
			gtk_notebook_set_tab_label(GTK_NOTEBOOK(blank_notebook),page,tmp_butn);
			break;		
		case 5:
			gtk_notebook_set_show_tabs(GTK_NOTEBOOK(blank_notebook),TRUE);
			gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(blank_notebook),page,"Stext");
			break;	

        }

	if(no_pages==12)
	{
                for(i=0;i<7;i++)
                        gtk_notebook_remove_page(GTK_NOTEBOOK(blank_notebook),5);
		gtk_notebook_set_scrollable(GTK_NOTEBOOK(blank_notebook),FALSE);
	}

	gtk_widget_show(blank_window);

}

void bget_prop_call(void)
{

        gint sel,page_num,no_pages;
	gboolean res;
        GtkWidget *page,*tmp_butn;
	GtkPositionType pos;

        gtk_widget_hide(blank_prop_window);

        page_num=gtk_notebook_get_current_page(GTK_NOTEBOOK(blank_notebook));
        page=gtk_notebook_get_nth_page(GTK_NOTEBOOK(blank_notebook),page_num);
        no_pages=gtk_notebook_get_n_pages(GTK_NOTEBOOK(blank_notebook));
        sel=gtk_combo_box_get_active(GTK_COMBO_BOX(blank_prop_combo));

        switch(sel)
        {
                case 0:
                        pos=gtk_notebook_get_tab_pos(GTK_NOTEBOOK(blank_notebook));
			if(pos==0)
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"GTK_POS_LEFT");				
			else if(pos==1)
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"GTK_POS_RIGHT");
			else if(pos==2)
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"GTK_POS_TOP");	
			else
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"GTK_POS_BOTTOM");
                        break;

                case 1:
			res=gtk_notebook_get_show_tabs(GTK_NOTEBOOK(blank_notebook));
			if(res==0)
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"FALSE");
			else
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"TRUE");
                        break;

                case 2:
			res=gtk_notebook_get_show_border(GTK_NOTEBOOK(blank_notebook));
			if(res==0)
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"FALSE");
			else
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"TRUE");
                        break;
                case 3:
			res=gtk_notebook_get_scrollable(GTK_NOTEBOOK(blank_notebook));
			if(res==0)
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"FALSE");
			else
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"TRUE");
                        break;
                case 4:
                        tmp_butn=gtk_notebook_get_tab_label(GTK_NOTEBOOK(blank_notebook),page);
			if(GTK_IS_LABEL(tmp_butn))
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"Label");
			else if(GTK_IS_BUTTON(tmp_butn))
				gtk_label_set_text(GTK_LABEL(blank_tmp_label),"Button");
                        break;
                case 5:
			gtk_label_set_text(GTK_LABEL(blank_tmp_label),gtk_notebook_get_tab_label_text(GTK_NOTEBOOK(blank_notebook),page));
			break;
	}

	gtk_widget_show(blank_tmp_label);
	gtk_widget_show(blank_prop_frame);
	gtk_widget_show(blank_prop_vbox);
	gtk_widget_show(blank_prop_window);

}

void blank_page_call(void)
{

        gint res,page_num,no_pages;
        GtkWidget *page;
	char str[30];

        page_num=gtk_notebook_get_current_page(GTK_NOTEBOOK(blank_notebook));
        page=gtk_notebook_get_nth_page(GTK_NOTEBOOK(blank_notebook),page_num);
        res=gtk_notebook_page_num(GTK_NOTEBOOK(blank_notebook),page);

	sprintf(str,"%d",res);
	gtk_label_set_text(GTK_LABEL(blank_page_label),str);
	gtk_widget_show(blank_page_label);

}


void rotate_notebook(void)
{
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(blank_notebook),(GTK_NOTEBOOK(blank_notebook)->tab_pos + 1) % 4);
}

			
void create_pages()
{

        for(i=4;i<=10;i++)
        {

                sprintf(buffer,"Page %d",i);
                sprintf(simple_buffer,"Page _%d",i);

                blank_frame=gtk_frame_new(buffer);
                gtk_container_set_border_width(GTK_CONTAINER(blank_frame),10);
                gtk_widget_show(blank_frame);

                blank_frame_label=gtk_label_new(buffer);
                gtk_container_add(GTK_CONTAINER(blank_frame),blank_frame_label);
                gtk_widget_show(blank_frame_label);

                blank_label=gtk_label_new_with_mnemonic(simple_buffer);
                gtk_widget_show(blank_label);

                gtk_notebook_append_page(GTK_NOTEBOOK(blank_notebook),blank_frame,blank_label);
        }

}
