/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

gint popdown_timeout (gpointer data)
{
  gtk_menu_popdown(h_menu);
  gtk_timeout_remove(h_pop_timer);
  return TRUE;
}

gint reposition_timeout (gpointer data)
{
  gtk_menu_reposition(h_menu);
  gtk_timeout_remove(h_repos_timer);
  return TRUE;
}


void popup_position_func (GtkMenu   *menu,
                     gint      *x,
                     gint      *y,
                     gboolean  *push_in,
                     gpointer   user_data)
{
   static int flag = 0;
   gtk_menu_set_monitor(menu,0);
   if(flag == 0)
   {
     *x=260;
     *y=60;
     flag=1;
     h_repos_timer = gtk_timeout_add (10000, reposition_timeout, NULL);
   }
   else
   {
     *x=300;
     *y=80;
   }
}

static gint button_press( GtkWidget *widget,
                          GdkEvent *event )
{

    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event;
        gtk_menu_popup (GTK_MENU (widget), NULL, NULL, popup_position_func, NULL,
                        bevent->button, bevent->time);
        /* Tell calling code that we have handled this event; the buck
          stops here. */
        h_pop_timer = gtk_timeout_add (20000, popdown_timeout, NULL);
        return TRUE;
    }

    /* Tell calling code that we have not handled this event; pass it on. */
    return FALSE;
}


static GtkWidget *
create_menu (gint depth, gboolean tearoff)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GSList *group;
  char buf[32];
  int i, j;

  if (depth < 1)
    return NULL;

  menu = gtk_menu_new ();
  group = NULL;

  if (tearoff)
    {
      menuitem = gtk_tearoff_menu_item_new ();
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
    }

  for (i = 0, j = 1; i < 5; i++, j++)
    {
      sprintf (buf, "item %2d - %d", depth, j);
      menuitem = gtk_radio_menu_item_new_with_label (group, buf);
      group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (menuitem));

      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
      if (i == 3)
	gtk_widget_set_sensitive (menuitem, FALSE);
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem),
				 create_menu (depth - 1, TRUE));
    }

  return menu;
}


gint detach_timeout (gpointer data)
{
  gtk_menu_detach(h_detach_menu);
  gtk_timeout_remove(h_detach_timer);
  return TRUE;
}


void
_test_menu (GtkWidget * widget, GtkWindow * parent)
{

  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *optionmenu;
  GtkWidget *separator;
  gint timer;

  GtkWidget *menubar;
  GtkWidget *menu;
  GtkWidget *submenu;
  GtkWidget *menuitem;
  GtkAccelGroup *accel_group;

  gtk_widget_hide (h_window);
  h_testmenu_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  g_signal_connect (h_testmenu_window, "delete-event", G_CALLBACK (gtk_true), NULL);

  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (h_testmenu_window), accel_group);

  gtk_window_set_title (GTK_WINDOW (h_testmenu_window), "menus");
  gtk_container_set_border_width (GTK_CONTAINER (h_testmenu_window), 0);
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (h_testmenu_window), box1);
  gtk_widget_show (box1);

  menubar = gtk_menu_bar_new ();
  gtk_box_pack_start (GTK_BOX (box1), menubar, FALSE, TRUE, 0);
  gtk_widget_show (menubar);

  menu = create_menu (2, TRUE);

  menuitem = gtk_menu_item_new_with_label ("test\nline2");
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
  gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("bar");
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), create_menu (4, TRUE));
  gtk_menu_item_set_right_justified (GTK_MENU_ITEM (menuitem), TRUE);
  gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
  gtk_widget_show (menuitem);

  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
  gtk_widget_show (box2);

  menu = create_menu (1, FALSE);
  gtk_menu_set_accel_group (GTK_MENU (menu), accel_group);

  menuitem = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
  gtk_widget_show (menuitem);

  menuitem = gtk_check_menu_item_new_with_label ("Accelerate Me");
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
  gtk_widget_show (menuitem);
  gtk_widget_add_accelerator (menuitem,
			      "activate",
			      accel_group, GDK_F1, 0, GTK_ACCEL_VISIBLE);
  menuitem = gtk_check_menu_item_new_with_label ("Accelerator Locked");
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
  gtk_widget_show (menuitem);
  gtk_widget_add_accelerator (menuitem,
			      "activate",
			      accel_group,
			      GDK_F2,
			      0, GTK_ACCEL_VISIBLE | GTK_ACCEL_LOCKED);
  menuitem = gtk_check_menu_item_new_with_label ("Accelerators Frozen");
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
  gtk_widget_show (menuitem);
  gtk_widget_add_accelerator (menuitem,
			      "activate",
			      accel_group, GDK_F2, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator (menuitem,
			      "activate",
			      accel_group, GDK_F3, 0, GTK_ACCEL_VISIBLE);

  optionmenu = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), 3);
  gtk_box_pack_start (GTK_BOX (box2), optionmenu, TRUE, TRUE, 0);
  gtk_widget_show (optionmenu);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);

  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
  gtk_widget_show (box2);

  button = gtk_button_new_with_label ("Menu ");
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  gtk_widget_show(button);
  h_detach_menu=create_menu(2,FALSE);
  gtk_menu_attach_to_widget(h_detach_menu,button,menu_detach_callback);
  gtk_button_set_label(gtk_menu_get_attach_widget(h_detach_menu),"Menu Attach"); 
  h_detach_timer = gtk_timeout_add (10000, detach_timeout, NULL);

  button = gtk_button_new_with_label ("close");
  g_signal_connect_swapped (button, "clicked",
			    G_CALLBACK (close_button), h_testmenu_window);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);
  gtk_widget_show (h_testmenu_window);
}

static void menuitem_response( gchar *string )
{
    printf ("%s\n", string);
    gtk_label_set_text(h_label,string);
}


void  create_setmenu(GtkWidget* table)
{
        gchar *menu_items_text[]={"Remove Submenu","item_select","item deselect","item_activate","set title",\
"shell_prepend","shell_insert","shell_deactivate","shell_select_item",\
"shell_select_first","shell_deselect","shell_activate_item","shell_cancel","reorder_child","Torn On",\
"right justified","toggle size request"
};

        GtkWidget* menu_item[17];
        GtkWidget* set_optionmenu;
        gint i;
	PangoFontDescription *smallfont;
	/*Get the font*/
  	smallfont = pango_font_description_from_string ("swissa 9");
        GtkWidget* option_menu = gtk_menu_new();
        for(i = 0;i < 17;i++)
        {
                menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
		gtk_widget_modify_font(GTK_BIN(menu_item[i])->child,smallfont);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (option_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        set_optionmenu = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (set_optionmenu), option_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (set_optionmenu), 1);
        gtk_widget_set_usize(set_optionmenu,250,21);
        gtk_table_attach(GTK_TABLE(table), set_optionmenu, 0, 1, 2, 3,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (set_optionmenu);

        GtkWidget *set_button = gtk_button_new_with_label("Set it now");
        gtk_widget_set_usize(set_button,250,25);
	smallfont = pango_font_description_from_string ("swissa 11");
        gtk_widget_modify_font(GTK_BIN(set_button)->child,smallfont);
        gtk_table_attach(GTK_TABLE(table), set_button, 1, 2, 2, 3,GTK_SHRINK,GTK_EXPAND,0,0);
        g_signal_connect (G_OBJECT(set_button), "clicked",
                        G_CALLBACK (setbutton_callback),
                        set_optionmenu);
        gtk_widget_show(set_button);
}

void  create_getmenu(GtkWidget* table)
{

        gchar *menu_items_text[]={"Menu Title","Right justified","Tear off state"};

        GtkWidget* menu_item[3];
        GtkWidget* get_optionmenu;
        gint i;
	PangoFontDescription *smallfont;
	/*Get the font*/
  	smallfont = pango_font_description_from_string ("swissa 9");
        GtkWidget* option_menu = gtk_menu_new();
        for(i = 0;i < 3;i++)
        {
                menu_item[i] = gtk_menu_item_new_with_label (menu_items_text[i]);
		gtk_widget_modify_font(GTK_BIN(menu_item[i])->child,smallfont);
                /* Add them to the menu */
                gtk_menu_append (GTK_MENU (option_menu), menu_item[i]);
                /* We do need to show menu items */
                gtk_widget_show (menu_item[i]);
        }

        get_optionmenu = gtk_option_menu_new ();
        gtk_option_menu_set_menu (GTK_OPTION_MENU (get_optionmenu), option_menu);
        gtk_option_menu_set_history (GTK_OPTION_MENU (get_optionmenu), 1);
        gtk_widget_set_usize(get_optionmenu,250,21);
        gtk_table_attach(GTK_TABLE(table), get_optionmenu, 0, 1, 4, 5,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show (get_optionmenu);
       
        h_getentry = gtk_entry_new ();
	smallfont = pango_font_description_from_string ("swissa 11");
        gtk_widget_modify_font(h_getentry,smallfont);
        gtk_table_attach(GTK_TABLE(table), h_getentry, 1, 2, 4, 5,GTK_SHRINK,GTK_EXPAND,0,0);
        gtk_widget_show(h_getentry);

        GtkWidget *get_button = gtk_button_new_with_label("Get it now");
        gtk_widget_set_usize(get_button,250,25);
        gtk_widget_modify_font(GTK_BIN(get_button)->child,smallfont);
        gtk_table_attach(GTK_TABLE(table), get_button, 0, 1, 5, 6,GTK_SHRINK,GTK_EXPAND,0,0);
        g_signal_connect (G_OBJECT(get_button), "clicked",
                        G_CALLBACK (getbutton_callback),
                        get_optionmenu);
}
void
_test_menu_properties (GtkWidget * widget, GtkWindow * parent)
{
    GtkWidget *table;
    GtkWidget *menu_bar;
    GtkWidget *vbox;
    GtkWidget *button;
    char buf[128];
    int i;

    gtk_widget_hide(h_window);
    /* create a new window */
    h_menu_prop_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize (GTK_WIDGET (h_menu_prop_window), 200, 100);
    gtk_window_set_title (GTK_WINDOW (h_menu_prop_window), "GTK Menu Test");
    gtk_signal_connect (GTK_OBJECT (h_menu_prop_window), "delete_event",
                        (GtkSignalFunc) gtk_main_quit, NULL);

    h_menu = gtk_menu_new ();
    gtk_menu_set_accel_path(h_menu,"<Gnumeric-Sheet>/File");


    for (i = 0; i < 3; i++)
        {
            /* Copy the names to the buf. */
            sprintf (buf, "Menu item - %d", i);

            /* Create a new menu-item with a name... */
            menu_items[i] = gtk_menu_item_new_with_label (buf);

            /* ...and add it to the menu. */
            gtk_menu_append (GTK_MENU (h_menu), menu_items[i]);

            /* Do something interesting when the menuitem is selected */
            gtk_signal_connect_object (GTK_OBJECT (menu_items[i]), "activate",
                GTK_SIGNAL_FUNC (menuitem_response), (gpointer) g_strdup (buf));

            sprintf (buf, "toggle size allocate");
            gtk_signal_connect_object (GTK_OBJECT (menu_items[i]), "toggle-size-allocate",
                GTK_SIGNAL_FUNC (menuitem_response), (gpointer) g_strdup (buf));

            sprintf (buf, "toggle size request");
            gtk_signal_connect_object (GTK_OBJECT (menu_items[i]), "toggle-size-request",
                GTK_SIGNAL_FUNC (menuitem_response), (gpointer) g_strdup (buf));

            /* Show the widget */
            gtk_widget_show (menu_items[i]);
        }

     menu_items[3] = gtk_menu_item_new_with_mnemonic("_Test mnemonic");
     gtk_menu_append (GTK_MENU (h_menu), menu_items[3]);
     gtk_signal_connect_object (GTK_OBJECT (menu_items[3]), "activate",
                GTK_SIGNAL_FUNC (menuitem_response), (gpointer) g_strdup ("Test mnemonic"));
     gtk_widget_show (menu_items[3]);
     GtkWidget *menu1 = gtk_menu_new();
     GtkWidget *menu_submenu_item = gtk_menu_item_new_with_label("Test 1");
     gtk_menu_append (GTK_MENU (menu1),menu_submenu_item );
     gtk_widget_show(menu_submenu_item);
     menu_submenu_item = gtk_menu_item_new_with_label("Test 2");
     //gtk_menu_append (GTK_MENU (menu1),menu_submenu_item );
     gtk_menu_attach (GTK_MENU (menu1), menu_submenu_item, 0, 1, 1, 2);
     gtk_widget_show(menu_submenu_item);
     gtk_menu_item_set_submenu (menu_items[3], menu1);



    /* This is the root menu, and will be the label
     * displayed on the menu bar.  There won't be a signal handler attached,
     * as it only pops up the rest of the menu when pressed. */
    h_root_menu = gtk_menu_item_new_with_mnemonic ("_Root Menu");

    gtk_widget_show (h_root_menu);

    /* Now we specify that we want our newly created "menu" to be the menu
     * for the "root menu" */
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (h_root_menu), h_menu);
    
    table = gtk_table_new (6, 2, TRUE);
    gtk_container_add (GTK_CONTAINER (h_menu_prop_window), table);

    /* Create a menu-bar to hold the menus and add it to our main window */
    menu_bar = gtk_menu_bar_new ();
    gtk_table_attach_defaults (GTK_TABLE(table), menu_bar, 0, 1, 0, 1);
    // gtk_table_attach(GTK_TABLE(table), menu_bar, 0, 1, 0, 1,GTK_SHRINK,GTK_EXPAND,1,1);
    gtk_widget_show (menu_bar);

    /* Create a button to which to attach menu as a popup */
    button = gtk_button_new_with_label ("press me");
    gtk_signal_connect_object (GTK_OBJECT (button), "event",
        GTK_SIGNAL_FUNC (button_press), GTK_OBJECT (h_menu));
    gtk_table_attach_defaults (GTK_TABLE(table), button, 1, 2, 0, 1);
    //gtk_table_attach(GTK_TABLE(table), button, 1, 2, 0, 1,GTK_SHRINK,GTK_EXPAND,1,1);
    gtk_widget_show (button);

    /* And finally we append the menu-item to the menu-bar -- this is the
     * "root" menu-item I have been raving about =) */
    gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), h_root_menu);
    button = gtk_button_new_with_label ("close");
    g_signal_connect_swapped (button, "clicked",
			    G_CALLBACK (close_button), h_menu_prop_window);
    gtk_table_attach(GTK_TABLE(table), button, 1, 2, 5, 6,GTK_SHRINK,GTK_EXPAND,0,0);
    gtk_widget_show(button);
    create_setmenu(table);
    create_getmenu(table);
    /* Create labels*/
    GtkWidget *label=gtk_label_new("Menu Response:");
    gtk_widget_set_usize(label,250,40);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,GTK_SHRINK,GTK_EXPAND,0,0);
    h_label=gtk_label_new("");
    gtk_widget_set_usize(h_label,250,40);
    gtk_table_attach(GTK_TABLE(table), h_label, 1, 2, 1, 2,GTK_SHRINK,GTK_EXPAND,0,0);
    gtk_widget_show(label);
    gtk_widget_show(h_label);
    

    /* always display the window as the last step so it all splashes on
     * the screen at once. */
    gtk_widget_show_all(table);
    gtk_widget_show (h_menu_prop_window);

}

static GtkWidget*
create_longmenu (GdkScreen *screen, gint depth, gint length, gboolean tearoff)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GtkWidget *image;
  GSList *group;
  char buf[32];
  int i, j;

  if (depth < 1)
    return NULL;

  menu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (menu), screen);

  group = NULL;

  if (tearoff)
    {
      menuitem = gtk_tearoff_menu_item_new ();
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
    }

  image = gtk_image_new_from_stock (GTK_STOCK_OPEN,
                                    GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  menuitem = gtk_image_menu_item_new_with_label ("Image item");
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menuitem), image);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
gtk_widget_show (menuitem);

  for (i = 0, j = 1; i < length; i++, j++)
    {
      sprintf (buf, "item %2d - %d", depth, j);

      menuitem = gtk_radio_menu_item_new_with_label (group, buf);
      group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (menuitem));

#if 0
      if (depth % 2)
        gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (menuitem), TRUE);
#endif

      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
      if (i == 3)
        gtk_widget_set_sensitive (menuitem, FALSE);

      if (i == 5)
        gtk_check_menu_item_set_inconsistent (GTK_CHECK_MENU_ITEM (menuitem),
                                              TRUE);

      if (i < 5)
        gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem),
                                   create_longmenu (screen, depth - 1, 5,  TRUE));
    }

  return menu;
}

static GtkWidget*
create_table_menu (GdkScreen *screen, gint cols, gint rows, gboolean tearoff)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GtkWidget *submenu;
  GtkWidget *image;
  char buf[32];
  int i, j;

  menu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (menu), screen);

  j = 0;
  if (tearoff)
    {
      menuitem = gtk_tearoff_menu_item_new ();
      gtk_menu_attach (GTK_MENU (menu), menuitem, 0, cols, j, j + 1);
      gtk_widget_show (menuitem);
      j++;
    }

  menuitem = gtk_menu_item_new_with_label ("items");
  gtk_menu_attach (GTK_MENU (menu), menuitem, 0, cols, j, j + 1);

  submenu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (submenu), screen);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
  gtk_widget_show (menuitem);
  j++;
/* now fill the items submenu */
  image = gtk_image_new_from_stock (GTK_STOCK_HELP,
                                    GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  menuitem = gtk_image_menu_item_new_with_label ("Image");
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menuitem), image);
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 0, 1);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("x");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 0, 1);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("x");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 1, 2);
  gtk_widget_show (menuitem);

  image = gtk_image_new_from_stock (GTK_STOCK_HELP,
                                    GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  menuitem = gtk_image_menu_item_new_with_label ("Image");
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menuitem), image);
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 1, 2);
  gtk_widget_show (menuitem);

  menuitem = gtk_radio_menu_item_new_with_label (NULL, "Radio");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 2, 3);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("x");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 2, 3);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("x");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 3, 4);
  gtk_widget_show (menuitem);

  menuitem = gtk_radio_menu_item_new_with_label (NULL, "Radio");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 3, 4);
  gtk_widget_show (menuitem);

  menuitem = gtk_check_menu_item_new_with_label ("Check");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 4, 5);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("x");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 4, 5);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("x");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 5, 6);
  gtk_widget_show (menuitem);

  menuitem = gtk_check_menu_item_new_with_label ("Check");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 5, 6);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("1. Inserted normally (8)");
  gtk_widget_show (menuitem);
  gtk_menu_shell_insert (GTK_MENU_SHELL (submenu), menuitem, 8);

  menuitem = gtk_menu_item_new_with_label ("2. Inserted normally (2)");
  gtk_widget_show (menuitem);
  gtk_menu_shell_insert (GTK_MENU_SHELL (submenu), menuitem, 2);

  menuitem = gtk_menu_item_new_with_label ("3. Inserted normally (0)");
  gtk_widget_show (menuitem);
  gtk_menu_shell_insert (GTK_MENU_SHELL (submenu), menuitem, 0);

  menuitem = gtk_menu_item_new_with_label ("4. Inserted normally (-1)");
  gtk_widget_show (menuitem);
  gtk_menu_shell_insert (GTK_MENU_SHELL (submenu), menuitem, -1);

  /* end of items submenu */

  menuitem = gtk_menu_item_new_with_label ("spanning");
  gtk_menu_attach (GTK_MENU (menu), menuitem, 0, cols, j, j + 1);

  submenu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (submenu), screen);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
  gtk_widget_show (menuitem);
  j++;

  /* now fill the spanning submenu */
  menuitem = gtk_menu_item_new_with_label ("a");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 2, 0, 1);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("b");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 2, 3, 0, 2);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("c");
 gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 1, 3);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("d");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 2, 1, 2);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("e");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 1, 3, 2, 3);
  gtk_widget_show (menuitem);
  /* end of spanning submenu */

  menuitem = gtk_menu_item_new_with_label ("left");
  gtk_menu_attach (GTK_MENU (menu), menuitem, 0, 1, j, j + 1);
  submenu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (submenu), screen);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("Empty");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 0, 1);
  submenu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (submenu), screen);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
  gtk_widget_show (menuitem);

  menuitem = gtk_menu_item_new_with_label ("right");
  gtk_menu_attach (GTK_MENU (menu), menuitem, 1, 2, j, j + 1);
  submenu = gtk_menu_new ();
  gtk_menu_set_screen (GTK_MENU (submenu), screen);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
  gtk_widget_show (menuitem);
  menuitem = gtk_menu_item_new_with_label ("Empty");
  gtk_menu_attach (GTK_MENU (submenu), menuitem, 0, 1, 0, 1);
  gtk_widget_show (menuitem);

  j++;

  for (; j < rows; j++)
      for (i = 0; i < cols; i++)
      {
        sprintf (buf, "(%d %d)", i, j);
        menuitem = gtk_menu_item_new_with_label (buf);
        gtk_menu_attach (GTK_MENU (menu), menuitem, i, i + 1, j, j + 1);
        gtk_widget_show (menuitem);
      }

  menuitem = gtk_menu_item_new_with_label ("1. Inserted normally (8)");
  gtk_menu_shell_insert (GTK_MENU_SHELL (menu), menuitem, 8);
  gtk_widget_show (menuitem);
  menuitem = gtk_menu_item_new_with_label ("2. Inserted normally (2)");
  gtk_menu_shell_insert (GTK_MENU_SHELL (menu), menuitem, 2);
  gtk_widget_show (menuitem);
  menuitem = gtk_menu_item_new_with_label ("3. Inserted normally (0)");
  gtk_menu_shell_insert (GTK_MENU_SHELL (menu), menuitem, 0);
  gtk_widget_show (menuitem);
  menuitem = gtk_menu_item_new_with_label ("4. Inserted normally (-1)");
  gtk_menu_shell_insert (GTK_MENU_SHELL (menu), menuitem, -1);
  gtk_widget_show (menuitem);

  return menu;
}

void
_test_longmenu(GtkWidget * widget, GtkWindow * parent)
{
  static GtkWidget *window = NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *optionmenu;
  GtkWidget *separator;

  if (!window)
    {
      GtkWidget *menubar;
      GtkWidget *menu;
      GtkWidget *menuitem;
      GtkAccelGroup *accel_group;
      GtkWidget *image;
      GdkScreen *screen = gtk_widget_get_screen (widget);

      window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

      gtk_window_set_screen (GTK_WINDOW (window), screen);

      g_signal_connect (window, "destroy",
                        G_CALLBACK (gtk_widget_destroyed),
                        &window);
      g_signal_connect (window, "delete-event",
                        G_CALLBACK (gtk_true),
                        NULL);

      accel_group = gtk_accel_group_new ();
      gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
gtk_window_set_title (GTK_WINDOW (window), "menus");
      gtk_container_set_border_width (GTK_CONTAINER (window), 0);


      box1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (window), box1);
      gtk_widget_show (box1);

      menubar = gtk_menu_bar_new ();
      gtk_box_pack_start (GTK_BOX (box1), menubar, FALSE, TRUE, 0);
      gtk_widget_show (menubar);

      menu = create_longmenu (screen, 2, 50, TRUE);

      menuitem = gtk_menu_item_new_with_label ("test\nline2");
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
      gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
      gtk_widget_show (menuitem);

      menu = create_table_menu (screen, 2, 50, TRUE);

      menuitem = gtk_menu_item_new_with_label ("table");
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
      gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
      gtk_widget_show (menuitem);

      menuitem = gtk_menu_item_new_with_label ("foo");
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), create_longmenu (screen, 3, 5, TRUE));
      gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
      gtk_widget_show (menuitem);
 image = gtk_image_new_from_stock (GTK_STOCK_HELP,
                                        GTK_ICON_SIZE_MENU);
      gtk_widget_show (image);
      menuitem = gtk_image_menu_item_new_with_label ("Help");
      gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menuitem), image);
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), create_longmenu (screen, 4, 5, TRUE));
      gtk_menu_item_set_right_justified (GTK_MENU_ITEM (menuitem), TRUE);
      gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
      gtk_widget_show (menuitem);

      menubar = gtk_menu_bar_new ();
      gtk_box_pack_start (GTK_BOX (box1), menubar, FALSE, TRUE, 0);
      gtk_widget_show (menubar);

      menu = create_longmenu (screen, 2, 10, TRUE);

      menuitem = gtk_menu_item_new_with_label ("Second menu bar");
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
      gtk_menu_shell_append (GTK_MENU_SHELL (menubar), menuitem);
      gtk_widget_show (menuitem);

      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
      gtk_widget_show (box2);

      menu = create_longmenu (screen, 1, 5, FALSE);
      gtk_menu_set_accel_group (GTK_MENU (menu), accel_group);

      menuitem = gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, accel_group);
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);

      menuitem = gtk_check_menu_item_new_with_label ("Accelerate Me");
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
      gtk_widget_add_accelerator (menuitem,
                                  "activate",
                                  accel_group,
                                  GDK_F1,
                                  0,
                                  GTK_ACCEL_VISIBLE);
      menuitem = gtk_check_menu_item_new_with_label ("Accelerator Locked");
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
      gtk_widget_add_accelerator (menuitem,
                                  "activate",
                                  accel_group,
                                  GDK_F2,
                                  0,
                                  GTK_ACCEL_VISIBLE | GTK_ACCEL_LOCKED);
      menuitem = gtk_check_menu_item_new_with_label ("Accelerators Frozen");
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menuitem);
      gtk_widget_show (menuitem);
      gtk_widget_add_accelerator (menuitem,
                                  "activate",
                                  accel_group,
                                  GDK_F2,
                                  0,
                                  GTK_ACCEL_VISIBLE);
      gtk_widget_add_accelerator (menuitem,
                                  "activate",
                               accel_group,
                                  GDK_F3,
                                  0,
                                  GTK_ACCEL_VISIBLE);

      optionmenu = gtk_option_menu_new ();
      gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
      gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), 3);
      gtk_box_pack_start (GTK_BOX (box2), optionmenu, TRUE, TRUE, 0);
      gtk_widget_show (optionmenu);

      separator = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
      gtk_widget_show (separator);

      box2 = gtk_vbox_new (FALSE, 10);
      gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
      gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
      gtk_widget_show (box2);

      button = gtk_button_new_with_label ("close");
      g_signal_connect_swapped (button, "clicked",
                                G_CALLBACK (gtk_widget_hide),
                                window);
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);
    }
if (!GTK_WIDGET_VISIBLE (window))
    gtk_widget_show (window);
  else
	  
    gtk_widget_destroy (window);


}

GtkWidget *
create_main_window (void)
{
  GtkWidget *buttons[4];
  GtkWidget *vbox = gtk_vbox_new (FALSE, 0);
  GtkWidget *hbox = gtk_hbox_new (FALSE, 0);

  h_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_add (GTK_CONTAINER (h_window), vbox);

  buttons[0] = gtk_button_new_with_label (_("Test Menu"));
  gtk_box_pack_start (GTK_BOX (vbox), buttons[0], FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (buttons[0]), "clicked",
		    G_CALLBACK (_test_menu), h_window);

  buttons[1] = gtk_button_new_with_label (_("Test Menu Properties"));
  gtk_box_pack_start (GTK_BOX (vbox), buttons[1], FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (buttons[1]), "clicked",
		    G_CALLBACK (_test_menu_properties), h_window);

  buttons[2] = gtk_button_new_with_label (_("Long Menu"));
  gtk_box_pack_start (GTK_BOX (vbox), buttons[2], FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (buttons[2]), "clicked",
		    G_CALLBACK (_test_longmenu), h_window);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  buttons[3] = gtk_button_new_from_stock(GTK_STOCK_QUIT);
  gtk_box_pack_end (GTK_BOX (vbox), buttons[3], FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (buttons[3]), "clicked", G_CALLBACK (gtk_main_quit), NULL);

  gtk_widget_show_all (vbox);
  gtk_widget_show (h_window);
}
