/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

void
close_button               (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(user_data);
  gtk_widget_show(h_window);
}


void
setbutton_callback              (GtkButton       *button,
                                        gpointer         user_data)
{

        GtkWidget *menuitem;
        GtkWidget *menu;
        gint req;
        gint menu_indx = gtk_option_menu_get_history(user_data);

        switch(menu_indx)
        {
                case 0:
                   {
                   /*Remove Menu item 3*/
                   gtk_menu_item_remove_submenu(menu_items[3]);
                   break;
                   }
                case 1:
                    /* Select Menu Item 2*/
                    gtk_menu_item_select(menu_items[2]);
                    break;
                case 2:
                    /* Deselect Menu Item 2*/
                    gtk_menu_item_deselect(menu_items[2]);
                    break;
                case 3:
                    /* Activate  Menu Item 2*/
                    gtk_menu_item_activate(menu_items[2]);
                    break;
                case 4:
                    /* Set Menu Title in torn off state*/
                    gtk_menu_set_title(h_menu,"Main Menu");
                    gtk_menu_set_tearoff_state(h_menu,TRUE);
                    break;
                case 5:
                    /* Prepend Menu*/
                    menuitem = gtk_menu_item_new_with_label("Prepend Menu Item also to test the ellipses when the name of the menuitem is long");
                    gtk_menu_shell_prepend (GTK_MENU_SHELL (h_menu), menuitem);
  		    gtk_widget_show (menuitem);
                    break;
                case 6:
                    /* Insert Menu Item*/
                    menuitem = gtk_menu_item_new_with_label("Insert Menu Item");
                    gtk_menu_shell_insert (GTK_MENU_SHELL (h_menu), menuitem,2);
  		    gtk_widget_show (menuitem);
                    break;
                case 7:
                    /* Deactivate Menu Shell 2*/
                    gtk_menu_shell_deactivate(h_menu);
                    break;
                case 8:
                    /* Select Shell Item*/
                    gtk_menu_shell_select_item(h_menu,menu_items[1]);
                    break;
                case 9:
                    /* Select first item 2*/
                    menu = gtk_menu_item_get_submenu(menu_items[3]);
                    gtk_menu_shell_select_first(menu,TRUE);
                    break;
                case 10:
                    /*Deselects the currently selected item from the menu shell, if any.*/
                    gtk_menu_shell_deselect(h_menu);
                    break;
                case 11:
                    /*Activates the menu item within the menu shell*/
                    gtk_menu_shell_activate_item(h_menu,menu_items[1],TRUE);
                    break;
                case 12:
                    /* Cancels the selection within the menu shell*/
                    gtk_menu_shell_cancel(h_menu);
                    break;
                case 13:
                    /* Moves a GtkMenuItem to a new position within the GtkMenu.*/
                    gtk_menu_reorder_child(h_menu,menu_items[3],1);
                    break;
                case 14:
                    /* set tear off state*/
                    gtk_menu_set_tearoff_state(h_menu,TRUE);
                    break;
                case 15:
                    /* Right justification*/
                    gtk_menu_item_set_right_justified(h_root_menu,TRUE);
                    break;
                case 16:
                    /* Toggle size request*/
                    gtk_menu_item_toggle_size_request(menu_items[1],&req);
                    break;
   		default:
                    break;
        }


}


void
getbutton_callback               (GtkButton       *button,
                                        gpointer         user_data)
{
        gint menu_indx = gtk_option_menu_get_history(user_data);

        switch(menu_indx)
        {
                case 0:
                  gtk_entry_set_text(GTK_ENTRY(h_getentry),gtk_menu_get_title(h_menu));
                  break;
                case 1:
                  if(gtk_menu_item_get_right_justified(h_root_menu)==TRUE)
                  {
			gtk_entry_set_text(h_getentry,"Right justified");
                  }
                  else
                  {
			gtk_entry_set_text(h_getentry,"Left justified");
		  }
                  break;
                case 2:
                  /* Get torn off state*/
                  if(gtk_menu_get_tearoff_state(h_menu)==TRUE)
                  {
			gtk_entry_set_text(h_getentry,"Torn On");
		  }
                  else
		  {
			gtk_entry_set_text(h_getentry,"Torn Off");
		  }
		  break;

                defaults:
                  break; 
        }

}

void        menu_detach_callback       (GtkWidget *attach_widget,
                                             GtkMenu *menu)
{
	gtk_button_set_label(attach_widget,"Menu Detached");
}
