/*
 * This file is part of osso-teema-testapp
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Luc Pionchon <luc.pionchon@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "callbacks.h"
#include "interface.h"

//Action on clicking the 'return' button in the second window
void on_ret(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(d_window);
	gtk_widget_show(window);
}

//Action on hitting 'Enter' hardkey on entering a text in the entry field 
void on_change()
{
	gint i;
	gtk_label_set_use_markup(GTK_LABEL(Label), FALSE);
        gtk_label_set_use_underline(GTK_LABEL(Label), FALSE);
	i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
        if( i == 0 )
	{
		str=gtk_entry_get_text(GTK_ENTRY(Entry));
		gtk_label_set_text(GTK_LABEL(Label), str);
		gtk_widget_hide(d_window);
		gtk_widget_show(window);
	}
	else if ( i == 1 )
	{
		str=gtk_entry_get_text(GTK_ENTRY(Entry));
		gtk_label_set_markup(GTK_LABEL(Label), str);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
	}
	else if ( i == 2)
	{
		str=gtk_entry_get_text(GTK_ENTRY(Entry));
		gtk_label_set_pattern(GTK_LABEL(Label), str);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
	}
	else if ( i == 4 )
	{
		str=gtk_entry_get_text(GTK_ENTRY(Entry));
		gtk_label_set_markup_with_mnemonic(GTK_LABEL(Label), str);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
	}
	else if ( i == 5 )
	{
		str=gtk_entry_get_text(GTK_ENTRY(Entry));
		gtk_label_set_text_with_mnemonic(GTK_LABEL(Label), str);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
	}
	else if ( i == 6 )
	{
		str=gtk_entry_get_text(GTK_ENTRY(Entry));
		gtk_label_set_use_markup(GTK_LABEL(Label), TRUE);
		gtk_label_set_use_underline(GTK_LABEL(Label), TRUE);
		gtk_label_set_label(GTK_LABEL(Label), str);
		gtk_widget_hide(d_window);
                gtk_widget_show(window);
				
	}
		
			
}

//Action on selecting items from 'Set Properties' option menu
void menuoptions(GtkWidget *button, gpointer data)
{
	gint i;
	i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu));
	if( i == 0 || i == 1 || i == 2 || i == 4 || i == 5 || i == 6 )
	{
		gtk_widget_set_sensitive(Lentry, TRUE);
		gtk_widget_set_sensitive(Entry, TRUE);
	}
	else if ( i == 3 )
	{
		gtk_widget_hide(d_window);
		hbox5=gtk_hbox_new(FALSE, 10);
		hbox6=gtk_hbox_new(FALSE, 10);
		hbox25=gtk_hbox_new(FALSE, 10);
		vbox2=gtk_vbox_new(FALSE, 10);
		vbox22=gtk_vbox_new(FALSE, 0);
		vbox23=gtk_vbox_new(FALSE, 0);
		vbox24=gtk_vbox_new(FALSE, 0);
		
		
	        j_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_container_set_border_width(GTK_CONTAINER(j_window), 30);
		gtk_window_set_title(GTK_WINDOW(j_window), "GtkLabel");

		framel=gtk_frame_new(" ");
		gtk_widget_set_usize(framel, 250, 170);
		gtk_frame_set_shadow_type(GTK_FRAME(framel), GTK_SHADOW_ETCHED_OUT);
                gtk_frame_set_label_align(GTK_FRAME(framel), 0.5, 0.5);

		framer=gtk_frame_new(" ");
                gtk_widget_set_usize(framer, 250, 170);
                gtk_frame_set_shadow_type(GTK_FRAME(framer), GTK_SHADOW_ETCHED_OUT);
                gtk_frame_set_label_align(GTK_FRAME(framer), 0.5, 0.5);

		framec=gtk_frame_new(" ");
                gtk_widget_set_usize(framec, 250, 170);
                gtk_frame_set_shadow_type(GTK_FRAME(framec), GTK_SHADOW_ETCHED_OUT);
                gtk_frame_set_label_align(GTK_FRAME(framec), 0.5, 0.5);

		Ljust=gtk_label_new("This is a long text !");
		gtk_widget_set_usize(Ljust, 200,100); 
		gtk_label_set_line_wrap(GTK_LABEL(Ljust), TRUE);
		gtk_label_set_justify(GTK_LABEL(Ljust), GTK_JUSTIFY_FILL);
		gtk_label_set_justify(GTK_LABEL(Ljust), GTK_JUSTIFY_LEFT);
		gtk_box_pack_start(GTK_BOX(vbox22), Ljust, FALSE, 0, 0);

		j=gtk_label_get_justify(GTK_LABEL(Ljust));
		if ( j == 0)
			Lj1=gtk_label_new("LEFT ALIGN");
		gtk_box_pack_start(GTK_BOX(vbox22), Lj1, FALSE, 0, 3);
		
		gtk_container_add(GTK_CONTAINER(framel), vbox22);
		gtk_box_pack_start(GTK_BOX(hbox5), framel, FALSE, 0, 3);

		Ljust_r=gtk_label_new("This is a long text !");
		gtk_widget_set_usize(Ljust_r, 200,100);
		gtk_label_set_line_wrap(GTK_LABEL(Ljust_r), TRUE);
		gtk_label_set_justify(GTK_LABEL(Ljust_r), GTK_JUSTIFY_FILL);
		gtk_label_set_justify(GTK_LABEL(Ljust_r), GTK_JUSTIFY_RIGHT);
		gtk_box_pack_start(GTK_BOX(vbox23), Ljust_r, FALSE, 0, 3);

		j=gtk_label_get_justify(GTK_LABEL(Ljust_r));
                if ( j == 1 )
                         Lj2=gtk_label_new("RIGHT ALIGN");
		gtk_box_pack_start(GTK_BOX(vbox23), Lj2, FALSE, 0, 3);
		gtk_container_add(GTK_CONTAINER(framer), vbox23);

		gtk_box_pack_end(GTK_BOX(hbox5), framer, FALSE, 0, 0);
		gtk_box_pack_start(GTK_BOX(vbox2), hbox5, FALSE, 0, 0);

		Ljust_c=gtk_label_new("This is a long text !");
                gtk_widget_set_usize(Ljust_c, 200,100);
                gtk_label_set_line_wrap(GTK_LABEL(Ljust_c), TRUE);
		gtk_label_set_justify(GTK_LABEL(Ljust), GTK_JUSTIFY_FILL);
                gtk_label_set_justify(GTK_LABEL(Ljust_c), GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(vbox24), Ljust_c, FALSE, 0, 3);

		j=gtk_label_get_justify(GTK_LABEL(Ljust_c));
                if ( j == 2 )
			Lj3=gtk_label_new("CENTER ALIGN");
                gtk_box_pack_start(GTK_BOX(vbox24), Lj3, FALSE, 0, 3);
				
                gtk_container_add(GTK_CONTAINER(framec), vbox24);
                gtk_box_pack_start(GTK_BOX(hbox6), framec, TRUE, 0, 0);
		gtk_box_pack_start(GTK_BOX(vbox2), hbox6, FALSE, 0, 0);
		
                if(gtk_label_get_line_wrap(GTK_LABEL(Ljust_c)))
			wrap=gtk_label_new("Line Wrap: TRUE");
		else
			wrap=gtk_label_new("Line Wrap: FALSE");
		gtk_box_pack_start(GTK_BOX(hbox25), wrap, FALSE, 0, 0 );

		Bret=gtk_button_new_with_label("Return");
		gtk_box_pack_end(GTK_BOX(hbox25), Bret, FALSE, 0, 0);
		gtk_box_pack_end(GTK_BOX(vbox2), hbox25, FALSE, 0, 0);
		
		gtk_signal_connect(GTK_OBJECT(Bret), "clicked", GTK_SIGNAL_FUNC(on_ret), NULL);

				

		gtk_container_add(GTK_CONTAINER(j_window), vbox2);
		gtk_widget_show_all(j_window);
					 
	}
	else if ( i == 7 )
	{
		PangoAttrList *list, *oldattr;
		PangoAttribute *attr;
		gint len;
		list=pango_attr_list_new ();
		oldattr=pango_attr_list_new ();
		oldattr=gtk_label_get_attributes(GTK_LABEL(Label));
		
		if(oldattr)
			pango_attr_list_unref( oldattr );

		
		attr=pango_attr_foreground_new(0,0,65535);
		len=strlen(gtk_label_get_text(GTK_LABEL(Label)));
		attr->start_index=0;
                attr->end_index=len;

		pango_attr_list_insert(list, attr);
		gtk_label_set_attributes(GTK_LABEL(Label), list);

		gtk_widget_hide(d_window);
		gtk_widget_show(window);
		    
	}

}

//Action on selecting an item from 'Get Properties' option menu
void menuoptions2(GtkWidget *button, gpointer data)
{
	gint i;
	gchar *str;
	i=gtk_option_menu_get_history(GTK_OPTION_MENU(option_menu2));
	if ( i == 0 )
	{
		str=gtk_label_get_text(GTK_LABEL(Label));
		gtk_entry_set_text(GTK_ENTRY(Eget), str);
	}
	else if ( i == 1 )
	{
		str=gtk_label_get_label(GTK_LABEL(Label));
		gtk_entry_set_text(GTK_ENTRY(Eget), str);
	}
	else if ( i == 2 )
	{
		gchar s[10];
		gtk_label_get_layout_offsets(GTK_LABEL(Label), &x, &y);
		sprintf(s, "%.1f",x);
		gtk_entry_set_text(GTK_ENTRY(Eget), "X:");
		gtk_entry_append_text(GTK_ENTRY(Eget), s);
		gtk_entry_append_text(GTK_ENTRY(Eget), "   ");
		sprintf(s, "%.1f",y);
		gtk_entry_append_text(GTK_ENTRY(Eget), "Y:");
		gtk_entry_append_text(GTK_ENTRY(Eget), s);
	}
	else if ( i == 3 )
	{
		gtk_widget_hide(d_window);
		gtk_widget_show(window);
		if( gtk_label_get_selectable(GTK_LABEL(Label)) )
		          gtk_label_select_region(GTK_LABEL(Label),0, 3);
		else
		   {
			   gtk_label_set_selectable(GTK_LABEL(Label), TRUE);
		           gtk_label_select_region(GTK_LABEL(Label),0, 3);
		   }
	}
	else if ( i == 4 )
	{
		gchar s[10];
		if(gtk_label_get_selection_bounds(GTK_LABEL(Label), &x, &y))
		{
			sprintf(s,"%i", x);
			gtk_entry_set_text(GTK_ENTRY(Eget), "Start:");
			gtk_entry_append_text(GTK_ENTRY(Eget), s);
			gtk_entry_append_text(GTK_ENTRY(Eget), "  ");
			sprintf(s,"%i", y);
			gtk_entry_append_text(GTK_ENTRY(Eget), "End:");
			gtk_entry_append_text(GTK_ENTRY(Eget), s);
		}
	}
	else if ( i == 5 )
	{
		if(gtk_label_get_use_underline(GTK_LABEL(Label)))
			gtk_entry_set_text(GTK_ENTRY(Eget), "TRUE");
		else
			gtk_entry_set_text(GTK_ENTRY(Eget), "FALSE");		
	}
	else if ( i == 6 )
	{
		if(gtk_label_get_use_markup(GTK_LABEL(Label)))
			gtk_entry_set_text(GTK_ENTRY(Eget), "TRUE");
		else
			gtk_entry_set_text(GTK_ENTRY(Eget), "FALSE");
	}
	else if ( i == 7 )
	{
		GtkWidget *widget;
		widget=gtk_label_get_mnemonic_widget(GTK_LABEL(Lm));
		if(widget == NULL )
			gtk_entry_set_text(GTK_ENTRY(Eget), "FALSE");
		else
			gtk_entry_set_text(GTK_ENTRY(Eget), "TRUE");
	}
	else if ( i == 8 )
	{
		guint x;
		x=gtk_label_get_mnemonic_keyval(GTK_LABEL(Lm));
		if( x == 111 )
			gtk_entry_set_text(GTK_ENTRY(Eget), "Key set : 'o'");
		else
			gtk_entry_set_text(GTK_ENTRY(Eget), "No key!");
	}
	else if ( i == 9 )
	{
		gchar s[20];
		PangoLayout *layout;
		layout=gtk_label_get_layout(GTK_LABEL(Label));
		pango_layout_get_size (layout, &x, &y);
		sprintf(s, "%.1f", x);
		gtk_entry_set_text(GTK_ENTRY(Eget), "X:");
		gtk_entry_append_text(GTK_ENTRY(Eget), s);
		gtk_entry_append_text(GTK_ENTRY(Eget), "  ");
		gtk_entry_append_text(GTK_ENTRY(Eget), "Y:");
		sprintf(s, "%.1f", y);
		gtk_entry_append_text(GTK_ENTRY(Eget), s);
		
	}
	
}

//Action on clicking 'Properties' button in the first window
void on_prop(GtkWidget *button, gpointer data)
{
	gtk_widget_hide(window);
	d_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_container_set_border_width(GTK_CONTAINER(d_window), 30);
	gtk_window_set_title(GTK_WINDOW(d_window), "GtkLabel");

	hbox3=gtk_hbox_new(FALSE, 10);
	hbox33=gtk_hbox_new(FALSE, 10);
	hbox34=gtk_hbox_new(FALSE, 10);
	hbox4=gtk_hbox_new(FALSE, 80);
	
	vbox1=gtk_vbox_new(FALSE, 30);

	frame1=gtk_frame_new(" ");
        gtk_frame_set_shadow_type(GTK_FRAME(frame1), GTK_SHADOW_ETCHED_OUT);
        gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0.5);
        gtk_container_add(GTK_CONTAINER(d_window), frame1);

	Lset=gtk_label_new("Set Properties:");
	gtk_box_pack_start(GTK_BOX(hbox3), Lset, FALSE, 0, 0);

	option_menu=gtk_option_menu_new();
        gtk_widget_set_usize(GTK_WIDGET(option_menu), 400, 50);
        menu=gtk_menu_new();
	
	menu_item=gtk_menu_item_new_with_label("Set Text");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);
	
	menu_item=gtk_menu_item_new_with_label("Set Markup");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Pattern");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Justify");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Markup with Mnemonic");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Text with Mnemonic");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Label");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

	menu_item=gtk_menu_item_new_with_label("Set Attributes");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu),menu_item);

		
	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu),menu);
        gtk_box_pack_start(GTK_BOX(hbox3), option_menu, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, 0, 0);

	Lentry=gtk_label_new("Set Here:");
	gtk_widget_set_sensitive(Lentry, FALSE);
	gtk_box_pack_start(GTK_BOX(hbox4), Lentry, FALSE, 0, 0);
	
	Entry=gtk_entry_new();
	gtk_widget_set_usize(Entry, 300, 40);
	gtk_widget_set_sensitive(Entry, FALSE);
	gtk_box_pack_start(GTK_BOX(hbox4), Entry, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox4, FALSE, 0, 0);
	gtk_container_add(GTK_CONTAINER(frame1), vbox1);
	
	Lget=gtk_label_new("Get Properties:");
        gtk_box_pack_start(GTK_BOX(hbox33), Lget, FALSE, 0, 0);
		
	option_menu2=gtk_option_menu_new();
        gtk_widget_set_usize(GTK_WIDGET(option_menu2), 400, 50);
        menu2=gtk_menu_new();
			                                                                                                   
	menu_item2=gtk_menu_item_new_with_label("Get Text");
	gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get Label");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get Layout Offsets");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Select Region [0-3] ");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get Selection Bounds");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Underline?");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Markup?");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Mnemonic Widget?");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get Mnemonic Keyvalue");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);

	menu_item2=gtk_menu_item_new_with_label("Get Pango Layout");
        gtk_menu_shell_append(GTK_MENU_SHELL(menu2),menu_item2);


	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu2),menu2);
	gtk_box_pack_start(GTK_BOX(hbox33), option_menu2, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox33, FALSE, 0, 0);

	Eget=gtk_entry_new();
	gtk_widget_set_usize(Eget, 400, 40);
	gtk_box_pack_start(GTK_BOX(hbox34), Eget, FALSE, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox34, FALSE, 0, 0);

	/*-------------------------Signal Handler---------------------------------------------*/
	gtk_signal_connect(GTK_OBJECT(option_menu), "changed" , GTK_SIGNAL_FUNC(menuoptions), NULL);
	gtk_signal_connect(GTK_OBJECT(Entry), "activate", GTK_SIGNAL_FUNC(on_change), NULL);
	gtk_signal_connect(GTK_OBJECT(option_menu2), "changed" , GTK_SIGNAL_FUNC(menuoptions2), NULL);
	
	gtk_widget_show_all(d_window);
}
		
